/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.resolver.validator;

import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.spi.validator.Validator;

public class MavenValidator
implements Validator {
    protected boolean containsPlaceholder(String value) {
        return value != null && value.contains("${");
    }

    public void validateArtifact(Artifact artifact) throws IllegalArgumentException {
        if (this.containsPlaceholder(artifact.getGroupId()) || this.containsPlaceholder(artifact.getArtifactId()) || this.containsPlaceholder(artifact.getVersion()) || this.containsPlaceholder(artifact.getClassifier()) || this.containsPlaceholder(artifact.getExtension())) {
            throw new IllegalArgumentException("Not fully interpolated artifact " + artifact);
        }
    }

    public void validateMetadata(Metadata metadata) throws IllegalArgumentException {
        if (this.containsPlaceholder(metadata.getGroupId()) || this.containsPlaceholder(metadata.getArtifactId()) || this.containsPlaceholder(metadata.getVersion()) || this.containsPlaceholder(metadata.getType())) {
            throw new IllegalArgumentException("Not fully interpolated metadata " + metadata);
        }
    }

    public void validateDependency(Dependency dependency) throws IllegalArgumentException {
        Artifact artifact = dependency.getArtifact();
        if (this.containsPlaceholder(artifact.getGroupId()) || this.containsPlaceholder(artifact.getArtifactId()) || this.containsPlaceholder(artifact.getVersion()) || this.containsPlaceholder(artifact.getClassifier()) || this.containsPlaceholder(artifact.getExtension()) || this.containsPlaceholder(dependency.getScope()) || dependency.getExclusions().stream().anyMatch(e -> this.containsPlaceholder(e.getGroupId()) || this.containsPlaceholder(e.getArtifactId()) || this.containsPlaceholder(e.getClassifier()) || this.containsPlaceholder(e.getExtension()))) {
            throw new IllegalArgumentException("Not fully interpolated dependency " + dependency);
        }
    }

    public void validateLocalRepository(LocalRepository localRepository) throws IllegalArgumentException {
        if (this.containsPlaceholder(localRepository.getBasePath().toString()) || this.containsPlaceholder(localRepository.getContentType()) || this.containsPlaceholder(localRepository.getId())) {
            throw new IllegalArgumentException("Not fully interpolated local repository " + localRepository);
        }
    }

    public void validateRemoteRepository(RemoteRepository remoteRepository) throws IllegalArgumentException {
        if (this.containsPlaceholder(remoteRepository.getUrl()) || this.containsPlaceholder(remoteRepository.getContentType()) || this.containsPlaceholder(remoteRepository.getId())) {
            throw new IllegalArgumentException("Not fully interpolated remote repository " + remoteRepository);
        }
    }
}

