/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.impl.resolver;

import java.lang.invoke.CallSite;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.api.RemoteRepository;
import org.apache.maven.api.Session;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.model.Model;
import org.apache.maven.api.services.ModelBuilder;
import org.apache.maven.api.services.ModelBuilderException;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.ModelBuilderResult;
import org.apache.maven.api.services.ModelProblem;
import org.apache.maven.api.services.ProblemCollector;
import org.apache.maven.api.services.Sources;
import org.apache.maven.api.services.model.ModelResolverException;
import org.apache.maven.impl.InternalSession;
import org.apache.maven.impl.RequestTraceHelper;
import org.apache.maven.impl.model.ModelProblemUtils;
import org.apache.maven.impl.resolver.ArtifactDescriptorReaderDelegate;
import org.apache.maven.impl.resolver.ArtifactDescriptorUtils;
import org.apache.maven.impl.resolver.MavenArtifactRelocationSource;
import org.apache.maven.impl.resolver.MavenWorkspaceReader;
import org.eclipse.aether.RepositoryEvent;
import org.eclipse.aether.RepositoryException;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.impl.ArtifactDescriptorReader;
import org.eclipse.aether.impl.ArtifactResolver;
import org.eclipse.aether.impl.RepositoryEventDispatcher;
import org.eclipse.aether.impl.VersionResolver;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.resolution.ArtifactDescriptorException;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicy;
import org.eclipse.aether.resolution.ArtifactDescriptorPolicyRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorRequest;
import org.eclipse.aether.resolution.ArtifactDescriptorResult;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.VersionRequest;
import org.eclipse.aether.resolution.VersionResolutionException;
import org.eclipse.aether.resolution.VersionResult;
import org.eclipse.aether.transfer.ArtifactNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Named
@Singleton
public class DefaultArtifactDescriptorReader
implements ArtifactDescriptorReader {
    private final VersionResolver versionResolver;
    private final ArtifactResolver artifactResolver;
    private final RepositoryEventDispatcher repositoryEventDispatcher;
    private final ModelBuilder modelBuilder;
    private final Map<String, MavenArtifactRelocationSource> artifactRelocationSources;
    private final ArtifactDescriptorReaderDelegate delegate;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Inject
    public DefaultArtifactDescriptorReader(VersionResolver versionResolver, ArtifactResolver artifactResolver, ModelBuilder modelBuilder, RepositoryEventDispatcher repositoryEventDispatcher, Map<String, MavenArtifactRelocationSource> artifactRelocationSources) {
        this.versionResolver = Objects.requireNonNull(versionResolver, "versionResolver cannot be null");
        this.artifactResolver = Objects.requireNonNull(artifactResolver, "artifactResolver cannot be null");
        this.modelBuilder = Objects.requireNonNull(modelBuilder, "modelBuilder cannot be null");
        this.repositoryEventDispatcher = Objects.requireNonNull(repositoryEventDispatcher, "repositoryEventDispatcher cannot be null");
        this.artifactRelocationSources = Objects.requireNonNull(artifactRelocationSources, "artifactRelocationSources cannot be null");
        this.delegate = new ArtifactDescriptorReaderDelegate();
    }

    public ArtifactDescriptorResult readArtifactDescriptor(RepositorySystemSession session, ArtifactDescriptorRequest request) throws ArtifactDescriptorException {
        ArtifactDescriptorResult result = new ArtifactDescriptorResult(request);
        Model model = this.loadPom(session, request, result);
        if (model != null) {
            Map config = session.getConfigProperties();
            ArtifactDescriptorReaderDelegate delegate = (ArtifactDescriptorReaderDelegate)config.get(ArtifactDescriptorReaderDelegate.class.getName());
            if (delegate == null) {
                delegate = this.delegate;
            }
            delegate.populateResult(InternalSession.from(session), result, model);
        }
        return result;
    }

    private Model loadPom(RepositorySystemSession session, ArtifactDescriptorRequest request, ArtifactDescriptorResult result) throws ArtifactDescriptorException {
        Model model;
        RequestTrace trace = RequestTrace.newChild((RequestTrace)request.getTrace(), (Object)request);
        LinkedHashSet<CallSite> visited = new LinkedHashSet<CallSite>();
        Artifact a = request.getArtifact();
        while (true) {
            MavenWorkspaceReader mavenWorkspaceReader;
            Artifact pomArtifact = ArtifactDescriptorUtils.toPomArtifactUnconditionally(a);
            try {
                VersionRequest versionRequest = new VersionRequest(a, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                VersionResult versionResult = this.versionResolver.resolveVersion(session, versionRequest);
                a = a.setVersion(versionResult.getVersion());
                versionRequest = new VersionRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                versionRequest.setTrace(trace);
                versionResult = this.versionResolver.resolveVersion(session, versionRequest);
                pomArtifact = pomArtifact.setVersion(versionResult.getVersion());
            }
            catch (VersionResolutionException e) {
                result.addException((Exception)((Object)e));
                throw new ArtifactDescriptorException(result);
            }
            if (!visited.add((CallSite)((Object)(a.getGroupId() + ":" + a.getArtifactId() + ":" + a.getBaseVersion())))) {
                RepositoryException exception = new RepositoryException("Artifact relocations form a cycle: " + visited);
                this.invalidDescriptor(session, trace, a, (Exception)exception);
                if ((this.getPolicy(session, a, request) & 2) != 0) {
                    return null;
                }
                result.addException((Exception)exception);
                throw new ArtifactDescriptorException(result);
            }
            try {
                ArtifactRequest resolveRequest = new ArtifactRequest(pomArtifact, request.getRepositories(), request.getRequestContext());
                resolveRequest.setTrace(trace);
                ArtifactResult resolveResult = this.artifactResolver.resolveArtifact(session, resolveRequest);
                pomArtifact = resolveResult.getArtifact();
                result.setRepository(resolveResult.getRepository());
            }
            catch (ArtifactResolutionException e) {
                Throwable throwable = e.getCause();
                if (throwable instanceof ArtifactNotFoundException) {
                    ArtifactNotFoundException artifactNotFoundException = (ArtifactNotFoundException)throwable;
                    this.missingDescriptor(session, trace, a, (Exception)artifactNotFoundException);
                    if ((this.getPolicy(session, a, request) & 1) != 0) {
                        return null;
                    }
                }
                result.addException((Exception)((Object)e));
                throw new ArtifactDescriptorException(result);
            }
            WorkspaceReader workspace = session.getWorkspaceReader();
            if (workspace instanceof MavenWorkspaceReader && (model = (mavenWorkspaceReader = (MavenWorkspaceReader)workspace).findModel(pomArtifact)) != null) {
                return model;
            }
            try {
                InternalSession iSession = InternalSession.from(session);
                List<RemoteRepository> repositories = request.getRepositories().stream().map(iSession::getRemoteRepository).toList();
                String gav = pomArtifact.getGroupId() + ":" + pomArtifact.getArtifactId() + ":" + pomArtifact.getVersion();
                ModelBuilderRequest modelRequest = ModelBuilderRequest.builder().session((Session)iSession).trace(RequestTraceHelper.toMaven(request.getRequestContext(), trace)).requestType(ModelBuilderRequest.RequestType.CONSUMER_DEPENDENCY).source(Sources.resolvedSource((Path)pomArtifact.getPath(), (String)gav)).systemProperties(this.toProperties(session.getUserProperties(), session.getSystemProperties())).userProperties(Map.of()).repositoryMerging(ModelBuilderRequest.RepositoryMerging.REQUEST_DOMINANT).repositories(repositories).build();
                ModelBuilderResult modelResult = this.modelBuilder.newSession().build(modelRequest);
                if (modelResult.getProblemCollector().hasWarningProblems()) {
                    ProblemCollector problemCollector = modelResult.getProblemCollector();
                    int totalProblems = problemCollector.totalProblemsReported();
                    if (this.logger.isDebugEnabled()) {
                        StringBuilder sb = new StringBuilder();
                        sb.append(totalProblems).append(" ").append(totalProblems == 1 ? "problem was" : "problems were").append(" encountered while building the effective model for '").append(request.getArtifact()).append("' during ").append(RequestTraceHelper.interpretTrace(true, request.getTrace())).append("\n").append(totalProblems == 1 ? "Problem" : "Problems");
                        for (ModelProblem modelProblem : problemCollector.problems().toList()) {
                            sb.append("\n* ").append(modelProblem.getMessage()).append(" @ ").append(ModelProblemUtils.formatLocation(modelProblem, null));
                        }
                        this.logger.warn(sb.toString());
                    } else {
                        this.logger.warn("{} {} encountered while building the effective model for '{}' during {} (use -X to see details)", new Object[]{totalProblems, totalProblems == 1 ? "problem was" : "problems were", request.getArtifact(), RequestTraceHelper.interpretTrace(false, request.getTrace())});
                    }
                }
                model = modelResult.getEffectiveModel();
            }
            catch (ModelBuilderException e) {
                for (ModelProblem problem : e.getResult().getProblemCollector().problems().toList()) {
                    Exception exception = problem.getException();
                    if (!(exception instanceof ModelResolverException)) continue;
                    ModelResolverException modelResolverException = (ModelResolverException)((Object)exception);
                    result.addException((Exception)((Object)modelResolverException));
                    throw new ArtifactDescriptorException(result);
                }
                this.invalidDescriptor(session, trace, a, (Exception)((Object)e));
                if ((this.getPolicy(session, a, request) & 2) != 0) {
                    return null;
                }
                result.addException((Exception)((Object)e));
                throw new ArtifactDescriptorException(result);
            }
            Artifact relocatedArtifact = this.getRelocation(session, result, model);
            if (relocatedArtifact == null) break;
            if (this.withinSameGav(relocatedArtifact, a)) {
                result.setArtifact(relocatedArtifact);
                return model;
            }
            result.addRelocation(a);
            a = relocatedArtifact;
            result.setArtifact(a);
        }
        return model;
    }

    private boolean withinSameGav(Artifact a1, Artifact a2) {
        return Objects.equals(a1.getGroupId(), a2.getGroupId()) && Objects.equals(a1.getArtifactId(), a2.getArtifactId()) && Objects.equals(a1.getVersion(), a2.getVersion());
    }

    private Map<String, String> toProperties(Map<String, String> dominant, Map<String, String> recessive) {
        HashMap<String, String> props = new HashMap<String, String>();
        if (recessive != null) {
            props.putAll(recessive);
        }
        if (dominant != null) {
            props.putAll(dominant);
        }
        return props;
    }

    private Artifact getRelocation(RepositorySystemSession session, ArtifactDescriptorResult artifactDescriptorResult, Model model) throws ArtifactDescriptorException {
        MavenArtifactRelocationSource source;
        Artifact result = null;
        Iterator<MavenArtifactRelocationSource> iterator = this.artifactRelocationSources.values().iterator();
        while (iterator.hasNext() && (result = (source = iterator.next()).relocatedTarget(session, artifactDescriptorResult, model)) == null) {
        }
        return result;
    }

    private void missingDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_MISSING);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private void invalidDescriptor(RepositorySystemSession session, RequestTrace trace, Artifact artifact, Exception exception) {
        RepositoryEvent.Builder event = new RepositoryEvent.Builder(session, RepositoryEvent.EventType.ARTIFACT_DESCRIPTOR_INVALID);
        event.setTrace(trace);
        event.setArtifact(artifact);
        event.setException(exception);
        this.repositoryEventDispatcher.dispatch(event.build());
    }

    private int getPolicy(RepositorySystemSession session, Artifact a, ArtifactDescriptorRequest request) {
        ArtifactDescriptorPolicy policy = session.getArtifactDescriptorPolicy();
        if (policy == null) {
            return 0;
        }
        return policy.getPolicy(session, new ArtifactDescriptorPolicyRequest(a, request.getRequestContext()));
    }
}

