/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.embedder;

import java.io.PrintStream;
import org.apache.maven.embedder.AbstractMavenEmbedderLogger;

public class MavenEmbedderPrintStreamLogger
extends AbstractMavenEmbedderLogger {
    private final PrintStream out;
    private static final String FATAL_ERROR = "[FATAL] ";
    private static final String ERROR = "[ERROR] ";
    private static final String WARNING = "[WARNING] ";
    private static final String INFO = "[INFO] ";
    private static final String DEBUG = "[DEBUG] ";

    public MavenEmbedderPrintStreamLogger(PrintStream out) {
        if (out == null) {
            throw new IllegalArgumentException("output stream missing");
        }
        this.out = out;
    }

    public void debug(String message, Throwable throwable) {
        if (this.isDebugEnabled()) {
            this.out.print(DEBUG);
            this.out.println(message);
            if (null != throwable) {
                throwable.printStackTrace(this.out);
            }
        }
    }

    public void info(String message, Throwable throwable) {
        if (this.isInfoEnabled()) {
            this.out.print(INFO);
            this.out.println(message);
            if (null != throwable) {
                throwable.printStackTrace(this.out);
            }
        }
    }

    public void warn(String message, Throwable throwable) {
        if (this.isWarnEnabled()) {
            this.out.print(WARNING);
            this.out.println(message);
            if (null != throwable) {
                throwable.printStackTrace(this.out);
            }
        }
    }

    public void error(String message, Throwable throwable) {
        if (this.isErrorEnabled()) {
            this.out.print(ERROR);
            this.out.println(message);
            if (null != throwable) {
                throwable.printStackTrace(this.out);
            }
        }
    }

    public void fatalError(String message, Throwable throwable) {
        if (this.isFatalErrorEnabled()) {
            this.out.print(FATAL_ERROR);
            this.out.println(message);
            if (null != throwable) {
                throwable.printStackTrace(this.out);
            }
        }
    }

    public void close() {
        if (this.out == System.out || this.out == System.err) {
            this.out.flush();
        } else {
            this.out.close();
        }
    }
}

