/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.File;
import java.util.Arrays;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.cli.CLIReportingUtils;
import org.apache.maven.cli.CLIRequestUtils;
import org.apache.maven.cli.ExecutionEventLogger;
import org.apache.maven.embedder.Configuration;
import org.apache.maven.embedder.ConfigurationValidationResult;
import org.apache.maven.embedder.DefaultConfiguration;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.embedder.MavenEmbedderConsoleLogger;
import org.apache.maven.embedder.MavenEmbedderException;
import org.apache.maven.embedder.MavenEmbedderFileLogger;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.apache.maven.exception.ExceptionSummary;
import org.apache.maven.execution.ExecutionListener;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.sonatype.plexus.components.cipher.DefaultPlexusCipher;
import org.sonatype.plexus.components.sec.dispatcher.DefaultSecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecDispatcher;
import org.sonatype.plexus.components.sec.dispatcher.SecUtil;
import org.sonatype.plexus.components.sec.dispatcher.model.SettingsSecurity;

public class MavenCli {
    public static final String LOCAL_REPO_PROPERTY = "maven.repo.local";

    public static void main(String[] args) {
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        int result = MavenCli.main(args, classWorld);
        System.exit(result);
    }

    public static int main(String[] args, ClassWorld classWorld) {
        MavenCli cli = new MavenCli();
        return cli.doMain(args, classWorld);
    }

    public int doMain(String[] args, ClassWorld classWorld) {
        MavenEmbedder mavenEmbedder;
        boolean showErrors;
        CommandLine commandLine;
        CLIManager cliManager = new CLIManager();
        try {
            commandLine = cliManager.parse(args);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line options: " + e.getMessage());
            cliManager.displayHelp();
            return 1;
        }
        boolean debug = commandLine.hasOption('X');
        boolean quiet = !debug && commandLine.hasOption('q');
        boolean bl = showErrors = debug || commandLine.hasOption('e');
        if (commandLine.hasOption('h')) {
            cliManager.displayHelp();
            return 0;
        }
        if (commandLine.hasOption('v')) {
            CLIReportingUtils.showVersion();
            return 0;
        }
        String mavenHome = System.getProperty("maven.home");
        if (mavenHome != null) {
            System.setProperty("maven.home", new File(mavenHome).getAbsolutePath());
        }
        MavenExecutionRequest request = CLIRequestUtils.buildRequest(commandLine, debug, quiet, showErrors);
        Configuration configuration = this.buildEmbedderConfiguration(request, commandLine, classWorld);
        MavenEmbedderLogger logger = configuration.getMavenEmbedderLogger();
        request.setExecutionListeners(Arrays.asList(new ExecutionListener[]{new ExecutionEventLogger(logger)}));
        if (debug || commandLine.hasOption('V')) {
            CLIReportingUtils.showVersion();
        }
        if (showErrors) {
            logger.info("Error stacktraces are turned on.");
        }
        if ("warn".equals(request.getGlobalChecksumPolicy())) {
            logger.info("Disabling strict checksum verification on all artifact downloads.");
        } else if ("fail".equals(request.getGlobalChecksumPolicy())) {
            logger.info("Enabling strict checksum verification on all artifact downloads.");
        }
        ConfigurationValidationResult cvr = MavenEmbedder.validateConfiguration(configuration);
        if (cvr.isUserSettingsFilePresent() && !cvr.isUserSettingsFileParses()) {
            CLIReportingUtils.showError(logger, "Error reading user settings: ", cvr.getUserSettingsException(), showErrors);
            return 1;
        }
        if (cvr.isGlobalSettingsFilePresent() && !cvr.isGlobalSettingsFileParses()) {
            CLIReportingUtils.showError(logger, "Error reading global settings: ", cvr.getGlobalSettingsException(), showErrors);
            return 1;
        }
        if (configuration.getGlobalSettingsFile() != null) {
            request.setGlobalSettingsFile(configuration.getGlobalSettingsFile());
        }
        if (configuration.getUserSettingsFile() != null) {
            request.setUserSettingsFile(configuration.getUserSettingsFile());
        }
        try {
            mavenEmbedder = new MavenEmbedder(configuration);
        }
        catch (MavenEmbedderException e) {
            CLIReportingUtils.showError(logger, "Unable to start the embedder: ", e, showErrors);
            return 1;
        }
        try {
            if (commandLine.hasOption("emp")) {
                String passwd = commandLine.getOptionValue("emp");
                DefaultPlexusCipher cipher = new DefaultPlexusCipher();
                System.out.println(cipher.encryptAndDecorate(passwd, "settings.security"));
                return 0;
            }
            if (commandLine.hasOption("ep")) {
                String passwd = commandLine.getOptionValue("ep");
                DefaultSecDispatcher dispatcher = (DefaultSecDispatcher)mavenEmbedder.getPlexusContainer().lookup(SecDispatcher.class);
                String configurationFile = dispatcher.getConfigurationFile();
                if (configurationFile.startsWith("~")) {
                    configurationFile = System.getProperty("user.home") + configurationFile.substring(1);
                }
                String file = System.getProperty("settings.security", configurationFile);
                mavenEmbedder.getPlexusContainer().release((Object)dispatcher);
                String master = null;
                SettingsSecurity sec = SecUtil.read((String)file, (boolean)true);
                if (sec != null) {
                    master = sec.getMaster();
                }
                if (master == null) {
                    System.err.println("Master password is not set in the setting security file");
                    return 1;
                }
                DefaultPlexusCipher cipher = new DefaultPlexusCipher();
                String masterPasswd = cipher.decryptDecorated(master, "settings.security");
                System.out.println(cipher.encryptAndDecorate(passwd, masterPasswd));
                return 0;
            }
        }
        catch (Exception e) {
            System.err.println("FATAL ERROR: Error encrypting password: " + e.getMessage());
            e.printStackTrace();
            return 1;
        }
        MavenExecutionResult result = mavenEmbedder.execute(request);
        try {
            mavenEmbedder.stop();
        }
        catch (MavenEmbedderException e) {
            result.addException((Throwable)e);
        }
        if (result.hasExceptions()) {
            ExceptionSummary es = result.getExceptionSummary();
            if (es == null) {
                logger.error("", (Throwable)result.getExceptions().get(0));
            } else if (showErrors) {
                logger.error(es.getMessage(), es.getException());
            } else {
                logger.error(es.getMessage());
            }
            if ("FAIL_NEVER".equals(request.getReactorFailureBehavior())) {
                logger.info("Build failures were ignored.");
                return 0;
            }
            return 1;
        }
        return 0;
    }

    private Configuration buildEmbedderConfiguration(MavenExecutionRequest request, CommandLine commandLine, ClassWorld classWorld) {
        File userSettingsFile = commandLine.hasOption('s') ? new File(commandLine.getOptionValue('s')) : MavenEmbedder.DEFAULT_USER_SETTINGS_FILE;
        File globalSettingsFile = commandLine.hasOption("gs") ? new File(commandLine.getOptionValue("gs")) : MavenEmbedder.DEFAULT_GLOBAL_SETTINGS_FILE;
        Configuration configuration = new DefaultConfiguration().setUserSettingsFile(userSettingsFile).setGlobalSettingsFile(globalSettingsFile).setClassWorld(classWorld);
        if (commandLine.hasOption("l")) {
            File logFile = new File(request.getBaseDirectory(), commandLine.getOptionValue("l"));
            configuration.setMavenEmbedderLogger(new MavenEmbedderFileLogger(logFile));
        } else {
            configuration.setMavenEmbedderLogger(new MavenEmbedderConsoleLogger());
        }
        String localRepoProperty = request.getUserProperties().getProperty(LOCAL_REPO_PROPERTY);
        if (localRepoProperty != null) {
            configuration.setLocalRepository(new File(localRepoProperty));
        }
        return configuration;
    }
}

