/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.embedder;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.maven.embedder.Configuration;
import org.apache.maven.embedder.ContainerCustomizer;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultConfiguration
implements Configuration {
    private List<String> inactives;
    private List<String> actives;
    private File userSettings;
    private File globalSettings;
    private ContainerCustomizer customizer;
    private Properties systemProperties;
    private List<URL> extensions = new ArrayList<URL>();
    private MavenEmbedderLogger logger;
    private ClassWorld classWorld;
    private PlexusContainer parentContainer;
    private File localRepository;

    @Override
    public Configuration addActiveProfile(String profile) {
        this.getActiveProfiles().add(profile);
        return this;
    }

    @Override
    public Configuration addInactiveProfile(String profile) {
        this.getInactiveProfiles().add(profile);
        return this;
    }

    @Override
    public Configuration addActiveProfiles(List<String> profiles) {
        this.getActiveProfiles().addAll(profiles);
        return this;
    }

    @Override
    public Configuration addInactiveProfiles(List<String> profiles) {
        this.getInactiveProfiles().addAll(profiles);
        return this;
    }

    @Override
    public List<String> getActiveProfiles() {
        if (this.actives == null) {
            this.actives = new ArrayList<String>();
        }
        return this.actives;
    }

    @Override
    public List<String> getInactiveProfiles() {
        if (this.inactives == null) {
            this.inactives = new ArrayList<String>();
        }
        return this.inactives;
    }

    @Override
    public Configuration setUserSettingsFile(File user) {
        this.userSettings = user;
        return this;
    }

    @Override
    public Configuration setGlobalSettingsFile(File global) {
        this.globalSettings = global;
        return this;
    }

    @Override
    public File getUserSettingsFile() {
        return this.userSettings;
    }

    @Override
    public File getGlobalSettingsFile() {
        return this.globalSettings;
    }

    @Override
    public Configuration setConfigurationCustomizer(ContainerCustomizer customizer) {
        this.customizer = customizer;
        return this;
    }

    @Override
    public ContainerCustomizer getContainerCustomizer() {
        return this.customizer;
    }

    @Override
    public Configuration setSystemProperties(Properties properties) {
        this.systemProperties = properties;
        return this;
    }

    @Override
    public Properties getSystemProperties() {
        return this.systemProperties != null ? this.systemProperties : System.getProperties();
    }

    @Override
    public void addExtension(URL url) {
        this.extensions.add(url);
    }

    @Override
    public List<URL> getExtensions() {
        return this.extensions;
    }

    @Override
    public Configuration setMavenEmbedderLogger(MavenEmbedderLogger logger) {
        this.logger = logger;
        return this;
    }

    @Override
    public MavenEmbedderLogger getMavenEmbedderLogger() {
        return this.logger;
    }

    @Override
    public ClassWorld getClassWorld() {
        return this.classWorld;
    }

    @Override
    public Configuration setClassWorld(ClassWorld classWorld) {
        this.classWorld = classWorld;
        return this;
    }

    @Override
    public Configuration setClassLoader(ClassLoader loader) {
        this.classWorld = new ClassWorld("plexus.core", loader);
        return this;
    }

    @Override
    public PlexusContainer getParentContainer() {
        return this.parentContainer;
    }

    @Override
    public Configuration setParentContainer(PlexusContainer parentContainer) {
        this.parentContainer = parentContainer;
        return this;
    }

    @Override
    public Configuration setLocalRepository(File localRepository) {
        this.localRepository = localRepository;
        return this;
    }

    @Override
    public File getLocalRepository() {
        return this.localRepository;
    }
}

