/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.cli.CLIReportingUtils;
import org.apache.maven.cli.CLIRequestUtils;
import org.apache.maven.embedder.Configuration;
import org.apache.maven.embedder.ConfigurationValidationResult;
import org.apache.maven.embedder.DefaultConfiguration;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.embedder.MavenEmbedderConsoleLogger;
import org.apache.maven.embedder.MavenEmbedderException;
import org.apache.maven.embedder.MavenEmbedderFileLogger;
import org.apache.maven.exception.ExceptionSummary;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.codehaus.plexus.classworlds.ClassWorld;

public class MavenCli {
    public static final String LOCAL_REPO_PROPERTY = "maven.repo.local";

    public static void main(String[] args) {
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        int result = MavenCli.main(args, classWorld);
        System.exit(result);
    }

    public static int main(String[] args, ClassWorld classWorld) {
        MavenCli cli = new MavenCli();
        return cli.doMain(args, classWorld);
    }

    public int doMain(String[] args, ClassWorld classWorld) {
        MavenEmbedder mavenEmbedder;
        MavenExecutionRequest request;
        Configuration configuration;
        ConfigurationValidationResult cvr;
        String mavenHome;
        boolean showErrors;
        CommandLine commandLine;
        CLIManager cliManager = new CLIManager();
        try {
            commandLine = cliManager.parse(args);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line options: " + e.getMessage());
            cliManager.displayHelp();
            return 1;
        }
        boolean debug = commandLine.hasOption('X');
        boolean quiet = !debug && commandLine.hasOption('q');
        boolean bl = showErrors = debug || commandLine.hasOption('e');
        if (showErrors) {
            System.out.println("+ Error stacktraces are turned on.");
        }
        if (commandLine.hasOption('h')) {
            cliManager.displayHelp();
            return 0;
        }
        if (commandLine.hasOption('v')) {
            CLIReportingUtils.showVersion();
            return 0;
        }
        if (debug || commandLine.hasOption('V')) {
            CLIReportingUtils.showVersion();
        }
        if ((mavenHome = System.getProperty("maven.home")) != null) {
            System.setProperty("maven.home", new File(mavenHome).getAbsolutePath());
        }
        if ((cvr = MavenEmbedder.validateConfiguration(configuration = this.buildEmbedderConfiguration(request = CLIRequestUtils.buildRequest(commandLine, debug, quiet, showErrors), commandLine, classWorld))).isUserSettingsFilePresent() && !cvr.isUserSettingsFileParses()) {
            CLIReportingUtils.showError("Error reading user settings: ", cvr.getUserSettingsException(), showErrors);
            return 1;
        }
        if (cvr.isGlobalSettingsFilePresent() && !cvr.isGlobalSettingsFileParses()) {
            CLIReportingUtils.showError("Error reading global settings: ", cvr.getGlobalSettingsException(), showErrors);
            return 1;
        }
        if (configuration.getGlobalSettingsFile() != null) {
            request.setGlobalSettingsFile(configuration.getGlobalSettingsFile());
        }
        if (configuration.getUserSettingsFile() != null) {
            request.setUserSettingsFile(configuration.getUserSettingsFile());
        }
        try {
            mavenEmbedder = new MavenEmbedder(configuration);
        }
        catch (MavenEmbedderException e) {
            CLIReportingUtils.showError("Unable to start the embedder: ", e, showErrors);
            return 1;
        }
        MavenExecutionResult result = mavenEmbedder.execute(request);
        try {
            mavenEmbedder.stop();
        }
        catch (MavenEmbedderException e) {
            result.addException((Throwable)e);
        }
        if (result.hasExceptions()) {
            ExceptionSummary es = result.getExceptionSummary();
            if (es == null) {
                ((Exception)result.getExceptions().get(0)).printStackTrace();
            } else {
                System.out.println(es.getMessage());
                es.getException().printStackTrace();
            }
            if ("FAIL_NEVER".equals(request.getReactorFailureBehavior())) {
                System.out.println("+ Build failures were ignored.");
                return 0;
            }
            return 1;
        }
        return 0;
    }

    private Configuration buildEmbedderConfiguration(MavenExecutionRequest request, CommandLine commandLine, ClassWorld classWorld) {
        File userSettingsFile = commandLine.hasOption('s') ? new File(commandLine.getOptionValue('s')) : MavenEmbedder.DEFAULT_USER_SETTINGS_FILE;
        File globalSettingsFile = commandLine.hasOption("gs") ? new File(commandLine.getOptionValue("gs")) : MavenEmbedder.DEFAULT_GLOBAL_SETTINGS_FILE;
        Configuration configuration = new DefaultConfiguration().setUserSettingsFile(userSettingsFile).setGlobalSettingsFile(globalSettingsFile).setClassWorld(classWorld);
        if (commandLine.hasOption("l")) {
            File logFile = new File(request.getBaseDirectory(), commandLine.getOptionValue("l"));
            configuration.setMavenEmbedderLogger(new MavenEmbedderFileLogger(logFile));
        } else {
            configuration.setMavenEmbedderLogger(new MavenEmbedderConsoleLogger());
        }
        String localRepoProperty = request.getProperties().getProperty(LOCAL_REPO_PROPERTY);
        if (localRepoProperty != null) {
            configuration.setLocalRepository(new File(localRepoProperty));
        }
        return configuration;
    }
}

