/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.embedder;

import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.maven.Maven;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.handler.ArtifactHandler;
import org.apache.maven.artifact.handler.manager.ArtifactHandlerManager;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.ArtifactRepositoryFactory;
import org.apache.maven.artifact.repository.layout.ArtifactRepositoryLayout;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.embedder.Configuration;
import org.apache.maven.embedder.ConfigurationValidationResult;
import org.apache.maven.embedder.DefaultConfigurationValidationResult;
import org.apache.maven.embedder.MavenEmbedderException;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.apache.maven.embedder.MavenEmbedderLoggerManager;
import org.apache.maven.embedder.MavenEmbedderSecurityManager;
import org.apache.maven.embedder.PlexusLoggerAdapter;
import org.apache.maven.embedder.execution.MavenExecutionRequestPopulator;
import org.apache.maven.errors.CoreErrorReporter;
import org.apache.maven.errors.CoreReporterManager;
import org.apache.maven.execution.DefaultMavenExecutionRequest;
import org.apache.maven.execution.DefaultMavenExecutionResult;
import org.apache.maven.execution.DuplicateProjectException;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.execution.ReactorManager;
import org.apache.maven.extension.BuildExtensionScanner;
import org.apache.maven.extension.ExtensionScanningException;
import org.apache.maven.lifecycle.LifecycleException;
import org.apache.maven.lifecycle.LifecycleUtils;
import org.apache.maven.lifecycle.plan.BuildPlan;
import org.apache.maven.lifecycle.plan.BuildPlanner;
import org.apache.maven.model.Model;
import org.apache.maven.model.Plugin;
import org.apache.maven.model.io.xpp3.MavenXpp3Reader;
import org.apache.maven.model.io.xpp3.MavenXpp3Writer;
import org.apache.maven.monitor.event.DefaultEventDispatcher;
import org.apache.maven.monitor.event.EventDispatcher;
import org.apache.maven.plugin.InvalidPluginException;
import org.apache.maven.plugin.MavenPluginCollector;
import org.apache.maven.plugin.MavenPluginDiscoverer;
import org.apache.maven.plugin.PluginManager;
import org.apache.maven.plugin.PluginManagerException;
import org.apache.maven.plugin.PluginNotFoundException;
import org.apache.maven.plugin.descriptor.PluginDescriptorBuilder;
import org.apache.maven.plugin.version.PluginVersionNotFoundException;
import org.apache.maven.plugin.version.PluginVersionResolutionException;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.MavenProjectBuilder;
import org.apache.maven.project.MavenProjectBuildingResult;
import org.apache.maven.project.ProjectBuildingException;
import org.apache.maven.reactor.MavenExecutionException;
import org.apache.maven.reactor.MissingModuleException;
import org.apache.maven.settings.Settings;
import org.apache.maven.settings.SettingsConfigurationException;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Reader;
import org.apache.maven.settings.io.xpp3.SettingsXpp3Writer;
import org.apache.maven.settings.validation.DefaultSettingsValidator;
import org.apache.maven.settings.validation.SettingsValidationResult;
import org.apache.maven.workspace.MavenWorkspaceStore;
import org.codehaus.plexus.ContainerConfiguration;
import org.codehaus.plexus.DefaultContainerConfiguration;
import org.codehaus.plexus.DefaultPlexusContainer;
import org.codehaus.plexus.MutablePlexusContainer;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.PlexusContainerException;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.codehaus.plexus.classworlds.realm.DuplicateRealmException;
import org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.codehaus.plexus.component.discovery.ComponentDiscoverer;
import org.codehaus.plexus.component.discovery.ComponentDiscoveryListener;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.component.repository.exception.ComponentRepositoryException;
import org.codehaus.plexus.configuration.PlexusConfigurationException;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.ReaderFactory;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.WriterFactory;
import org.codehaus.plexus.util.dag.CycleDetectedException;
import org.codehaus.plexus.util.xml.XmlStreamReader;
import org.codehaus.plexus.util.xml.XmlStreamWriter;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

public class MavenEmbedder {
    public static final String DEFAULT_LOCAL_REPO_ID = "local";
    public static final String userHome = System.getProperty("user.home");
    public static final File userMavenConfigurationHome = new File(userHome, ".m2");
    public static final File defaultUserLocalRepository = new File(userMavenConfigurationHome, "repository");
    public static final File DEFAULT_USER_SETTINGS_FILE = new File(userMavenConfigurationHome, "settings.xml");
    public static final File DEFAULT_GLOBAL_SETTINGS_FILE = new File(System.getProperty("maven.home", System.getProperty("user.dir", "")), "conf/settings.xml");
    public static final String STANDALONE_MODE = "maven.mode.standalone";
    private MutablePlexusContainer container;
    private MavenProjectBuilder mavenProjectBuilder;
    private BuildExtensionScanner extensionScanner;
    private MavenXpp3Reader modelReader;
    private MavenXpp3Writer modelWriter;
    private SettingsXpp3Writer settingsWriter;
    private PluginDescriptorBuilder pluginDescriptorBuilder;
    private ArtifactRepositoryFactory artifactRepositoryFactory;
    private ArtifactFactory artifactFactory;
    private ArtifactResolver artifactResolver;
    private ArtifactRepositoryLayout defaultArtifactRepositoryLayout;
    private ArtifactHandlerManager artifactHandlerManager;
    private Maven maven;
    private MavenExecutionRequestPopulator populator;
    private BuildPlanner buildPlanner;
    private MavenWorkspaceStore workspaceStore;
    private ClassWorld classWorld;
    private ClassRealm realm;
    private MavenEmbedderLogger logger;
    private boolean activateSystemManager;
    private Configuration configuration;
    private MavenExecutionRequest request;
    private EventDispatcher dispatcher;

    public MavenEmbedder(Configuration embedderConfiguration) throws MavenEmbedderException {
        this.start(embedderConfiguration);
    }

    public MavenExecutionRequest getDefaultRequest() {
        return this.request;
    }

    protected MavenWorkspaceStore getWorkspaceStore() {
        return this.workspaceStore;
    }

    public ClassWorld getClassWorld() {
        return this.classWorld;
    }

    public ArtifactRepository getLocalRepository() {
        return this.request.getLocalRepository();
    }

    public Settings getSettings() {
        return this.request.getSettings();
    }

    public MavenEmbedderLogger getLogger() {
        return this.logger;
    }

    public void setLogger(MavenEmbedderLogger logger) {
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model readModel(File file) throws XmlPullParserException, IOException {
        XmlStreamReader reader = ReaderFactory.newXmlReader((File)file);
        try {
            Model model = this.readModel((Reader)reader);
            return model;
        }
        finally {
            IOUtil.close((Reader)reader);
        }
    }

    public Model readModel(Reader reader) throws XmlPullParserException, IOException {
        return this.modelReader.read(reader);
    }

    public void writeModel(Writer writer, Model model, boolean namespaceDeclaration) throws IOException {
        this.modelWriter.write(writer, model);
    }

    public void writeModel(Writer writer, Model model) throws IOException {
        this.modelWriter.write(writer, model);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeSettings(File file, Settings settings) throws IOException {
        DefaultSettingsValidator settingsValidator = new DefaultSettingsValidator();
        SettingsValidationResult validationResult = settingsValidator.validate(settings);
        if (validationResult.getMessageCount() > 0) {
            throw new IOException("Failed to validate Settings.\n" + validationResult.render("\n"));
        }
        SettingsXpp3Writer writer = new SettingsXpp3Writer();
        XmlStreamWriter fileWriter = WriterFactory.newXmlWriter((File)file);
        try {
            writer.write((Writer)fileWriter, settings);
        }
        finally {
            IOUtil.close((Writer)fileWriter);
        }
    }

    public static Settings readSettings(File file) throws IOException, SettingsConfigurationException {
        XmlStreamReader fileReader = ReaderFactory.newXmlReader((File)file);
        DefaultSettingsValidator settingsValidator = new DefaultSettingsValidator();
        SettingsXpp3Reader reader = new SettingsXpp3Reader();
        try {
            Settings settings = reader.read((Reader)fileReader);
            SettingsValidationResult validationResult = settingsValidator.validate(settings);
            if (validationResult.getMessageCount() > 0) {
                throw new IOException("Failed to validate Settings.\n" + validationResult.render("\n"));
            }
            Settings settings2 = settings;
            return settings2;
        }
        catch (XmlPullParserException e) {
            throw new SettingsConfigurationException("Failed to parse settings.", (Throwable)e);
        }
        finally {
            IOUtil.close((Reader)fileReader);
        }
    }

    protected void verifyPlugin(Plugin plugin, MavenProject project) throws ComponentLookupException, ArtifactResolutionException, PluginVersionResolutionException, ArtifactNotFoundException, InvalidPluginException, PluginManagerException, PluginNotFoundException, PluginVersionNotFoundException {
        PluginManager pluginManager = (PluginManager)this.container.lookup(PluginManager.ROLE);
        MavenSession session = new MavenSession((PlexusContainer)this.container, this.request, null, null);
        pluginManager.verifyPlugin(plugin, project, session);
    }

    public MavenProject readProject(File mavenProject) throws ProjectBuildingException, ExtensionScanningException, MavenExecutionException {
        CoreErrorReporter errorReporter = this.request.getErrorReporter();
        errorReporter.clearErrors();
        CoreReporterManager.setReporter((CoreErrorReporter)errorReporter);
        return this.readProject(mavenProject, this.request);
    }

    private MavenProject readProject(File mavenProject, MavenExecutionRequest request) throws ProjectBuildingException, ExtensionScanningException, MissingModuleException {
        this.getLogger().debug("Scanning for extensions: " + mavenProject);
        this.extensionScanner.scanForBuildExtensions(mavenProject, request, true);
        this.getLogger().debug("Building MavenProject instance: " + mavenProject);
        return this.mavenProjectBuilder.build(mavenProject, request.getProjectBuildingConfiguration());
    }

    public MavenExecutionResult readProjectWithDependencies(MavenExecutionRequest request) {
        MavenProjectBuildingResult projectBuildingResult;
        DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
        try {
            request = this.populator.populateDefaults(request, this.configuration);
            CoreErrorReporter errorReporter = request.getErrorReporter();
            errorReporter.clearErrors();
            CoreReporterManager.setReporter((CoreErrorReporter)errorReporter);
            this.readProject(request.getPom(), request);
        }
        catch (MavenEmbedderException e) {
            return result.addException((Throwable)e);
        }
        catch (ProjectBuildingException e) {
            return result.addException((Throwable)e);
        }
        catch (ExtensionScanningException e) {
            return result.addException((Throwable)e);
        }
        catch (MissingModuleException e) {
            return result.addException((Throwable)e);
        }
        ReactorManager reactorManager = this.maven.createReactorManager(request, (MavenExecutionResult)result);
        if (result.hasExceptions()) {
            return result;
        }
        try {
            projectBuildingResult = this.mavenProjectBuilder.buildProjectWithDependencies(request.getPom(), request.getProjectBuildingConfiguration());
        }
        catch (ProjectBuildingException e) {
            return result.addException((Throwable)e);
        }
        if (reactorManager.hasMultipleProjects()) {
            result.setProject(projectBuildingResult.getProject());
            result.setTopologicallySortedProjects(reactorManager.getSortedProjects());
        } else {
            result.setProject(projectBuildingResult.getProject());
            result.setTopologicallySortedProjects(Arrays.asList(projectBuildingResult.getProject()));
        }
        result.setArtifactResolutionResult(projectBuildingResult.getArtifactResolutionResult());
        return result;
    }

    public Artifact createArtifact(String groupId, String artifactId, String version, String scope, String type) {
        return this.artifactFactory.createArtifact(groupId, artifactId, version, scope, type);
    }

    public Artifact createArtifactWithClassifier(String groupId, String artifactId, String version, String type, String classifier) {
        return this.artifactFactory.createArtifactWithClassifier(groupId, artifactId, version, type, classifier);
    }

    public void resolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        this.artifactResolver.resolve(artifact, remoteRepositories, localRepository);
    }

    public ArtifactHandler getArtifactHandler(Artifact artifact) {
        return this.artifactHandlerManager.getArtifactHandler(artifact.getType());
    }

    public BuildPlan getBuildPlan(List goals, MavenProject project) throws MavenEmbedderException {
        return this.getBuildPlan(goals, project, false);
    }

    public BuildPlan getBuildPlan(List goals, MavenProject project, boolean allowUnbindableMojos) throws MavenEmbedderException {
        ReactorManager rm;
        DefaultMavenExecutionRequest req = new DefaultMavenExecutionRequest(this.request);
        req.setGoals(goals);
        DefaultEventDispatcher dispatcher = new DefaultEventDispatcher(req.getEventMonitors());
        try {
            rm = new ReactorManager(Collections.singletonList(project), "fail-fast");
        }
        catch (CycleDetectedException e) {
            throw new MavenEmbedderException("Cycle detected in single-project reactor manager during build-plan lookup.", e);
        }
        catch (DuplicateProjectException e) {
            throw new MavenEmbedderException("Duplicate project detected in single-project reactor manager during build-plan lookup.", e);
        }
        MavenSession session = new MavenSession((PlexusContainer)this.container, this.request, (EventDispatcher)dispatcher, rm);
        try {
            return this.buildPlanner.constructBuildPlan(goals, project, session, allowUnbindableMojos);
        }
        catch (LifecycleException e) {
            throw new MavenEmbedderException("Failed to construct build-plan for project: " + project.getId() + " using goals: '" + StringUtils.join(goals.iterator(), (String)", ") + "'", e);
        }
    }

    public List getLifecyclePhases() {
        return this.getBuildLifecyclePhases();
    }

    public List getAllLifecyclePhases() {
        return LifecycleUtils.getValidPhaseNames();
    }

    public List getDefaultLifecyclePhases() {
        return this.getBuildLifecyclePhases();
    }

    public List getBuildLifecyclePhases() {
        return LifecycleUtils.getValidBuildPhaseNames();
    }

    public List getCleanLifecyclePhases() {
        return LifecycleUtils.getValidCleanPhaseNames();
    }

    public List getSiteLifecyclePhases() {
        return LifecycleUtils.getValidSitePhaseNames();
    }

    private void start(Configuration configuration) throws MavenEmbedderException {
        this.classWorld = configuration.getClassWorld();
        this.logger = configuration.getMavenEmbedderLogger();
        try {
            if (System.getSecurityManager() == null && this.activateSystemManager) {
                System.setSecurityManager(new MavenEmbedderSecurityManager());
            }
        }
        catch (RuntimeException e) {
            this.logger.warn("Error trying to set the SecurityManager: " + e.getMessage());
        }
        this.configuration = configuration;
        try {
            ContainerConfiguration cc = new DefaultContainerConfiguration().addComponentDiscoverer((ComponentDiscoverer)new MavenPluginDiscoverer()).addComponentDiscoveryListener((ComponentDiscoveryListener)new MavenPluginCollector()).setClassWorld(this.classWorld).setParentContainer(configuration.getParentContainer()).setName("embedder");
            this.container = new DefaultPlexusContainer(cc);
        }
        catch (PlexusContainerException e) {
            throw new MavenEmbedderException("Error creating Plexus container for Maven Embedder", e);
        }
        if (this.logger != null) {
            MavenEmbedderLoggerManager loggerManager = new MavenEmbedderLoggerManager(new PlexusLoggerAdapter(this.logger));
            this.container.setLoggerManager((LoggerManager)loggerManager);
        }
        try {
            if (configuration.getContainerCustomizer() != null) {
                configuration.getContainerCustomizer().customize((PlexusContainer)this.container);
            }
            this.handleExtensions(configuration.getExtensions());
            this.modelReader = new MavenXpp3Reader();
            this.modelWriter = new MavenXpp3Writer();
            this.settingsWriter = new SettingsXpp3Writer();
            this.maven = (Maven)this.container.lookup(Maven.ROLE);
            this.pluginDescriptorBuilder = new PluginDescriptorBuilder();
            this.mavenProjectBuilder = (MavenProjectBuilder)this.container.lookup(MavenProjectBuilder.ROLE);
            this.extensionScanner = (BuildExtensionScanner)this.container.lookup(BuildExtensionScanner.ROLE);
            this.artifactRepositoryFactory = (ArtifactRepositoryFactory)this.container.lookup(ArtifactRepositoryFactory.ROLE);
            this.artifactFactory = (ArtifactFactory)this.container.lookup(ArtifactFactory.ROLE);
            this.artifactResolver = (ArtifactResolver)this.container.lookup(ArtifactResolver.ROLE, "default");
            this.defaultArtifactRepositoryLayout = (ArtifactRepositoryLayout)this.container.lookup(ArtifactRepositoryLayout.ROLE, "default");
            this.populator = (MavenExecutionRequestPopulator)this.container.lookup(MavenExecutionRequestPopulator.ROLE);
            this.buildPlanner = (BuildPlanner)this.container.lookup(BuildPlanner.class);
            this.workspaceStore = (MavenWorkspaceStore)this.container.lookup(MavenWorkspaceStore.class);
            this.artifactHandlerManager = (ArtifactHandlerManager)this.container.lookup(ArtifactHandlerManager.ROLE);
            this.request = new DefaultMavenExecutionRequest();
            this.populator.populateDefaults(this.request, configuration);
            this.dispatcher = new DefaultEventDispatcher(this.request.getEventMonitors());
        }
        catch (ComponentLookupException e) {
            throw new MavenEmbedderException("Cannot lookup required component.", e);
        }
    }

    private void handleExtensions(List extensions) throws MavenEmbedderException {
        ClassRealm childRealm;
        try {
            childRealm = this.container.getContainerRealm().createChildRealm("embedder-extensions");
        }
        catch (DuplicateRealmException e1) {
            try {
                childRealm = this.classWorld.getRealm("embedder-extensions");
            }
            catch (NoSuchRealmException e) {
                throw new MavenEmbedderException("Cannot create realm 'extensions'", e);
            }
        }
        Iterator it = extensions.iterator();
        while (it.hasNext()) {
            childRealm.addURL((URL)it.next());
        }
        try {
            this.container.discoverComponents(childRealm, true);
        }
        catch (PlexusConfigurationException e) {
            throw new MavenEmbedderException("Configuration error while discovering extension components", e);
        }
        catch (ComponentRepositoryException e) {
            throw new MavenEmbedderException("Component repository error while discovering extension components", e);
        }
    }

    public void stop() throws MavenEmbedderException {
        this.container.dispose();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConfigurationValidationResult validateConfiguration(Configuration configuration) {
        DefaultConfigurationValidationResult result = new DefaultConfigurationValidationResult();
        XmlStreamReader fileReader = null;
        if (configuration.getUserSettingsFile() != null) {
            try {
                fileReader = ReaderFactory.newXmlReader((File)configuration.getUserSettingsFile());
                result.setUserSettings(new SettingsXpp3Reader().read((Reader)fileReader));
            }
            catch (IOException e) {
                result.setUserSettingsException(e);
            }
            catch (XmlPullParserException e) {
                result.setUserSettingsException((Exception)((Object)e));
            }
            finally {
                IOUtil.close((Reader)fileReader);
            }
        }
        if (configuration.getGlobalSettingsFile() != null) {
            try {
                fileReader = ReaderFactory.newXmlReader((File)configuration.getGlobalSettingsFile());
                result.setGlobalSettings(new SettingsXpp3Reader().read((Reader)fileReader));
            }
            catch (IOException e) {
                result.setGlobalSettingsException(e);
            }
            catch (XmlPullParserException e) {
                result.setGlobalSettingsException((Exception)((Object)e));
            }
            finally {
                IOUtil.close((Reader)fileReader);
            }
        }
        return result;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean isOffline(MavenExecutionRequest request) throws MavenEmbedderException {
        request = this.populator.populateDefaults(request, this.configuration);
        return request.isOffline();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MavenExecutionResult execute(MavenExecutionRequest request) {
        LoggerManager loggerManager = this.container.getLoggerManager();
        int oldThreshold = loggerManager.getThreshold();
        try {
            loggerManager.setThresholds(request.getLoggingLevel());
            try {
                request = this.populator.populateDefaults(request, this.configuration);
            }
            catch (MavenEmbedderException e) {
                DefaultMavenExecutionResult result = new DefaultMavenExecutionResult();
                result.addException((Throwable)e);
                DefaultMavenExecutionResult defaultMavenExecutionResult = result;
                loggerManager.setThresholds(oldThreshold);
                return defaultMavenExecutionResult;
            }
            CoreErrorReporter errorReporter = request.getErrorReporter();
            errorReporter.clearErrors();
            CoreReporterManager.setReporter((CoreErrorReporter)errorReporter);
            MavenExecutionResult mavenExecutionResult = this.maven.execute(request);
            return mavenExecutionResult;
        }
        finally {
            loggerManager.setThresholds(oldThreshold);
        }
    }

    public PlexusContainer getPlexusContainer() {
        return this.container;
    }
}

