/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cli;

import java.io.File;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.ParseException;
import org.apache.maven.cli.CLIManager;
import org.apache.maven.cli.CLIReportingUtils;
import org.apache.maven.cli.CLIRequestUtils;
import org.apache.maven.embedder.Configuration;
import org.apache.maven.embedder.ConfigurationValidationResult;
import org.apache.maven.embedder.DefaultConfiguration;
import org.apache.maven.embedder.MavenEmbedder;
import org.apache.maven.embedder.MavenEmbedderConsoleLogger;
import org.apache.maven.embedder.MavenEmbedderException;
import org.apache.maven.embedder.MavenEmbedderFileLogger;
import org.apache.maven.embedder.MavenEmbedderLogger;
import org.apache.maven.errors.CoreErrorReporter;
import org.apache.maven.errors.DefaultCoreErrorReporter;
import org.apache.maven.execution.MavenExecutionRequest;
import org.apache.maven.execution.MavenExecutionResult;
import org.codehaus.plexus.classworlds.ClassWorld;

public class MavenCli {
    public static final String LOCAL_REPO_PROPERTY = "maven.repo.local";

    public static void main(String[] args) {
        ClassWorld classWorld = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
        int result = MavenCli.main(args, classWorld);
        System.exit(result);
    }

    public static int main(String[] args, ClassWorld classWorld) {
        MavenCli cli = new MavenCli();
        return cli.doMain(args, classWorld);
    }

    public int doMain(String[] args, ClassWorld classWorld) {
        MavenEmbedderLogger logger;
        MavenEmbedder mavenEmbedder;
        MavenExecutionRequest request;
        Configuration configuration;
        ConfigurationValidationResult cvr;
        boolean showErrors;
        CommandLine commandLine;
        CLIManager cliManager = new CLIManager();
        try {
            commandLine = cliManager.parse(args);
        }
        catch (ParseException e) {
            System.err.println("Unable to parse command line options: " + e.getMessage());
            cliManager.displayHelp();
            return 1;
        }
        if ("1.4".compareTo(System.getProperty("java.specification.version")) > 0) {
            System.err.println("Sorry, but JDK 1.4 or above is required to execute Maven. You appear to be using Java:");
            System.err.println("java version \"" + System.getProperty("java.version", "<unknown java version>") + "\"");
            System.err.println(System.getProperty("java.runtime.name", "<unknown runtime name>") + " (build " + System.getProperty("java.runtime.version", "<unknown runtime version>") + ")");
            System.err.println(System.getProperty("java.vm.name", "<unknown vm name>") + " (build " + System.getProperty("java.vm.version", "<unknown vm version>") + ", " + System.getProperty("java.vm.info", "<unknown vm info>") + ")");
            return 1;
        }
        boolean debug = commandLine.hasOption('X');
        boolean quiet = !debug && commandLine.hasOption('q');
        boolean bl = showErrors = debug || commandLine.hasOption('e');
        if (showErrors) {
            System.out.println("+ Error stacktraces are turned on.");
        }
        if (commandLine.hasOption('h')) {
            cliManager.displayHelp();
            return 0;
        }
        if (commandLine.hasOption('v')) {
            CLIReportingUtils.showVersion();
            return 0;
        }
        if (debug || commandLine.hasOption('V')) {
            CLIReportingUtils.showVersion();
        }
        if ((cvr = MavenEmbedder.validateConfiguration(configuration = this.buildEmbedderConfiguration(request = CLIRequestUtils.buildRequest(commandLine, debug, quiet, showErrors), commandLine, classWorld))).isUserSettingsFilePresent() && !cvr.isUserSettingsFileParses()) {
            CLIReportingUtils.showError("Error reading user settings: ", cvr.getUserSettingsException(), showErrors);
            return 1;
        }
        if (cvr.isGlobalSettingsFilePresent() && !cvr.isGlobalSettingsFileParses()) {
            CLIReportingUtils.showError("Error reading global settings: ", cvr.getGlobalSettingsException(), showErrors);
            return 1;
        }
        try {
            mavenEmbedder = new MavenEmbedder(configuration);
            logger = mavenEmbedder.getLogger();
            if (mavenEmbedder.isOffline(request)) {
                logger.info("You are working in offline mode.");
            }
        }
        catch (MavenEmbedderException e) {
            CLIReportingUtils.showError("Unable to start the embedder: ", e, showErrors);
            return 1;
        }
        MavenExecutionResult result = mavenEmbedder.execute(request);
        CLIReportingUtils.logResult(request, result, logger);
        if (result.hasExceptions()) {
            return 1;
        }
        return 0;
    }

    private Configuration buildEmbedderConfiguration(MavenExecutionRequest request, CommandLine commandLine, ClassWorld classWorld) {
        File userSettingsFile = commandLine.hasOption('s') ? new File(commandLine.getOptionValue('s')) : MavenEmbedder.DEFAULT_USER_SETTINGS_FILE;
        Configuration configuration = new DefaultConfiguration().setErrorReporter((CoreErrorReporter)new DefaultCoreErrorReporter()).setUserSettingsFile(userSettingsFile).setGlobalSettingsFile(MavenEmbedder.DEFAULT_GLOBAL_SETTINGS_FILE).setClassWorld(classWorld);
        if (commandLine.hasOption("l")) {
            File logFile = new File(request.getBaseDirectory(), commandLine.getOptionValue("l"));
            configuration.setMavenEmbedderLogger(new MavenEmbedderFileLogger(logFile));
        } else {
            configuration.setMavenEmbedderLogger(new MavenEmbedderConsoleLogger());
        }
        String localRepoProperty = request.getProperties().getProperty(LOCAL_REPO_PROPERTY);
        if (localRepoProperty != null) {
            configuration.setLocalRepository(new File(localRepoProperty));
        }
        return configuration;
    }
}

