/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.toolchain;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.toolchain.ImmutableCollections;
import org.apache.maven.api.toolchain.InputLocation;
import org.apache.maven.api.toolchain.InputLocationTracker;
import org.apache.maven.api.toolchain.ToolchainModel;
import org.apache.maven.api.toolchain.TrackableBase;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class PersistedToolchains
extends TrackableBase
implements Serializable,
InputLocationTracker {
    final String namespaceUri;
    final String modelEncoding;
    final List<ToolchainModel> toolchains;
    final Map<Object, InputLocation> locations;

    protected PersistedToolchains(Builder builder) {
        super(builder);
        String string = builder.namespaceUri != null ? builder.namespaceUri : (this.namespaceUri = builder.base != null ? builder.base.namespaceUri : null);
        String string2 = builder.modelEncoding != null ? builder.modelEncoding : (this.modelEncoding = builder.base != null ? builder.base.modelEncoding : "UTF-8");
        this.toolchains = ImmutableCollections.copy(builder.toolchains != null ? builder.toolchains : (builder.base != null ? builder.base.toolchains : null));
        Map newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        HashMap<Object, InputLocation> mutableLocations = new HashMap<Object, InputLocation>(((TrackableBase)this).locations);
        mutableLocations.put("toolchains", newlocs.containsKey("toolchains") ? (InputLocation)newlocs.get("toolchains") : (InputLocation)oldlocs.get("toolchains"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    public String getNamespaceUri() {
        return this.namespaceUri;
    }

    public String getModelEncoding() {
        return this.modelEncoding;
    }

    @Nonnull
    public List<ToolchainModel> getToolchains() {
        return this.toolchains;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Override
    public Set<Object> getLocationKeys() {
        return this.locations != null ? this.locations.keySet() : null;
    }

    @Override
    @Nonnull
    public Builder with() {
        return PersistedToolchains.newBuilder(this);
    }

    @Nonnull
    public PersistedToolchains withToolchains(Collection<ToolchainModel> toolchains) {
        return PersistedToolchains.newBuilder(this, true).toolchains(toolchains).build();
    }

    @Nonnull
    public static PersistedToolchains newInstance() {
        return PersistedToolchains.newInstance(true);
    }

    @Nonnull
    public static PersistedToolchains newInstance(boolean withDefaults) {
        return PersistedToolchains.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return PersistedToolchains.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(PersistedToolchains from) {
        return PersistedToolchains.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(PersistedToolchains from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder
    extends TrackableBase.Builder {
        PersistedToolchains base;
        String namespaceUri;
        String modelEncoding;
        Collection<ToolchainModel> toolchains;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(PersistedToolchains base, boolean forceCopy) {
            super(base, forceCopy);
            this.namespaceUri = base.namespaceUri;
            this.modelEncoding = base.modelEncoding;
            if (forceCopy) {
                this.toolchains = base.toolchains;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder namespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return this;
        }

        @Nonnull
        public Builder modelEncoding(String modelEncoding) {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder toolchains(Collection<ToolchainModel> toolchains) {
            this.toolchains = toolchains;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public PersistedToolchains build() {
            if (this.base != null && (this.toolchains == null || this.toolchains == this.base.toolchains)) {
                return this.base;
            }
            return new PersistedToolchains(this);
        }
    }
}

