// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.toolchain;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * The {@code <toolchains>} element is the root of the descriptor.
 * The following table lists all the possible child elements.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class PersistedToolchains
    extends TrackableBase
    implements Serializable, InputLocationTracker
{
    final String namespaceUri;
    final String modelEncoding;
    /**
     * The toolchain instance definition.
     */
    final List<ToolchainModel> toolchains;
    /** Locations (this potentially hides the same name field from the super class) */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected PersistedToolchains(Builder builder) {
        super(builder);
        this.namespaceUri = builder.namespaceUri != null ? builder.namespaceUri : (builder.base != null ? builder.base.namespaceUri : null);
        this.modelEncoding = builder.modelEncoding != null ? builder.modelEncoding : (builder.base != null ? builder.base.modelEncoding :  "UTF-8");
        this.toolchains = ImmutableCollections.copy(builder.toolchains != null ? builder.toolchains : (builder.base != null ? builder.base.toolchains : null));
        Map<Object, InputLocation> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map<Object, InputLocation> oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        Map<Object, InputLocation> mutableLocations = new HashMap<>(super.locations);
        mutableLocations.put("toolchains", newlocs.containsKey("toolchains") ? newlocs.get("toolchains") : oldlocs.get("toolchains"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    public String getNamespaceUri() {
        return namespaceUri;
    }

    public String getModelEncoding() {
        return modelEncoding;
    }

    /**
     * The toolchain instance definition.
     *
     * @return a {@code List<ToolchainModel>}
     */
    @Nonnull
    public List<ToolchainModel> getToolchains() {
        return this.toolchains;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
    * Gets the keys of the locations of the input source.
    */
    public Set<Object> getLocationKeys() {
        return locations != null ? locations.keySet() : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code PersistedToolchains} instance using the specified toolchains.
     *
     * @param toolchains the new {@code Collection<ToolchainModel>} to use
     * @return a {@code PersistedToolchains} with the specified toolchains
     */
    @Nonnull
    public PersistedToolchains withToolchains(Collection<ToolchainModel> toolchains) {
        return newBuilder(this, true).toolchains(toolchains).build();
    }

    /**
     * Creates a new {@code PersistedToolchains} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code PersistedToolchains}
     */
    @Nonnull
    public static PersistedToolchains newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code PersistedToolchains} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code PersistedToolchains}
     */
    @Nonnull
    public static PersistedToolchains newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code PersistedToolchains} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code PersistedToolchains} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code PersistedToolchains} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code PersistedToolchains} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(PersistedToolchains from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code PersistedToolchains} builder instance using the specified object as a basis.
     *
     * @param from the {@code PersistedToolchains} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(PersistedToolchains from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create PersistedToolchains instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends TrackableBase.Builder
    {
        PersistedToolchains base;
        String namespaceUri;
        String modelEncoding;
        Collection<ToolchainModel> toolchains;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
            }
        }

        protected Builder(PersistedToolchains base, boolean forceCopy) {
            super(base, forceCopy);
            this.namespaceUri = base.namespaceUri;
            this.modelEncoding = base.modelEncoding;
            if (forceCopy) {
                this.toolchains = base.toolchains;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder namespaceUri(String namespaceUri) {
            this.namespaceUri = namespaceUri;
            return this;
        }

        @Nonnull
        public Builder modelEncoding(String modelEncoding) {
            this.modelEncoding = modelEncoding;
            return this;
        }

        @Nonnull
        public Builder toolchains(Collection<ToolchainModel> toolchains) {
            this.toolchains = toolchains;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public PersistedToolchains build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (toolchains == null || toolchains == base.toolchains)
            ) {
                return base;
            }
            return new PersistedToolchains(this);
        }
    }

}
