/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.toolchain;

import java.io.Serializable;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.toolchain.ImmutableCollections;
import org.apache.maven.api.toolchain.TrackableBase;
import org.apache.maven.api.xml.Dom;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class ToolchainModel
extends TrackableBase
implements Serializable {
    final String type;
    final Map<String, String> provides;
    final Dom configuration;

    ToolchainModel(String type, Map<String, String> provides, Dom configuration) {
        this.type = type;
        this.provides = ImmutableCollections.copy(provides);
        this.configuration = configuration;
    }

    public String getType() {
        return this.type;
    }

    @Nonnull
    public Map<String, String> getProvides() {
        return this.provides;
    }

    public Dom getConfiguration() {
        return this.configuration;
    }

    @Override
    @Nonnull
    public Builder with() {
        return ToolchainModel.newBuilder(this);
    }

    @Nonnull
    public ToolchainModel withType(String type) {
        return this.with().type(type).build();
    }

    @Nonnull
    public ToolchainModel withProvides(Map<String, String> provides) {
        return this.with().provides(provides).build();
    }

    @Nonnull
    public ToolchainModel withConfiguration(Dom configuration) {
        return this.with().configuration(configuration).build();
    }

    @Nonnull
    public static ToolchainModel newInstance() {
        return ToolchainModel.newInstance(true);
    }

    @Nonnull
    public static ToolchainModel newInstance(boolean withDefaults) {
        return ToolchainModel.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return ToolchainModel.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(ToolchainModel from) {
        return ToolchainModel.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(ToolchainModel from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public int hashCode() {
        int result = 17;
        result = 37 * result + (this.getType() != null ? this.getType().hashCode() : 0);
        result = 37 * result + (this.getProvides() != null ? this.getProvides().hashCode() : 0);
        return result;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ToolchainModel)) {
            return false;
        }
        ToolchainModel that = (ToolchainModel)other;
        boolean result = true;
        boolean bl = result && (this.getType() == null ? that.getType() == null : this.getType().equals(that.getType())) ? true : (result = false);
        result = result && (this.getProvides() == null ? that.getProvides() == null : this.getProvides().equals(that.getProvides()));
        return result;
    }

    @NotThreadSafe
    public static class Builder
    extends TrackableBase.Builder {
        ToolchainModel base;
        String type;
        Map<String, String> provides;
        Dom configuration;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                // empty if block
            }
        }

        Builder(ToolchainModel base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.type = base.type;
                this.provides = base.provides;
                this.configuration = base.configuration;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder type(String type) {
            this.type = type;
            return this;
        }

        @Nonnull
        public Builder provides(Map<String, String> provides) {
            this.provides = provides;
            return this;
        }

        @Nonnull
        public Builder configuration(Dom configuration) {
            this.configuration = configuration;
            return this;
        }

        @Override
        @Nonnull
        public ToolchainModel build() {
            if (!(this.base == null || this.type != null && this.type != this.base.type || this.provides != null && this.provides != this.base.provides || this.configuration != null && this.configuration != this.base.configuration)) {
                return this.base;
            }
            return new ToolchainModel(this.type != null ? this.type : (this.base != null ? this.base.type : null), this.provides != null ? this.provides : (this.base != null ? this.base.provides : null), (Dom)(this.configuration != null ? this.configuration : (this.base != null ? this.base.configuration : null)));
        }
    }
}

