/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ConfigurationContainer;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.xml.XmlNode;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class PluginExecution
extends ConfigurationContainer
implements Serializable,
InputLocationTracker {
    final String id;
    final String phase;
    final int priority;
    final List<String> goals;
    final Map<Object, InputLocation> locations;
    public static final String DEFAULT_EXECUTION_ID = "default";

    protected PluginExecution(Builder builder) {
        super(builder);
        String string = builder.id != null ? builder.id : (this.id = builder.base != null ? builder.base.id : null);
        String string2 = builder.phase != null ? builder.phase : (this.phase = builder.base != null ? builder.base.phase : null);
        int n = builder.priority != null ? builder.priority : (this.priority = builder.base != null ? builder.base.priority : 0);
        this.goals = ImmutableCollections.copy(builder.goals != null ? builder.goals : (builder.base != null ? builder.base.goals : null));
        Map newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        HashMap<Object, InputLocation> mutableLocations = new HashMap<Object, InputLocation>(((ConfigurationContainer)this).locations);
        mutableLocations.put("id", newlocs.containsKey("id") ? (InputLocation)newlocs.get("id") : (InputLocation)oldlocs.get("id"));
        mutableLocations.put("phase", newlocs.containsKey("phase") ? (InputLocation)newlocs.get("phase") : (InputLocation)oldlocs.get("phase"));
        mutableLocations.put("priority", newlocs.containsKey("priority") ? (InputLocation)newlocs.get("priority") : (InputLocation)oldlocs.get("priority"));
        mutableLocations.put("goals", newlocs.containsKey("goals") ? (InputLocation)newlocs.get("goals") : (InputLocation)oldlocs.get("goals"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    public String getId() {
        return this.id;
    }

    public String getPhase() {
        return this.phase;
    }

    public int getPriority() {
        return this.priority;
    }

    @Nonnull
    public List<String> getGoals() {
        return this.goals;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    @Override
    public Set<Object> getLocationKeys() {
        return this.locations != null ? this.locations.keySet() : null;
    }

    @Override
    @Nonnull
    public Builder with() {
        return PluginExecution.newBuilder(this);
    }

    @Override
    @Nonnull
    public PluginExecution withInherited(String inherited) {
        return PluginExecution.newBuilder(this, true).inherited(inherited).build();
    }

    @Override
    @Nonnull
    public PluginExecution withConfiguration(XmlNode configuration) {
        return PluginExecution.newBuilder(this, true).configuration(configuration).build();
    }

    @Nonnull
    public PluginExecution withId(String id) {
        return PluginExecution.newBuilder(this, true).id(id).build();
    }

    @Nonnull
    public PluginExecution withPhase(String phase) {
        return PluginExecution.newBuilder(this, true).phase(phase).build();
    }

    @Nonnull
    public PluginExecution withPriority(int priority) {
        return PluginExecution.newBuilder(this, true).priority(priority).build();
    }

    @Nonnull
    public PluginExecution withGoals(Collection<String> goals) {
        return PluginExecution.newBuilder(this, true).goals(goals).build();
    }

    @Nonnull
    public static PluginExecution newInstance() {
        return PluginExecution.newInstance(true);
    }

    @Nonnull
    public static PluginExecution newInstance(boolean withDefaults) {
        return PluginExecution.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return PluginExecution.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(PluginExecution from) {
        return PluginExecution.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(PluginExecution from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String toString() {
        return this.getId();
    }

    @NotThreadSafe
    public static class Builder
    extends ConfigurationContainer.Builder {
        PluginExecution base;
        String id;
        String phase;
        Integer priority;
        Collection<String> goals;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.id = PluginExecution.DEFAULT_EXECUTION_ID;
                this.priority = 0;
            }
        }

        protected Builder(PluginExecution base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.id = base.id;
                this.phase = base.phase;
                this.priority = base.priority;
                this.goals = base.goals;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder inherited(String inherited) {
            this.inherited = inherited;
            return this;
        }

        @Override
        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder phase(String phase) {
            this.phase = phase;
            return this;
        }

        @Nonnull
        public Builder priority(int priority) {
            this.priority = priority;
            return this;
        }

        @Nonnull
        public Builder goals(Collection<String> goals) {
            this.goals = goals;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Override
        @Nonnull
        public PluginExecution build() {
            if (!(this.base == null || this.inherited != null && this.inherited != this.base.inherited || this.configuration != null && this.configuration != this.base.configuration || this.id != null && this.id != this.base.id || this.phase != null && this.phase != this.base.phase || this.priority != null && this.priority != this.base.priority || this.goals != null && this.goals != this.base.goals)) {
                return this.base;
            }
            return new PluginExecution(this);
        }
    }
}

