/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.DeploymentRepository;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.model.Relocation;
import org.apache.maven.api.model.Site;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class DistributionManagement
implements Serializable,
InputLocationTracker {
    final DeploymentRepository repository;
    final DeploymentRepository snapshotRepository;
    final Site site;
    final String downloadUrl;
    final Relocation relocation;
    final String status;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected DistributionManagement(Builder builder) {
        DeploymentRepository deploymentRepository = builder.repository != null ? builder.repository : (this.repository = builder.base != null ? builder.base.repository : null);
        DeploymentRepository deploymentRepository2 = builder.snapshotRepository != null ? builder.snapshotRepository : (this.snapshotRepository = builder.base != null ? builder.base.snapshotRepository : null);
        Site site = builder.site != null ? builder.site : (this.site = builder.base != null ? builder.base.site : null);
        String string = builder.downloadUrl != null ? builder.downloadUrl : (this.downloadUrl = builder.base != null ? builder.base.downloadUrl : null);
        Relocation relocation = builder.relocation != null ? builder.relocation : (this.relocation = builder.base != null ? builder.base.relocation : null);
        this.status = builder.status != null ? builder.status : (builder.base != null ? builder.base.status : null);
        Map<Object, Object> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        HashMap<String, InputLocation> mutableLocations = new HashMap<String, InputLocation>();
        this.importedFrom = builder.importedFrom;
        mutableLocations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
        mutableLocations.put("repository", newlocs.containsKey("repository") ? (InputLocation)newlocs.get("repository") : (InputLocation)oldlocs.get("repository"));
        mutableLocations.put("snapshotRepository", newlocs.containsKey("snapshotRepository") ? (InputLocation)newlocs.get("snapshotRepository") : (InputLocation)oldlocs.get("snapshotRepository"));
        mutableLocations.put("site", newlocs.containsKey("site") ? (InputLocation)newlocs.get("site") : (InputLocation)oldlocs.get("site"));
        mutableLocations.put("downloadUrl", newlocs.containsKey("downloadUrl") ? (InputLocation)newlocs.get("downloadUrl") : (InputLocation)oldlocs.get("downloadUrl"));
        mutableLocations.put("relocation", newlocs.containsKey("relocation") ? (InputLocation)newlocs.get("relocation") : (InputLocation)oldlocs.get("relocation"));
        mutableLocations.put("status", newlocs.containsKey("status") ? (InputLocation)newlocs.get("status") : (InputLocation)oldlocs.get("status"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    public DeploymentRepository getRepository() {
        return this.repository;
    }

    public DeploymentRepository getSnapshotRepository() {
        return this.snapshotRepository;
    }

    public Site getSite() {
        return this.site;
    }

    public String getDownloadUrl() {
        return this.downloadUrl;
    }

    public Relocation getRelocation() {
        return this.relocation;
    }

    public String getStatus() {
        return this.status;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public Set<Object> getLocationKeys() {
        return this.locations != null ? this.locations.keySet() : null;
    }

    @Override
    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return DistributionManagement.newBuilder(this);
    }

    @Nonnull
    public DistributionManagement withRepository(DeploymentRepository repository) {
        return DistributionManagement.newBuilder(this, true).repository(repository).build();
    }

    @Nonnull
    public DistributionManagement withSnapshotRepository(DeploymentRepository snapshotRepository) {
        return DistributionManagement.newBuilder(this, true).snapshotRepository(snapshotRepository).build();
    }

    @Nonnull
    public DistributionManagement withSite(Site site) {
        return DistributionManagement.newBuilder(this, true).site(site).build();
    }

    @Nonnull
    public DistributionManagement withDownloadUrl(String downloadUrl) {
        return DistributionManagement.newBuilder(this, true).downloadUrl(downloadUrl).build();
    }

    @Nonnull
    public DistributionManagement withRelocation(Relocation relocation) {
        return DistributionManagement.newBuilder(this, true).relocation(relocation).build();
    }

    @Nonnull
    public DistributionManagement withStatus(String status) {
        return DistributionManagement.newBuilder(this, true).status(status).build();
    }

    @Nonnull
    public static DistributionManagement newInstance() {
        return DistributionManagement.newInstance(true);
    }

    @Nonnull
    public static DistributionManagement newInstance(boolean withDefaults) {
        return DistributionManagement.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return DistributionManagement.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(DistributionManagement from) {
        return DistributionManagement.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(DistributionManagement from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    @NotThreadSafe
    public static class Builder {
        DistributionManagement base;
        DeploymentRepository repository;
        DeploymentRepository snapshotRepository;
        Site site;
        String downloadUrl;
        Relocation relocation;
        String status;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(DistributionManagement base, boolean forceCopy) {
            if (forceCopy) {
                this.repository = base.repository;
                this.snapshotRepository = base.snapshotRepository;
                this.site = base.site;
                this.downloadUrl = base.downloadUrl;
                this.relocation = base.relocation;
                this.status = base.status;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder repository(DeploymentRepository repository) {
            this.repository = repository;
            return this;
        }

        @Nonnull
        public Builder snapshotRepository(DeploymentRepository snapshotRepository) {
            this.snapshotRepository = snapshotRepository;
            return this;
        }

        @Nonnull
        public Builder site(Site site) {
            this.site = site;
            return this;
        }

        @Nonnull
        public Builder downloadUrl(String downloadUrl) {
            this.downloadUrl = downloadUrl;
            return this;
        }

        @Nonnull
        public Builder relocation(Relocation relocation) {
            this.relocation = relocation;
            return this;
        }

        @Nonnull
        public Builder status(String status) {
            this.status = status;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public DistributionManagement build() {
            if (!(this.base == null || this.repository != null && this.repository != this.base.repository || this.snapshotRepository != null && this.snapshotRepository != this.base.snapshotRepository || this.site != null && this.site != this.base.site || this.downloadUrl != null && this.downloadUrl != this.base.downloadUrl || this.relocation != null && this.relocation != this.base.relocation || this.status != null && this.status != this.base.status)) {
                return this.base;
            }
            return new DistributionManagement(this);
        }
    }
}

