/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.xml.XmlNode;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class ConfigurationContainer
implements Serializable,
InputLocationTracker {
    final String inherited;
    final XmlNode configuration;
    final Map<Object, InputLocation> locations;
    final InputLocation importedFrom;

    protected ConfigurationContainer(Builder builder) {
        String string = builder.inherited != null ? builder.inherited : (this.inherited = builder.base != null ? builder.base.inherited : null);
        this.configuration = builder.configuration != null ? builder.configuration : (builder.base != null ? builder.base.configuration : null);
        Map<Object, Object> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        HashMap<String, InputLocation> mutableLocations = new HashMap<String, InputLocation>();
        this.importedFrom = builder.importedFrom;
        mutableLocations.put("", newlocs.containsKey("") ? (InputLocation)newlocs.get("") : (InputLocation)oldlocs.get(""));
        mutableLocations.put("inherited", newlocs.containsKey("inherited") ? (InputLocation)newlocs.get("inherited") : (InputLocation)oldlocs.get("inherited"));
        mutableLocations.put("configuration", newlocs.containsKey("configuration") ? (InputLocation)newlocs.get("configuration") : (InputLocation)oldlocs.get("configuration"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    public String getInherited() {
        return this.inherited;
    }

    public XmlNode getConfiguration() {
        return this.configuration;
    }

    @Override
    public InputLocation getLocation(Object key) {
        return this.locations != null ? this.locations.get(key) : null;
    }

    public Set<Object> getLocationKeys() {
        return this.locations != null ? this.locations.keySet() : null;
    }

    @Override
    public InputLocation getImportedFrom() {
        return this.importedFrom;
    }

    @Nonnull
    public Builder with() {
        return ConfigurationContainer.newBuilder(this);
    }

    @Nonnull
    public ConfigurationContainer withInherited(String inherited) {
        return ConfigurationContainer.newBuilder(this, true).inherited(inherited).build();
    }

    @Nonnull
    public ConfigurationContainer withConfiguration(XmlNode configuration) {
        return ConfigurationContainer.newBuilder(this, true).configuration(configuration).build();
    }

    @Nonnull
    public static ConfigurationContainer newInstance() {
        return ConfigurationContainer.newInstance(true);
    }

    @Nonnull
    public static ConfigurationContainer newInstance(boolean withDefaults) {
        return ConfigurationContainer.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return ConfigurationContainer.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(ConfigurationContainer from) {
        return ConfigurationContainer.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(ConfigurationContainer from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public boolean isInherited() {
        return this.getInherited() != null ? Boolean.parseBoolean(this.getInherited()) : true;
    }

    @NotThreadSafe
    public static class Builder {
        ConfigurationContainer base;
        String inherited;
        XmlNode configuration;
        Map<Object, InputLocation> locations;
        InputLocation importedFrom;

        protected Builder(boolean withDefaults) {
            if (withDefaults) {
                // empty if block
            }
        }

        protected Builder(ConfigurationContainer base, boolean forceCopy) {
            if (forceCopy) {
                this.inherited = base.inherited;
                this.configuration = base.configuration;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder inherited(String inherited) {
            this.inherited = inherited;
            return this;
        }

        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<Object, InputLocation>(this.locations) : new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public ConfigurationContainer build() {
            if (!(this.base == null || this.inherited != null && this.inherited != this.base.inherited || this.configuration != null && this.configuration != this.base.configuration)) {
                return this.base;
            }
            return new ConfigurationContainer(this);
        }
    }
}

