// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Contains the plugins management information for the project.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class PluginConfiguration
    extends PluginContainer
    implements Serializable, InputLocationTracker
{
    /**
     * Default plugin information to be made available for reference by projects
     * derived from this one. This plugin configuration will not be resolved or bound to the
     * lifecycle unless referenced. Any local configuration for a given plugin will override
     * the plugin's entire definition here.
     */
    final PluginManagement pluginManagement;
    /** Locations (this potentially hides the same name field from the super class) */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected PluginConfiguration(Builder builder) {
        super(builder);
        this.pluginManagement = builder.pluginManagement != null ? builder.pluginManagement : (builder.base != null ? builder.base.pluginManagement : null);
        Map<Object, InputLocation> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map<Object, InputLocation> oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        Map<Object, InputLocation> mutableLocations = new HashMap<>(super.locations);
        mutableLocations.put("pluginManagement", newlocs.containsKey("pluginManagement") ? newlocs.get("pluginManagement") : oldlocs.get("pluginManagement"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    /**
     * Default plugin information to be made available for reference by projects
     * derived from this one. This plugin configuration will not be resolved or bound to the
     * lifecycle unless referenced. Any local configuration for a given plugin will override
     * the plugin's entire definition here.
     *
     * @return a {@code PluginManagement}
     */
    public PluginManagement getPluginManagement() {
        return this.pluginManagement;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
    * Gets the keys of the locations of the input source.
    */
    public Set<Object> getLocationKeys() {
        return locations != null ? locations.keySet() : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code PluginConfiguration} instance using the specified plugins.
     *
     * @param plugins the new {@code Collection<Plugin>} to use
     * @return a {@code PluginConfiguration} with the specified plugins
     */
    @Nonnull
    public PluginConfiguration withPlugins(Collection<Plugin> plugins) {
        return newBuilder(this, true).plugins(plugins).build();
    }
    /**
     * Creates a new {@code PluginConfiguration} instance using the specified pluginManagement.
     *
     * @param pluginManagement the new {@code PluginManagement} to use
     * @return a {@code PluginConfiguration} with the specified pluginManagement
     */
    @Nonnull
    public PluginConfiguration withPluginManagement(PluginManagement pluginManagement) {
        return newBuilder(this, true).pluginManagement(pluginManagement).build();
    }

    /**
     * Creates a new {@code PluginConfiguration} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code PluginConfiguration}
     */
    @Nonnull
    public static PluginConfiguration newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code PluginConfiguration} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code PluginConfiguration}
     */
    @Nonnull
    public static PluginConfiguration newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code PluginConfiguration} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code PluginConfiguration} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code PluginConfiguration} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code PluginConfiguration} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(PluginConfiguration from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code PluginConfiguration} builder instance using the specified object as a basis.
     *
     * @param from the {@code PluginConfiguration} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(PluginConfiguration from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create PluginConfiguration instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends PluginContainer.Builder
    {
        PluginConfiguration base;
        PluginManagement pluginManagement;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
            }
        }

        protected Builder(PluginConfiguration base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.pluginManagement = base.pluginManagement;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder plugins(Collection<Plugin> plugins) {
            this.plugins = plugins;
            return this;
        }

        @Nonnull
        public Builder pluginManagement(PluginManagement pluginManagement) {
            this.pluginManagement = pluginManagement;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public PluginConfiguration build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (plugins == null || plugins == base.plugins)
                    && (pluginManagement == null || pluginManagement == base.pluginManagement)
            ) {
                return base;
            }
            return new PluginConfiguration(this);
        }
    }


            
    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "PluginConfiguration {" + super.toString() + "}";
    }
            
          
}
