// =================== DO NOT EDIT THIS FILE ====================
//  Generated by Modello Velocity from model.vm
//  template, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.xml.XmlNode;

/**
 * The {@code <plugin>} element contains information required for a plugin.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Plugin
    extends ConfigurationContainer
    implements Serializable, InputLocationTracker
{
    /**
     * The group ID of the plugin in the repository.
     */
    final String groupId;
    /**
     * The artifact ID of the plugin in the repository.
     */
    final String artifactId;
    /**
     * The version (or valid range of versions) of the plugin to be used.
     */
    final String version;
    /**
     * Whether to load Maven extensions (such as packaging and type handlers) from
     * this plugin. For performance reasons, this should only be enabled when necessary. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code false}.
     */
    final String extensions;
    /**
     * Multiple specifications of a set of goals to execute during the build
     * lifecycle, each having (possibly) a different configuration.
     */
    final List<PluginExecution> executions;
    /**
     * Additional dependencies that this project needs to introduce to the plugin's
     * classloader.
     */
    final List<Dependency> dependencies;
    /** Locations (this potentially hides the same name field from the super class) */
    final Map<Object, InputLocation> locations;

    /**
      * Constructor for this class, to be called from its subclasses and {@link Builder}.
      * @see Builder#build()
      */
    protected Plugin(Builder builder) {
        super(builder);
        this.groupId = builder.groupId != null ? builder.groupId : (builder.base != null ? builder.base.groupId : null);
        this.artifactId = builder.artifactId != null ? builder.artifactId : (builder.base != null ? builder.base.artifactId : null);
        this.version = builder.version != null ? builder.version : (builder.base != null ? builder.base.version : null);
        this.extensions = builder.extensions != null ? builder.extensions : (builder.base != null ? builder.base.extensions : null);
        this.executions = ImmutableCollections.copy(builder.executions != null ? builder.executions : (builder.base != null ? builder.base.executions : null));
        this.dependencies = ImmutableCollections.copy(builder.dependencies != null ? builder.dependencies : (builder.base != null ? builder.base.dependencies : null));
        Map<Object, InputLocation> newlocs = builder.locations != null ? builder.locations : Collections.emptyMap();
        Map<Object, InputLocation> oldlocs = builder.base != null && builder.base.locations != null ? builder.base.locations : Collections.emptyMap();
        Map<Object, InputLocation> mutableLocations = new HashMap<>(super.locations);
        mutableLocations.put("groupId", newlocs.containsKey("groupId") ? newlocs.get("groupId") : oldlocs.get("groupId"));
        mutableLocations.put("artifactId", newlocs.containsKey("artifactId") ? newlocs.get("artifactId") : oldlocs.get("artifactId"));
        mutableLocations.put("version", newlocs.containsKey("version") ? newlocs.get("version") : oldlocs.get("version"));
        mutableLocations.put("extensions", newlocs.containsKey("extensions") ? newlocs.get("extensions") : oldlocs.get("extensions"));
        mutableLocations.put("executions", newlocs.containsKey("executions") ? newlocs.get("executions") : oldlocs.get("executions"));
        mutableLocations.put("dependencies", newlocs.containsKey("dependencies") ? newlocs.get("dependencies") : oldlocs.get("dependencies"));
        this.locations = Collections.unmodifiableMap(mutableLocations);
    }

    /**
     * The group ID of the plugin in the repository.
     *
     * @return a {@code String}
     */
    public String getGroupId() {
        return this.groupId;
    }

    /**
     * The artifact ID of the plugin in the repository.
     *
     * @return a {@code String}
     */
    public String getArtifactId() {
        return this.artifactId;
    }

    /**
     * The version (or valid range of versions) of the plugin to be used.
     *
     * @return a {@code String}
     */
    public String getVersion() {
        return this.version;
    }

    /**
     * Whether to load Maven extensions (such as packaging and type handlers) from
     * this plugin. For performance reasons, this should only be enabled when necessary. Note: While the type
     * of this field is {@code String} for technical reasons, the semantic type is actually
     * {@code Boolean}. Default value is {@code false}.
     *
     * @return a {@code String}
     */
    public String getExtensions() {
        return this.extensions;
    }

    /**
     * Multiple specifications of a set of goals to execute during the build
     * lifecycle, each having (possibly) a different configuration.
     *
     * @return a {@code List<PluginExecution>}
     */
    @Nonnull
    public List<PluginExecution> getExecutions() {
        return this.executions;
    }

    /**
     * Additional dependencies that this project needs to introduce to the plugin's
     * classloader.
     *
     * @return a {@code List<Dependency>}
     */
    @Nonnull
    public List<Dependency> getDependencies() {
        return this.dependencies;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation(Object key) {
        return locations != null ? locations.get(key) : null;
    }

    /**
    * Gets the keys of the locations of the input source.
    */
    public Set<Object> getLocationKeys() {
        return locations != null ? locations.keySet() : null;
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with() {
        return newBuilder(this);
    }
    /**
     * Creates a new {@code Plugin} instance using the specified inherited.
     *
     * @param inherited the new {@code String} to use
     * @return a {@code Plugin} with the specified inherited
     */
    @Nonnull
    public Plugin withInherited(String inherited) {
        return newBuilder(this, true).inherited(inherited).build();
    }
    /**
     * Creates a new {@code Plugin} instance using the specified configuration.
     *
     * @param configuration the new {@code XmlNode} to use
     * @return a {@code Plugin} with the specified configuration
     */
    @Nonnull
    public Plugin withConfiguration(XmlNode configuration) {
        return newBuilder(this, true).configuration(configuration).build();
    }
    /**
     * Creates a new {@code Plugin} instance using the specified groupId.
     *
     * @param groupId the new {@code String} to use
     * @return a {@code Plugin} with the specified groupId
     */
    @Nonnull
    public Plugin withGroupId(String groupId) {
        return newBuilder(this, true).groupId(groupId).build();
    }
    /**
     * Creates a new {@code Plugin} instance using the specified artifactId.
     *
     * @param artifactId the new {@code String} to use
     * @return a {@code Plugin} with the specified artifactId
     */
    @Nonnull
    public Plugin withArtifactId(String artifactId) {
        return newBuilder(this, true).artifactId(artifactId).build();
    }
    /**
     * Creates a new {@code Plugin} instance using the specified version.
     *
     * @param version the new {@code String} to use
     * @return a {@code Plugin} with the specified version
     */
    @Nonnull
    public Plugin withVersion(String version) {
        return newBuilder(this, true).version(version).build();
    }
    /**
     * Creates a new {@code Plugin} instance using the specified extensions.
     *
     * @param extensions the new {@code String} to use
     * @return a {@code Plugin} with the specified extensions
     */
    @Nonnull
    public Plugin withExtensions(String extensions) {
        return newBuilder(this, true).extensions(extensions).build();
    }
    /**
     * Creates a new {@code Plugin} instance using the specified executions.
     *
     * @param executions the new {@code Collection<PluginExecution>} to use
     * @return a {@code Plugin} with the specified executions
     */
    @Nonnull
    public Plugin withExecutions(Collection<PluginExecution> executions) {
        return newBuilder(this, true).executions(executions).build();
    }
    /**
     * Creates a new {@code Plugin} instance using the specified dependencies.
     *
     * @param dependencies the new {@code Collection<Dependency>} to use
     * @return a {@code Plugin} with the specified dependencies
     */
    @Nonnull
    public Plugin withDependencies(Collection<Dependency> dependencies) {
        return newBuilder(this, true).dependencies(dependencies).build();
    }

    /**
     * Creates a new {@code Plugin} instance.
     * Equivalent to {@code newInstance(true)}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Plugin}
     */
    @Nonnull
    public static Plugin newInstance() {
        return newInstance(true);
    }

    /**
     * Creates a new {@code Plugin} instance using default values or not.
     * Equivalent to {@code newBuilder(withDefaults).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Plugin}
     */
    @Nonnull
    public static Plugin newInstance(boolean withDefaults) {
        return newBuilder(withDefaults).build();
    }

    /**
     * Creates a new {@code Plugin} builder instance.
     * Equivalent to {@code newBuilder(true)}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder() {
        return newBuilder(true);
    }

    /**
     * Creates a new {@code Plugin} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    /**
     * Creates a new {@code Plugin} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder(from, false)}.
     *
     * @param from the {@code Plugin} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Plugin from) {
        return newBuilder(from, false);
    }

    /**
     * Creates a new {@code Plugin} builder instance using the specified object as a basis.
     *
     * @param from the {@code Plugin} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder(Plugin from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    /**
     * Builder class used to create Plugin instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends ConfigurationContainer.Builder
    {
        Plugin base;
        String groupId;
        String artifactId;
        String version;
        String extensions;
        Collection<PluginExecution> executions;
        Collection<Dependency> dependencies;

        protected Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.groupId = "org.apache.maven.plugins";
            }
        }

        protected Builder(Plugin base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.extensions = base.extensions;
                this.executions = base.executions;
                this.dependencies = base.dependencies;
                this.locations = base.locations;
                this.importedFrom = base.importedFrom;
            } else {
                this.base = base;
            }
        }

        @Nonnull
        public Builder inherited(String inherited) {
            this.inherited = inherited;
            return this;
        }

        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder groupId(String groupId) {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId(String artifactId) {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version(String version) {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder extensions(String extensions) {
            this.extensions = extensions;
            return this;
        }

        @Nonnull
        public Builder executions(Collection<PluginExecution> executions) {
            this.executions = executions;
            return this;
        }

        @Nonnull
        public Builder dependencies(Collection<Dependency> dependencies) {
            this.dependencies = dependencies;
            return this;
        }


        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (!(this.locations instanceof HashMap)) {
                    this.locations = this.locations != null ? new HashMap<>(this.locations) : new HashMap<>();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Nonnull
        public Builder importedFrom(InputLocation importedFrom) {
            this.importedFrom = importedFrom;
            return this;
        }

        @Nonnull
        public Plugin build() {
            // this method should not contain any logic other than creating (or reusing) an object in order to ease subclassing
            if (base != null
                    && (inherited == null || inherited == base.inherited)
                    && (configuration == null || configuration == base.configuration)
                    && (groupId == null || groupId == base.groupId)
                    && (artifactId == null || artifactId == base.artifactId)
                    && (version == null || version == base.version)
                    && (extensions == null || extensions == base.extensions)
                    && (executions == null || executions == base.executions)
                    && (dependencies == null || dependencies == base.dependencies)
            ) {
                return base;
            }
            return new Plugin(this);
        }
    }


            
    public boolean isExtensions() {
        return (getExtensions() != null) ? Boolean.parseBoolean(getExtensions()) : false;
    }
            
          

            
    /**
     * Gets the identifier of the plugin.
     *
     * @return the plugin id in the form {@code <groupId>:<artifactId>:<version>}, never {@code null}
     */
    public String getId() {
        return new StringBuilder(128)
            .append((getGroupId() == null) ? "[unknown-group-id]" : getGroupId())
            .append(":")
            .append((getArtifactId() == null) ? "[unknown-artifact-id]" : getArtifactId())
            .append(":")
            .append((getVersion() == null) ? "[unknown-version]" : getVersion())
            .toString();
    }

    /**
     * @return the key of the plugin, ie {@code groupId:artifactId}
     */
    public String getKey() {
        return constructKey(getGroupId(), getArtifactId());
    }

    /**
     * @param groupId the group ID of the plugin in the repository
     * @param artifactId the artifact ID of the reporting plugin in the repository
     * @return the key of the plugin, ie {@code groupId:artifactId}
     */
    public static String constructKey(String groupId, String artifactId) {
        return groupId + ":" + artifactId;
    }

            
          

            
    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    public boolean equals(Object other) {
        if (other instanceof Plugin) {
            Plugin otherPlugin = (Plugin) other;
            return getKey().equals(otherPlugin.getKey());
        }
        return false;
    }

    /**
     * @see java.lang.Object#hashCode()
     */
    public int hashCode() {
        return getKey().hashCode();
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString() {
        return "Plugin [" + getKey() + "]";
    }
            
          
}
