/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.model.ConfigurationContainer;
import org.apache.maven.api.model.ImmutableCollections;
import org.apache.maven.api.model.InputLocation;
import org.apache.maven.api.model.InputLocationTracker;
import org.apache.maven.api.xml.XmlNode;

@Experimental
@Generated
@ThreadSafe
@Immutable
public class ReportSet
extends ConfigurationContainer
implements Serializable,
InputLocationTracker {
    final String id;
    final List<String> reports;
    final InputLocation idLocation;
    final InputLocation reportsLocation;

    ReportSet(String inherited, XmlNode configuration, String id, Collection<String> reports, Map<Object, InputLocation> locations, InputLocation location, InputLocation inheritedLocation, InputLocation configurationLocation, InputLocation idLocation, InputLocation reportsLocation) {
        super(inherited, configuration, locations, location, inheritedLocation, configurationLocation);
        this.id = id;
        this.reports = ImmutableCollections.copy(reports);
        this.idLocation = idLocation;
        this.reportsLocation = reportsLocation;
    }

    public String getId() {
        return this.id;
    }

    @Nonnull
    public List<String> getReports() {
        return this.reports;
    }

    @Override
    public InputLocation getLocation(Object key) {
        if (key instanceof String) {
            switch ((String)key) {
                case "id": {
                    return this.idLocation;
                }
                case "reports": {
                    return this.reportsLocation;
                }
            }
        }
        return super.getLocation(key);
    }

    @Override
    @Nonnull
    public Builder with() {
        return ReportSet.newBuilder(this);
    }

    @Override
    @Nonnull
    public ReportSet withInherited(String inherited) {
        return this.with().inherited(inherited).build();
    }

    @Override
    @Nonnull
    public ReportSet withConfiguration(XmlNode configuration) {
        return this.with().configuration(configuration).build();
    }

    @Nonnull
    public ReportSet withId(String id) {
        return this.with().id(id).build();
    }

    @Nonnull
    public ReportSet withReports(Collection<String> reports) {
        return this.with().reports(reports).build();
    }

    @Nonnull
    public static ReportSet newInstance() {
        return ReportSet.newInstance(true);
    }

    @Nonnull
    public static ReportSet newInstance(boolean withDefaults) {
        return ReportSet.newBuilder(withDefaults).build();
    }

    @Nonnull
    public static Builder newBuilder() {
        return ReportSet.newBuilder(true);
    }

    @Nonnull
    public static Builder newBuilder(boolean withDefaults) {
        return new Builder(withDefaults);
    }

    @Nonnull
    public static Builder newBuilder(ReportSet from) {
        return ReportSet.newBuilder(from, false);
    }

    @Nonnull
    public static Builder newBuilder(ReportSet from, boolean forceCopy) {
        return new Builder(from, forceCopy);
    }

    public String toString() {
        return this.getId();
    }

    @NotThreadSafe
    public static class Builder
    extends ConfigurationContainer.Builder {
        ReportSet base;
        String id;
        Collection<String> reports;

        Builder(boolean withDefaults) {
            super(withDefaults);
            if (withDefaults) {
                this.id = "default";
            }
        }

        Builder(ReportSet base, boolean forceCopy) {
            super(base, forceCopy);
            if (forceCopy) {
                this.id = base.id;
                this.reports = base.reports;
            } else {
                this.base = base;
            }
        }

        @Override
        @Nonnull
        public Builder inherited(String inherited) {
            this.inherited = inherited;
            return this;
        }

        @Override
        @Nonnull
        public Builder configuration(XmlNode configuration) {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder id(String id) {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder reports(Collection<String> reports) {
            this.reports = reports;
            return this;
        }

        @Override
        @Nonnull
        public Builder location(Object key, InputLocation location) {
            if (location != null) {
                if (this.locations == null) {
                    this.locations = new HashMap();
                }
                this.locations.put(key, location);
            }
            return this;
        }

        @Override
        @Nonnull
        public ReportSet build() {
            if (!(this.base == null || this.inherited != null && this.inherited != this.base.inherited || this.configuration != null && this.configuration != this.base.configuration || this.id != null && this.id != this.base.id || this.reports != null && this.reports != this.base.reports)) {
                return this.base;
            }
            Map locations = null;
            InputLocation location = null;
            InputLocation inheritedLocation = null;
            InputLocation configurationLocation = null;
            InputLocation idLocation = null;
            InputLocation reportsLocation = null;
            if (this.locations != null) {
                locations = this.locations;
                location = (InputLocation)locations.remove("");
                inheritedLocation = (InputLocation)locations.remove("inherited");
                configurationLocation = (InputLocation)locations.remove("configuration");
                idLocation = (InputLocation)locations.remove("id");
                reportsLocation = (InputLocation)locations.remove("reports");
            }
            return new ReportSet(this.inherited != null ? this.inherited : (this.base != null ? this.base.inherited : null), (XmlNode)(this.configuration != null ? this.configuration : (this.base != null ? this.base.configuration : null)), this.id != null ? this.id : (this.base != null ? this.base.id : null), this.reports != null ? this.reports : (this.base != null ? this.base.reports : null), locations != null ? locations : (this.base != null ? this.base.locations : null), location != null ? location : (this.base != null ? this.base.location : null), inheritedLocation != null ? inheritedLocation : (this.base != null ? this.base.inheritedLocation : null), configurationLocation != null ? configurationLocation : (this.base != null ? this.base.configurationLocation : null), idLocation != null ? idLocation : (this.base != null ? this.base.idLocation : null), reportsLocation != null ? reportsLocation : (this.base != null ? this.base.reportsLocation : null));
        }
    }
}

