// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;
import org.apache.maven.api.xml.Dom;

/**
 * The {@code <plugin>} element in {@code <reporting><plugins>} contains informations required for a report plugin.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class ReportPlugin
    extends ConfigurationContainer
    implements Serializable, InputLocationTracker
{
    /**
     * The group ID of the reporting plugin in the repository.
     */
    final String groupId;
    /**
     * The artifact ID of the reporting plugin in the repository.
     */
    final String artifactId;
    /**
     * The version of the reporting plugin to be used. Starting with Maven 3, if no version is defined explicitely,
     * version is searched in {@code build/plugins} then in {@code build/pluginManagement}.
     */
    final String version;
    /**
     * Multiple specifications of a set of reports, each having (possibly) different
     * configuration. This is the reporting parallel to an {@code execution} in the build.
     */
    final List<ReportSet> reportSets;
    /** Location of the xml element for the field groupId. */
    final InputLocation groupIdLocation;
    /** Location of the xml element for the field artifactId. */
    final InputLocation artifactIdLocation;
    /** Location of the xml element for the field version. */
    final InputLocation versionLocation;
    /** Location of the xml element for the field reportSets. */
    final InputLocation reportSetsLocation;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    ReportPlugin(
        String inherited,
        Dom configuration,
        String groupId,
        String artifactId,
        String version,
        Collection<ReportSet> reportSets,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation inheritedLocation,
        InputLocation configurationLocation,
        InputLocation groupIdLocation,
        InputLocation artifactIdLocation,
        InputLocation versionLocation,
        InputLocation reportSetsLocation
    )
    {
        super(
            inherited,
            configuration,
            locations,
            location,
            inheritedLocation,
            configurationLocation
        );
        this.groupId = groupId;
        this.artifactId = artifactId;
        this.version = version;
        this.reportSets = ImmutableCollections.copy( reportSets );
        this.groupIdLocation = groupIdLocation;
        this.artifactIdLocation = artifactIdLocation;
        this.versionLocation = versionLocation;
        this.reportSetsLocation = reportSetsLocation;
    }

    /**
     * The group ID of the reporting plugin in the repository.
     *
     * @return a {@code String}
     */
    public String getGroupId()
    {
        return this.groupId;
    }

    /**
     * The artifact ID of the reporting plugin in the repository.
     *
     * @return a {@code String}
     */
    public String getArtifactId()
    {
        return this.artifactId;
    }

    /**
     * The version of the reporting plugin to be used. Starting with Maven 3, if no version is defined explicitely,
     * version is searched in {@code build/plugins} then in {@code build/pluginManagement}.
     *
     * @return a {@code String}
     */
    public String getVersion()
    {
        return this.version;
    }

    /**
     * Multiple specifications of a set of reports, each having (possibly) different
     * configuration. This is the reporting parallel to an {@code execution} in the build.
     *
     * @return a {@code List<ReportSet>}
     */
    @Nonnull
    public List<ReportSet> getReportSets()
    {
        return this.reportSets;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "groupId":
                    return groupIdLocation;
                case "artifactId":
                    return artifactIdLocation;
                case "version":
                    return versionLocation;
                case "reportSets":
                    return reportSetsLocation;
            }
        }
        return super.getLocation( key );
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code ReportPlugin} instance using the specified inherited.
     *
     * @param inherited the new {@code String} to use
     * @return a {@code ReportPlugin} with the specified inherited
     */
    @Nonnull
    public ReportPlugin withInherited( String inherited )
    {
        return with().inherited( inherited ).build();
    }
    /**
     * Creates a new {@code ReportPlugin} instance using the specified configuration.
     *
     * @param configuration the new {@code Dom} to use
     * @return a {@code ReportPlugin} with the specified configuration
     */
    @Nonnull
    public ReportPlugin withConfiguration( Dom configuration )
    {
        return with().configuration( configuration ).build();
    }
    /**
     * Creates a new {@code ReportPlugin} instance using the specified groupId.
     *
     * @param groupId the new {@code String} to use
     * @return a {@code ReportPlugin} with the specified groupId
     */
    @Nonnull
    public ReportPlugin withGroupId( String groupId )
    {
        return with().groupId( groupId ).build();
    }
    /**
     * Creates a new {@code ReportPlugin} instance using the specified artifactId.
     *
     * @param artifactId the new {@code String} to use
     * @return a {@code ReportPlugin} with the specified artifactId
     */
    @Nonnull
    public ReportPlugin withArtifactId( String artifactId )
    {
        return with().artifactId( artifactId ).build();
    }
    /**
     * Creates a new {@code ReportPlugin} instance using the specified version.
     *
     * @param version the new {@code String} to use
     * @return a {@code ReportPlugin} with the specified version
     */
    @Nonnull
    public ReportPlugin withVersion( String version )
    {
        return with().version( version ).build();
    }
    /**
     * Creates a new {@code ReportPlugin} instance using the specified reportSets.
     *
     * @param reportSets the new {@code Collection<ReportSet>} to use
     * @return a {@code ReportPlugin} with the specified reportSets
     */
    @Nonnull
    public ReportPlugin withReportSets( Collection<ReportSet> reportSets )
    {
        return with().reportSets( reportSets ).build();
    }

    /**
     * Creates a new {@code ReportPlugin} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code ReportPlugin}
     */
    @Nonnull
    public static ReportPlugin newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code ReportPlugin} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code ReportPlugin}
     */
    @Nonnull
    public static ReportPlugin newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code ReportPlugin} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code ReportPlugin} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code ReportPlugin} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code ReportPlugin} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( ReportPlugin from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code ReportPlugin} builder instance using the specified object as a basis.
     *
     * @param from the {@code ReportPlugin} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( ReportPlugin from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create ReportPlugin instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends ConfigurationContainer.Builder
    {
        ReportPlugin base;
        String groupId;
        String artifactId;
        String version;
        Collection<ReportSet> reportSets;

        Builder( boolean withDefaults )
        {
            super( withDefaults );
            if ( withDefaults )
            {
                this.groupId = "org.apache.maven.plugins";
            }
        }

        Builder( ReportPlugin base, boolean forceCopy )
        {
            super( base, forceCopy );
            if ( forceCopy )
            {
                this.groupId = base.groupId;
                this.artifactId = base.artifactId;
                this.version = base.version;
                this.reportSets = base.reportSets;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder inherited( String inherited )
        {
            this.inherited = inherited;
            return this;
        }

        @Nonnull
        public Builder configuration( Dom configuration )
        {
            this.configuration = configuration;
            return this;
        }

        @Nonnull
        public Builder groupId( String groupId )
        {
            this.groupId = groupId;
            return this;
        }

        @Nonnull
        public Builder artifactId( String artifactId )
        {
            this.artifactId = artifactId;
            return this;
        }

        @Nonnull
        public Builder version( String version )
        {
            this.version = version;
            return this;
        }

        @Nonnull
        public Builder reportSets( Collection<ReportSet> reportSets )
        {
            this.reportSets = reportSets;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public ReportPlugin build()
        {
            if ( base != null
                    && ( inherited == null || inherited == base.inherited )
                    && ( configuration == null || configuration == base.configuration )
                    && ( groupId == null || groupId == base.groupId )
                    && ( artifactId == null || artifactId == base.artifactId )
                    && ( version == null || version == base.version )
                    && ( reportSets == null || reportSets == base.reportSets )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation inheritedLocation = null;
            InputLocation configurationLocation = null;
            InputLocation groupIdLocation = null;
            InputLocation artifactIdLocation = null;
            InputLocation versionLocation = null;
            InputLocation reportSetsLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                inheritedLocation = locations.remove( "inherited" );
                configurationLocation = locations.remove( "configuration" );
                groupIdLocation = locations.remove( "groupId" );
                artifactIdLocation = locations.remove( "artifactId" );
                versionLocation = locations.remove( "version" );
                reportSetsLocation = locations.remove( "reportSets" );
            }
            return new ReportPlugin(
                inherited != null ? inherited : ( base != null ? base.inherited : null ),
                configuration != null ? configuration : ( base != null ? base.configuration : null ),
                groupId != null ? groupId : ( base != null ? base.groupId : null ),
                artifactId != null ? artifactId : ( base != null ? base.artifactId : null ),
                version != null ? version : ( base != null ? base.version : null ),
                reportSets != null ? reportSets : ( base != null ? base.reportSets : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                inheritedLocation != null ? inheritedLocation : ( base != null ? base.inheritedLocation : null ),
                configurationLocation != null ? configurationLocation : ( base != null ? base.configurationLocation : null ),
                groupIdLocation != null ? groupIdLocation : ( base != null ? base.groupIdLocation : null ),
                artifactIdLocation != null ? artifactIdLocation : ( base != null ? base.artifactIdLocation : null ),
                versionLocation != null ? versionLocation : ( base != null ? base.versionLocation : null ),
                reportSetsLocation != null ? reportSetsLocation : ( base != null ? base.reportSetsLocation : null )
            );
        }
    }


            
    private java.util.Map<String, ReportSet> reportSetMap = null;

    /**
     * Reset the {@code reportSetMap} field to {@code null}
     */
    public void flushReportSetMap()
    {
        this.reportSetMap = null;
    }

    /**
     * @return a Map of reportSets field with {@code ReportSet#getId()} as key
     * @see ReportSet#getId()
     */
    public java.util.Map<String, ReportSet> getReportSetsAsMap()
    {
        if ( reportSetMap == null )
        {
            reportSetMap = new java.util.LinkedHashMap<String, ReportSet>();
            if ( getReportSets() != null )
            {
                for ( java.util.Iterator<ReportSet> i = getReportSets().iterator(); i.hasNext(); )
                {
                    ReportSet reportSet = (ReportSet) i.next();
                    reportSetMap.put( reportSet.getId(), reportSet );
                }
            }
        }

        return reportSetMap;
    }

    /**
     * @return the key of the report plugin, ie {@code groupId:artifactId}
     */
    public String getKey()
    {
        return constructKey( getGroupId(), getArtifactId() );
    }

    /**
     * @param groupId The group ID of the plugin in the repository
     * @param artifactId The artifact ID of the reporting plugin in the repository
     * @return the key of the report plugin, ie {@code groupId:artifactId}
     */
    public static String constructKey( String groupId, String artifactId )
    {
        return groupId + ":" + artifactId;
    }
            
          
}
