// =================== DO NOT EDIT THIS FILE ====================
//   Generated by Maven, any modifications will be overwritten.
// ==============================================================
package org.apache.maven.api.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.annotations.Experimental;
import org.apache.maven.api.annotations.Generated;
import org.apache.maven.api.annotations.Immutable;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.annotations.NotThreadSafe;
import org.apache.maven.api.annotations.ThreadSafe;

/**
 * Modifications to the build process which is activated based on environmental
 * parameters or command line arguments.
 */
@Experimental
@Generated @ThreadSafe @Immutable
public class Profile
    extends ModelBase
    implements Serializable, InputLocationTracker
{
    /**
     * The identifier of this build profile. This is used for command line
     * activation, and identifies profiles to be merged.
     */
    final String id;
    /**
     * The conditional logic which will automatically trigger the inclusion of this
     * profile.
     */
    final Activation activation;
    /**
     * Information required to build the project.
     */
    final BuildBase build;
    /** Location of the xml element for the field id. */
    final InputLocation idLocation;
    /** Location of the xml element for the field activation. */
    final InputLocation activationLocation;
    /** Location of the xml element for the field build. */
    final InputLocation buildLocation;

    /**
      * Constructor for this class, package protected.
      * @see Builder#build()
      */
    Profile(
        Collection<String> modules,
        DistributionManagement distributionManagement,
        Map<String, String> properties,
        DependencyManagement dependencyManagement,
        Collection<Dependency> dependencies,
        Collection<Repository> repositories,
        Collection<Repository> pluginRepositories,
        Reporting reporting,
        String id,
        Activation activation,
        BuildBase build,
        Map<Object, InputLocation> locations,
        InputLocation location,
        InputLocation modulesLocation,
        InputLocation distributionManagementLocation,
        InputLocation propertiesLocation,
        InputLocation dependencyManagementLocation,
        InputLocation dependenciesLocation,
        InputLocation repositoriesLocation,
        InputLocation pluginRepositoriesLocation,
        InputLocation reportingLocation,
        InputLocation idLocation,
        InputLocation activationLocation,
        InputLocation buildLocation
    )
    {
        super(
            modules,
            distributionManagement,
            properties,
            dependencyManagement,
            dependencies,
            repositories,
            pluginRepositories,
            reporting,
            locations,
            location,
            modulesLocation,
            distributionManagementLocation,
            propertiesLocation,
            dependencyManagementLocation,
            dependenciesLocation,
            repositoriesLocation,
            pluginRepositoriesLocation,
            reportingLocation
        );
        this.id = id;
        this.activation = activation;
        this.build = build;
        this.idLocation = idLocation;
        this.activationLocation = activationLocation;
        this.buildLocation = buildLocation;
    }

    /**
     * The identifier of this build profile. This is used for command line
     * activation, and identifies profiles to be merged.
     *
     * @return a {@code String}
     */
    public String getId()
    {
        return this.id;
    }

    /**
     * The conditional logic which will automatically trigger the inclusion of this
     * profile.
     *
     * @return a {@code Activation}
     */
    public Activation getActivation()
    {
        return this.activation;
    }

    /**
     * Information required to build the project.
     *
     * @return a {@code BuildBase}
     */
    public BuildBase getBuild()
    {
        return this.build;
    }

    /**
     * Gets the location of the specified field in the input source.
     */
    public InputLocation getLocation( Object key )
    {
        if ( key instanceof String )
        {
            switch ( ( String ) key )
            {
                case "id":
                    return idLocation;
                case "activation":
                    return activationLocation;
                case "build":
                    return buildLocation;
            }
        }
        return super.getLocation( key );
    }

    /**
     * Creates a new builder with this object as the basis.
     *
     * @return a {@code Builder}
     */
    @Nonnull
    public Builder with()
    {
        return newBuilder( this );
    }
    /**
     * Creates a new {@code Profile} instance using the specified modules.
     *
     * @param modules the new {@code Collection<String>} to use
     * @return a {@code Profile} with the specified modules
     */
    @Nonnull
    public Profile withModules( Collection<String> modules )
    {
        return with().modules( modules ).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified distributionManagement.
     *
     * @param distributionManagement the new {@code DistributionManagement} to use
     * @return a {@code Profile} with the specified distributionManagement
     */
    @Nonnull
    public Profile withDistributionManagement( DistributionManagement distributionManagement )
    {
        return with().distributionManagement( distributionManagement ).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified properties.
     *
     * @param properties the new {@code Map<String, String>} to use
     * @return a {@code Profile} with the specified properties
     */
    @Nonnull
    public Profile withProperties( Map<String, String> properties )
    {
        return with().properties( properties ).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified dependencyManagement.
     *
     * @param dependencyManagement the new {@code DependencyManagement} to use
     * @return a {@code Profile} with the specified dependencyManagement
     */
    @Nonnull
    public Profile withDependencyManagement( DependencyManagement dependencyManagement )
    {
        return with().dependencyManagement( dependencyManagement ).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified dependencies.
     *
     * @param dependencies the new {@code Collection<Dependency>} to use
     * @return a {@code Profile} with the specified dependencies
     */
    @Nonnull
    public Profile withDependencies( Collection<Dependency> dependencies )
    {
        return with().dependencies( dependencies ).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified repositories.
     *
     * @param repositories the new {@code Collection<Repository>} to use
     * @return a {@code Profile} with the specified repositories
     */
    @Nonnull
    public Profile withRepositories( Collection<Repository> repositories )
    {
        return with().repositories( repositories ).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified pluginRepositories.
     *
     * @param pluginRepositories the new {@code Collection<Repository>} to use
     * @return a {@code Profile} with the specified pluginRepositories
     */
    @Nonnull
    public Profile withPluginRepositories( Collection<Repository> pluginRepositories )
    {
        return with().pluginRepositories( pluginRepositories ).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified reporting.
     *
     * @param reporting the new {@code Reporting} to use
     * @return a {@code Profile} with the specified reporting
     */
    @Nonnull
    public Profile withReporting( Reporting reporting )
    {
        return with().reporting( reporting ).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified id.
     *
     * @param id the new {@code String} to use
     * @return a {@code Profile} with the specified id
     */
    @Nonnull
    public Profile withId( String id )
    {
        return with().id( id ).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified activation.
     *
     * @param activation the new {@code Activation} to use
     * @return a {@code Profile} with the specified activation
     */
    @Nonnull
    public Profile withActivation( Activation activation )
    {
        return with().activation( activation ).build();
    }
    /**
     * Creates a new {@code Profile} instance using the specified build.
     *
     * @param build the new {@code BuildBase} to use
     * @return a {@code Profile} with the specified build
     */
    @Nonnull
    public Profile withBuild( BuildBase build )
    {
        return with().build( build ).build();
    }

    /**
     * Creates a new {@code Profile} instance.
     * Equivalent to {@code newInstance( true )}.
     * @see #newInstance(boolean)
     *
     * @return a new {@code Profile}
     */
    @Nonnull
    public static Profile newInstance()
    {
        return newInstance( true );
    }

    /**
     * Creates a new {@code Profile} instance using default values or not.
     * Equivalent to {@code newBuilder( withDefaults ).build()}.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Profile}
     */
    @Nonnull
    public static Profile newInstance( boolean withDefaults )
    {
        return newBuilder( withDefaults ).build();
    }

    /**
     * Creates a new {@code Profile} builder instance.
     * Equivalent to {@code newBuilder( true )}.
     * @see #newBuilder(boolean)
     *
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder()
    {
        return newBuilder( true );
    }

    /**
     * Creates a new {@code Profile} builder instance using default values or not.
     *
     * @param withDefaults the boolean indicating whether default values should be used
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( boolean withDefaults )
    {
        return new Builder( withDefaults );
    }

    /**
     * Creates a new {@code Profile} builder instance using the specified object as a basis.
     * Equivalent to {@code newBuilder( from, false )}.
     *
     * @param from the {@code Profile} instance to use as a basis
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Profile from )
    {
        return newBuilder( from, false );
    }

    /**
     * Creates a new {@code Profile} builder instance using the specified object as a basis.
     *
     * @param from the {@code Profile} instance to use as a basis
     * @param forceCopy the boolean indicating if a copy should be forced
     * @return a new {@code Builder}
     */
    @Nonnull
    public static Builder newBuilder( Profile from, boolean forceCopy )
    {
        return new Builder( from, forceCopy );
    }

    /**
     * Builder class used to create Profile instances.
     * @see #with()
     * @see #newBuilder()
     */
    @NotThreadSafe
    public static class Builder
        extends ModelBase.Builder
    {
        Profile base;
        String id;
        Activation activation;
        BuildBase build;

        Builder( boolean withDefaults )
        {
            super( withDefaults );
            if ( withDefaults )
            {
                this.id = "default";
            }
        }

        Builder( Profile base, boolean forceCopy )
        {
            super( base, forceCopy );
            if ( forceCopy )
            {
                this.id = base.id;
                this.activation = base.activation;
                this.build = base.build;
            }
            else
            {
                this.base = base;
            }
        }

        @Nonnull
        public Builder modules( Collection<String> modules )
        {
            this.modules = modules;
            return this;
        }

        @Nonnull
        public Builder distributionManagement( DistributionManagement distributionManagement )
        {
            this.distributionManagement = distributionManagement;
            return this;
        }

        @Nonnull
        public Builder properties( Map<String, String> properties )
        {
            this.properties = properties;
            return this;
        }

        @Nonnull
        public Builder dependencyManagement( DependencyManagement dependencyManagement )
        {
            this.dependencyManagement = dependencyManagement;
            return this;
        }

        @Nonnull
        public Builder dependencies( Collection<Dependency> dependencies )
        {
            this.dependencies = dependencies;
            return this;
        }

        @Nonnull
        public Builder repositories( Collection<Repository> repositories )
        {
            this.repositories = repositories;
            return this;
        }

        @Nonnull
        public Builder pluginRepositories( Collection<Repository> pluginRepositories )
        {
            this.pluginRepositories = pluginRepositories;
            return this;
        }

        @Nonnull
        public Builder reporting( Reporting reporting )
        {
            this.reporting = reporting;
            return this;
        }

        @Nonnull
        public Builder id( String id )
        {
            this.id = id;
            return this;
        }

        @Nonnull
        public Builder activation( Activation activation )
        {
            this.activation = activation;
            return this;
        }

        @Nonnull
        public Builder build( BuildBase build )
        {
            this.build = build;
            return this;
        }


        @Nonnull
        public Builder location( Object key, InputLocation location )
        {
            if ( location != null )
            {
                if ( this.locations == null )
                {
                    this.locations = new HashMap<>();
                }
                this.locations.put( key, location );
            }
            return this;
        }

        @Nonnull
        public Profile build()
        {
            if ( base != null
                    && ( modules == null || modules == base.modules )
                    && ( distributionManagement == null || distributionManagement == base.distributionManagement )
                    && ( properties == null || properties == base.properties )
                    && ( dependencyManagement == null || dependencyManagement == base.dependencyManagement )
                    && ( dependencies == null || dependencies == base.dependencies )
                    && ( repositories == null || repositories == base.repositories )
                    && ( pluginRepositories == null || pluginRepositories == base.pluginRepositories )
                    && ( reporting == null || reporting == base.reporting )
                    && ( id == null || id == base.id )
                    && ( activation == null || activation == base.activation )
                    && ( build == null || build == base.build )
            )
            {
                return base;
            }
            Map<Object, InputLocation> locations = null;
            InputLocation location = null;
            InputLocation modulesLocation = null;
            InputLocation distributionManagementLocation = null;
            InputLocation propertiesLocation = null;
            InputLocation dependencyManagementLocation = null;
            InputLocation dependenciesLocation = null;
            InputLocation repositoriesLocation = null;
            InputLocation pluginRepositoriesLocation = null;
            InputLocation reportingLocation = null;
            InputLocation idLocation = null;
            InputLocation activationLocation = null;
            InputLocation buildLocation = null;
            if ( this.locations != null )
            {
                locations = this.locations;
                location = locations.remove( "" );
                modulesLocation = locations.remove( "modules" );
                distributionManagementLocation = locations.remove( "distributionManagement" );
                propertiesLocation = locations.remove( "properties" );
                dependencyManagementLocation = locations.remove( "dependencyManagement" );
                dependenciesLocation = locations.remove( "dependencies" );
                repositoriesLocation = locations.remove( "repositories" );
                pluginRepositoriesLocation = locations.remove( "pluginRepositories" );
                reportingLocation = locations.remove( "reporting" );
                idLocation = locations.remove( "id" );
                activationLocation = locations.remove( "activation" );
                buildLocation = locations.remove( "build" );
            }
            return new Profile(
                modules != null ? modules : ( base != null ? base.modules : null ),
                distributionManagement != null ? distributionManagement : ( base != null ? base.distributionManagement : null ),
                properties != null ? properties : ( base != null ? base.properties : null ),
                dependencyManagement != null ? dependencyManagement : ( base != null ? base.dependencyManagement : null ),
                dependencies != null ? dependencies : ( base != null ? base.dependencies : null ),
                repositories != null ? repositories : ( base != null ? base.repositories : null ),
                pluginRepositories != null ? pluginRepositories : ( base != null ? base.pluginRepositories : null ),
                reporting != null ? reporting : ( base != null ? base.reporting : null ),
                id != null ? id : ( base != null ? base.id : null ),
                activation != null ? activation : ( base != null ? base.activation : null ),
                build != null ? build : ( base != null ? base.build : null ),
                locations != null ? locations : ( base != null ? base.locations : null ),
                location != null ? location : ( base != null ? base.location : null ),
                modulesLocation != null ? modulesLocation : ( base != null ? base.modulesLocation : null ),
                distributionManagementLocation != null ? distributionManagementLocation : ( base != null ? base.distributionManagementLocation : null ),
                propertiesLocation != null ? propertiesLocation : ( base != null ? base.propertiesLocation : null ),
                dependencyManagementLocation != null ? dependencyManagementLocation : ( base != null ? base.dependencyManagementLocation : null ),
                dependenciesLocation != null ? dependenciesLocation : ( base != null ? base.dependenciesLocation : null ),
                repositoriesLocation != null ? repositoriesLocation : ( base != null ? base.repositoriesLocation : null ),
                pluginRepositoriesLocation != null ? pluginRepositoriesLocation : ( base != null ? base.pluginRepositoriesLocation : null ),
                reportingLocation != null ? reportingLocation : ( base != null ? base.reportingLocation : null ),
                idLocation != null ? idLocation : ( base != null ? base.idLocation : null ),
                activationLocation != null ? activationLocation : ( base != null ? base.activationLocation : null ),
                buildLocation != null ? buildLocation : ( base != null ? base.buildLocation : null )
            );
        }
    }


            
    public static final String SOURCE_POM = "pom";

    public static final String SOURCE_SETTINGS = "settings.xml";

    // We don't want this to be parseable...it's sort of 'hidden'
    // default source for this profile is in the pom itself.
    private String source = SOURCE_POM;

    public void setSource( String source )
    {
        this.source = source;
    }

    public String getSource()
    {
        return source;
    }

    /**
     * @see java.lang.Object#toString()
     */
    public String toString()
    {
        return "Profile {id: " + getId() + ", source: " + getSource() + "}";
    }
            
          
}
