/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.util;

import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Phaser;

public class PhasingExecutor
implements Executor,
AutoCloseable {
    private final ExecutorService executor;
    private final Phaser phaser = new Phaser();

    public PhasingExecutor(ExecutorService executor) {
        this.executor = executor;
        this.phaser.register();
    }

    @Override
    public void execute(Runnable command) {
        this.phaser.register();
        this.executor.submit(() -> {
            try {
                command.run();
            }
            finally {
                this.phaser.arriveAndDeregister();
            }
        });
    }

    public AutoCloseable phase() {
        this.phaser.register();
        return () -> this.phaser.awaitAdvance(this.phaser.arriveAndDeregister());
    }

    @Override
    public void close() {
        this.phaser.arriveAndAwaitAdvance();
        this.executor.shutdownNow();
    }
}

