/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.apache.maven.api.Artifact;
import org.apache.maven.api.DependencyCoordinates;
import org.apache.maven.api.DependencyScope;
import org.apache.maven.api.Node;
import org.apache.maven.api.PathScope;
import org.apache.maven.api.Project;
import org.apache.maven.api.Session;
import org.apache.maven.api.annotations.Nonnull;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.ArtifactResolver;
import org.apache.maven.api.services.ArtifactResolverException;
import org.apache.maven.api.services.ArtifactResolverResult;
import org.apache.maven.api.services.DependencyResolver;
import org.apache.maven.api.services.DependencyResolverException;
import org.apache.maven.api.services.DependencyResolverRequest;
import org.apache.maven.api.services.DependencyResolverResult;
import org.apache.maven.api.services.ProjectManager;
import org.apache.maven.internal.impl.AbstractNode;
import org.apache.maven.internal.impl.DefaultDependencyResolverResult;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.PathModularizationCache;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;

@Named
@Singleton
public class DefaultDependencyResolver
implements DependencyResolver {
    @Nonnull
    public DependencyResolverResult collect(@Nonnull DependencyResolverRequest request) throws DependencyResolverException, IllegalArgumentException {
        List remoteRepositories;
        Collection managedDependencies;
        Collection dependencies;
        DependencyCoordinates root;
        Artifact rootArtifact;
        Utils.nonNull(request, "request");
        InternalSession session = InternalSession.from(request.getSession());
        if (request.getProject().isPresent()) {
            Project project = (Project)request.getProject().get();
            rootArtifact = project.getPomArtifact();
            root = null;
            dependencies = project.getDependencies();
            managedDependencies = project.getManagedDependencies();
            remoteRepositories = request.getRepositories() != null ? request.getRepositories() : ((ProjectManager)session.getService(ProjectManager.class)).getRemoteProjectRepositories(project);
        } else {
            rootArtifact = request.getRootArtifact().orElse(null);
            root = request.getRoot().orElse(null);
            dependencies = request.getDependencies();
            managedDependencies = request.getManagedDependencies();
            remoteRepositories = request.getRepositories() != null ? request.getRepositories() : session.getRemoteRepositories();
        }
        CollectRequest collectRequest = new CollectRequest().setRootArtifact(rootArtifact != null ? session.toArtifact(rootArtifact) : null).setRoot(root != null ? session.toDependency(root, false) : null).setDependencies(session.toDependencies(dependencies, false)).setManagedDependencies(session.toDependencies(managedDependencies, true)).setRepositories(session.toRepositories(remoteRepositories));
        RepositorySystemSession systemSession = session.getSession();
        if (request.getVerbose()) {
            systemSession = new DefaultRepositorySystemSession(systemSession).setConfigProperty("aether.conflictResolver.verbose", (Object)true).setConfigProperty("aether.dependencyManager.verbose", (Object)true);
        }
        try {
            CollectResult result = session.getRepositorySystem().collectDependencies(systemSession, collectRequest);
            return new DefaultDependencyResolverResult(null, result.getExceptions(), session.getNode(result.getRoot(), request.getVerbose()), 0);
        }
        catch (DependencyCollectionException e) {
            throw new DependencyResolverException("Unable to collect dependencies", (Throwable)e);
        }
    }

    public List<Node> flatten(Session s, Node node, PathScope scope) throws DependencyResolverException {
        InternalSession session = InternalSession.from(s);
        DependencyNode root = Utils.cast(AbstractNode.class, node, "node").getDependencyNode();
        List dependencies = session.getRepositorySystem().flattenDependencyNodes(session.getSession(), root, DefaultDependencyResolver.getScopeDependencyFilter(scope));
        dependencies.remove(root);
        return Utils.map(dependencies, session::getNode);
    }

    private static DependencyFilter getScopeDependencyFilter(PathScope scope) {
        Set scopes = scope.dependencyScopes().stream().map(DependencyScope::id).collect(Collectors.toSet());
        return (n, p) -> {
            Dependency d = n.getDependency();
            return d == null || scopes.contains(d.getScope());
        };
    }

    public DependencyResolverResult resolve(DependencyResolverRequest request) throws DependencyResolverException, DependencyResolverException, ArtifactResolverException {
        DependencyResolverResult result;
        List repositories;
        InternalSession session = InternalSession.from(Utils.nonNull(request, "request").getSession());
        DependencyResolverResult collectorResult = this.collect(request);
        List list = repositories = request.getRepositories() != null ? request.getRepositories() : session.getRemoteRepositories();
        if (request.getRequestType() == DependencyResolverRequest.RequestType.COLLECT) {
            result = collectorResult;
        } else {
            List<Node> nodes = this.flatten(session, collectorResult.getRoot(), request.getPathScope());
            List coordinates = nodes.stream().map(Node::getDependency).filter(Objects::nonNull).map(Artifact::toCoordinates).collect(Collectors.toList());
            Predicate filter = request.getPathTypeFilter();
            if (request.getRequestType() == DependencyResolverRequest.RequestType.FLATTEN) {
                DefaultDependencyResolverResult flattenResult = new DefaultDependencyResolverResult(null, collectorResult.getExceptions(), collectorResult.getRoot(), nodes.size());
                for (Node node : nodes) {
                    flattenResult.addNode(node);
                }
                result = flattenResult;
            } else {
                PathModularizationCache cache = new PathModularizationCache();
                DefaultDependencyResolverResult resolverResult = new DefaultDependencyResolverResult(cache, collectorResult.getExceptions(), collectorResult.getRoot(), nodes.size());
                ArtifactResolverResult artifactResolverResult = ((ArtifactResolver)session.getService(ArtifactResolver.class)).resolve((Session)session, coordinates, repositories);
                for (Node node : nodes) {
                    org.apache.maven.api.Dependency d = node.getDependency();
                    Path path = d != null ? artifactResolverResult.getPath((Artifact)d) : null;
                    try {
                        resolverResult.addDependency(node, d, filter, path);
                    }
                    catch (IOException e) {
                        throw DefaultDependencyResolver.cannotReadModuleInfo(path, e);
                    }
                }
                result = resolverResult;
            }
        }
        return result;
    }

    private static DependencyResolverException cannotReadModuleInfo(Path path, IOException cause) {
        return new DependencyResolverException("Cannot read module information of " + path, (Throwable)cause);
    }
}

