/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.model;

import java.util.Map;
import java.util.Properties;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.ModelBuilderRequest;
import org.apache.maven.api.services.model.ModelVersionProcessor;

@Named
@Singleton
public class DefaultModelVersionProcessor
implements ModelVersionProcessor {
    private static final String SHA1_PROPERTY = "sha1";
    private static final String CHANGELIST_PROPERTY = "changelist";
    private static final String REVISION_PROPERTY = "revision";

    @Override
    public boolean isValidProperty(String property) {
        return REVISION_PROPERTY.equals(property) || CHANGELIST_PROPERTY.equals(property) || SHA1_PROPERTY.equals(property);
    }

    @Override
    public void overwriteModelProperties(Properties modelProperties, ModelBuilderRequest request) {
        Map props = request.getUserProperties();
        if (props.containsKey(REVISION_PROPERTY)) {
            modelProperties.put(REVISION_PROPERTY, props.get(REVISION_PROPERTY));
        }
        if (props.containsKey(CHANGELIST_PROPERTY)) {
            modelProperties.put(CHANGELIST_PROPERTY, props.get(CHANGELIST_PROPERTY));
        }
        if (props.containsKey(SHA1_PROPERTY)) {
            modelProperties.put(SHA1_PROPERTY, props.get(SHA1_PROPERTY));
        }
    }
}

