/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.maven.api.Repository;
import org.apache.maven.api.Version;
import org.apache.maven.api.di.Inject;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.VersionRangeResolver;
import org.apache.maven.api.services.VersionRangeResolverException;
import org.apache.maven.api.services.VersionRangeResolverRequest;
import org.apache.maven.api.services.VersionRangeResolverResult;
import org.apache.maven.internal.impl.DefaultLocalRepository;
import org.apache.maven.internal.impl.DefaultRemoteRepository;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.repository.ArtifactRepository;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.VersionRangeRequest;
import org.eclipse.aether.resolution.VersionRangeResolutionException;
import org.eclipse.aether.resolution.VersionRangeResult;

@Named
@Singleton
public class DefaultVersionRangeResolver
implements VersionRangeResolver {
    private final RepositorySystem repositorySystem;

    @Inject
    public DefaultVersionRangeResolver(RepositorySystem repositorySystem) {
        this.repositorySystem = repositorySystem;
    }

    public VersionRangeResolverResult resolve(VersionRangeResolverRequest request) throws VersionRangeResolverException {
        Utils.nonNull(request, "request");
        final InternalSession session = InternalSession.from(request.getSession());
        try {
            final VersionRangeResult res = this.repositorySystem.resolveVersionRange(session.getSession(), new VersionRangeRequest(session.toArtifact(request.getArtifactCoordinates()), session.toRepositories(session.getRemoteRepositories()), null));
            final Map<String, ArtifactRepository> repos = res.getVersions().stream().filter(v -> res.getRepository(v) != null).collect(Collectors.toMap(v -> v.toString(), arg_0 -> ((VersionRangeResult)res).getRepository(arg_0)));
            return new VersionRangeResolverResult(){

                public List<Exception> getExceptions() {
                    return res.getExceptions();
                }

                public List<Version> getVersions() {
                    return Utils.map(res.getVersions(), v -> session.parseVersion(v.toString()));
                }

                public Optional<Repository> getRepository(Version version) {
                    ArtifactRepository repo = (ArtifactRepository)repos.get(version.toString());
                    if (repo instanceof LocalRepository) {
                        return Optional.of(new DefaultLocalRepository((LocalRepository)repo));
                    }
                    if (repo instanceof RemoteRepository) {
                        return Optional.of(new DefaultRemoteRepository((RemoteRepository)repo));
                    }
                    return Optional.empty();
                }
            };
        }
        catch (VersionRangeResolutionException e) {
            throw new VersionRangeResolverException("Unable to resolve version range", (Throwable)e);
        }
    }
}

