/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl;

import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.maven.api.ArtifactCoordinates;
import org.apache.maven.api.DownloadedArtifact;
import org.apache.maven.api.di.Named;
import org.apache.maven.api.di.Singleton;
import org.apache.maven.api.services.ArtifactManager;
import org.apache.maven.api.services.ArtifactResolver;
import org.apache.maven.api.services.ArtifactResolverException;
import org.apache.maven.api.services.ArtifactResolverRequest;
import org.apache.maven.api.services.ArtifactResolverResult;
import org.apache.maven.internal.impl.InternalSession;
import org.apache.maven.internal.impl.Utils;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.resolution.ArtifactRequest;
import org.eclipse.aether.resolution.ArtifactResolutionException;
import org.eclipse.aether.resolution.ArtifactResult;

@Named
@Singleton
public class DefaultArtifactResolver
implements ArtifactResolver {
    public ArtifactResolverResult resolve(ArtifactResolverRequest request) throws ArtifactResolverException, IllegalArgumentException {
        Utils.nonNull(request, "request");
        InternalSession session = InternalSession.from(request.getSession());
        try {
            Path path;
            org.apache.maven.api.Artifact artifact;
            HashMap<DownloadedArtifact, Path> paths = new HashMap<DownloadedArtifact, Path>();
            ArtifactManager artifactManager = (ArtifactManager)session.getService(ArtifactManager.class);
            List<RemoteRepository> repositories = session.toRepositories(session.getRemoteRepositories());
            ArrayList<ArtifactRequest> requests = new ArrayList<ArtifactRequest>();
            for (ArtifactCoordinates coords : request.getCoordinates()) {
                Artifact aetherArtifact = session.toArtifact(coords);
                artifact = session.getArtifact(aetherArtifact);
                path = artifactManager.getPath(artifact).orElse(null);
                if (path != null) {
                    if (aetherArtifact.getPath() == null) {
                        aetherArtifact = aetherArtifact.setPath(path);
                    }
                    DownloadedArtifact resolved = session.getArtifact(DownloadedArtifact.class, aetherArtifact);
                    paths.put(resolved, path);
                    continue;
                }
                requests.add(new ArtifactRequest(aetherArtifact, repositories, null));
            }
            if (!requests.isEmpty()) {
                List results = session.getRepositorySystem().resolveArtifacts(session.getSession(), requests);
                for (ArtifactResult result : results) {
                    artifact = session.getArtifact(DownloadedArtifact.class, result.getArtifact());
                    path = result.getArtifact().getPath();
                    paths.put((DownloadedArtifact)artifact, path);
                }
            }
            return new DefaultArtifactResolverResult(paths);
        }
        catch (ArtifactResolutionException e) {
            throw new ArtifactResolverException("Unable to resolve artifact: " + e.getMessage(), (Exception)((Object)e));
        }
    }

    static class DefaultArtifactResolverResult
    implements ArtifactResolverResult {
        final Map<DownloadedArtifact, Path> paths;

        DefaultArtifactResolverResult(Map<DownloadedArtifact, Path> paths) {
            this.paths = paths;
        }

        public Collection<DownloadedArtifact> getArtifacts() {
            return this.paths.keySet();
        }

        public Path getPath(org.apache.maven.api.Artifact artifact) {
            return this.paths.get(artifact);
        }
    }
}

