/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.internal.impl.resolver;

import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;
import org.apache.maven.api.xml.XmlNode;
import org.apache.maven.internal.impl.resolver.PluginsMetadata;
import org.apache.maven.internal.xml.XmlNodeImpl;
import org.apache.maven.internal.xml.XmlNodeStaxBuilder;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.deployment.DeployRequest;
import org.eclipse.aether.impl.MetadataGenerator;
import org.eclipse.aether.installation.InstallRequest;
import org.eclipse.aether.metadata.Metadata;
import org.eclipse.aether.util.ConfigUtils;

class PluginsMetadataGenerator
implements MetadataGenerator {
    private static final String PLUGIN_DESCRIPTOR_LOCATION = "META-INF/maven/plugin.xml";
    private final Map<Object, PluginsMetadata> processedPlugins = new LinkedHashMap<Object, PluginsMetadata>();
    private final Date timestamp;

    PluginsMetadataGenerator(RepositorySystemSession session, InstallRequest request) {
        this(session, request.getMetadata());
    }

    PluginsMetadataGenerator(RepositorySystemSession session, DeployRequest request) {
        this(session, request.getMetadata());
    }

    private PluginsMetadataGenerator(RepositorySystemSession session, Collection<? extends Metadata> metadatas) {
        this.timestamp = (Date)ConfigUtils.getObject((RepositorySystemSession)session, (Object)new Date(), (String[])new String[]{"maven.startTime"});
        Iterator<? extends Metadata> it = metadatas.iterator();
        while (it.hasNext()) {
            Metadata metadata = it.next();
            if (!(metadata instanceof PluginsMetadata)) continue;
            PluginsMetadata pluginMetadata = (PluginsMetadata)metadata;
            it.remove();
            this.processedPlugins.put(pluginMetadata.getGroupId(), pluginMetadata);
        }
    }

    public Collection<? extends Metadata> prepare(Collection<? extends Artifact> artifacts) {
        return Collections.emptyList();
    }

    public Artifact transformArtifact(Artifact artifact) {
        return artifact;
    }

    public Collection<? extends Metadata> finish(Collection<? extends Artifact> artifacts) {
        LinkedHashMap<String, PluginsMetadata> plugins = new LinkedHashMap<String, PluginsMetadata>();
        for (Artifact artifact : artifacts) {
            PluginsMetadata pluginMetadata;
            String key;
            PluginsMetadata.PluginInfo pluginInfo = this.extractPluginInfo(artifact);
            if (pluginInfo == null || this.processedPlugins.get(key = pluginInfo.groupId) != null || (pluginMetadata = (PluginsMetadata)((Object)plugins.get(key))) != null) continue;
            pluginMetadata = new PluginsMetadata(pluginInfo, this.timestamp);
            plugins.put(key, pluginMetadata);
        }
        return plugins.values();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private PluginsMetadata.PluginInfo extractPluginInfo(Artifact artifact) {
        if (artifact == null) return null;
        if (!"jar".equals(artifact.getExtension())) return null;
        if (!"".equals(artifact.getClassifier())) return null;
        if (artifact.getPath() == null) return null;
        Path artifactPath = artifact.getPath();
        if (!Files.isRegularFile(artifactPath, new LinkOption[0])) return null;
        try (JarFile artifactJar = new JarFile(artifactPath.toFile(), false);){
            ZipEntry pluginDescriptorEntry = artifactJar.getEntry(PLUGIN_DESCRIPTOR_LOCATION);
            if (pluginDescriptorEntry == null) return null;
            try (InputStream is = artifactJar.getInputStream(pluginDescriptorEntry);){
                XmlNodeImpl root = XmlNodeStaxBuilder.build((InputStream)is, null);
                String groupId = PluginsMetadataGenerator.mayGetChild((XmlNode)root, "groupId");
                String artifactId = PluginsMetadataGenerator.mayGetChild((XmlNode)root, "artifactId");
                String goalPrefix = PluginsMetadataGenerator.mayGetChild((XmlNode)root, "goalPrefix");
                String name = PluginsMetadataGenerator.mayGetChild((XmlNode)root, "name");
                if (!Objects.equals(artifact.getGroupId(), groupId)) throw new InvalidArtifactPluginMetadataException("Artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " JAR (to be installed/deployed) contains Maven Plugin metadata for plugin " + groupId + ":" + artifactId + "; coordinates are conflicting. Most probably your JAR contains rogue Maven Plugin metadata, possible causes may be: shaded in Maven Plugin or some rogue resource)");
                if (!Objects.equals(artifact.getArtifactId(), artifactId)) throw new InvalidArtifactPluginMetadataException("Artifact " + artifact.getGroupId() + ":" + artifact.getArtifactId() + " JAR (to be installed/deployed) contains Maven Plugin metadata for plugin " + groupId + ":" + artifactId + "; coordinates are conflicting. Most probably your JAR contains rogue Maven Plugin metadata, possible causes may be: shaded in Maven Plugin or some rogue resource)");
                PluginsMetadata.PluginInfo pluginInfo = new PluginsMetadata.PluginInfo(groupId, artifactId, goalPrefix, name);
                return pluginInfo;
            }
        }
        catch (Exception e) {
            if (!(e instanceof InvalidArtifactPluginMetadataException)) return null;
            InvalidArtifactPluginMetadataException iapme = (InvalidArtifactPluginMetadataException)e;
            throw iapme;
        }
    }

    private static String mayGetChild(XmlNode node, String child) {
        XmlNode c = node.getChild(child);
        if (c != null) {
            return c.getValue();
        }
        return null;
    }

    public static final class InvalidArtifactPluginMetadataException
    extends IllegalArgumentException {
        InvalidArtifactPluginMetadataException(String s) {
            super(s);
        }
    }
}

