/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.reader;

import java.io.Closeable;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import java.util.zip.GZIPOutputStream;

public class ChunkWriter
implements Closeable {
    private static final int F_INDEXED = 1;
    private static final int F_TOKENIZED = 2;
    private static final int F_STORED = 4;
    private final String chunkName;
    private final DataOutputStream dataOutputStream;
    private final int version;
    private final Date timestamp;

    public ChunkWriter(String chunkName, OutputStream outputStream, int version, Date timestamp) throws IOException {
        this.chunkName = chunkName.trim();
        this.dataOutputStream = new DataOutputStream(new GZIPOutputStream(outputStream, 2048));
        this.version = version;
        this.timestamp = timestamp;
        this.dataOutputStream.writeByte(version);
        this.dataOutputStream.writeLong(timestamp == null ? -1L : timestamp.getTime());
    }

    public String getName() {
        return this.chunkName;
    }

    public int getVersion() {
        return this.version;
    }

    public Date getTimestamp() {
        return this.timestamp;
    }

    public int writeChunk(Iterator<Map<String, String>> iterator) throws IOException {
        int written = 0;
        while (iterator.hasNext()) {
            ChunkWriter.writeRecord(iterator.next(), this.dataOutputStream);
            ++written;
        }
        return written;
    }

    @Override
    public void close() throws IOException {
        this.dataOutputStream.close();
    }

    private static void writeRecord(Map<String, String> record, DataOutput dataOutput) throws IOException {
        dataOutput.writeInt(record.size());
        for (Map.Entry<String, String> entry : record.entrySet()) {
            ChunkWriter.writeField(entry.getKey(), entry.getValue(), dataOutput);
        }
    }

    private static void writeField(String fieldName, String fieldValue, DataOutput dataOutput) throws IOException {
        boolean isIndexed = !fieldName.equals("i") && !fieldName.equals("m");
        boolean isTokenized = !fieldName.equals("i") && !fieldName.equals("m") && !fieldName.equals("1") && !fieldName.equals("px");
        int flags = (isIndexed ? 1 : 0) + (isTokenized ? 2 : 0) + 4;
        dataOutput.writeByte(flags);
        dataOutput.writeUTF(fieldName);
        ChunkWriter.writeUTF(fieldValue, dataOutput);
    }

    private static void writeUTF(String str, DataOutput dataOutput) throws IOException {
        int i;
        char c;
        int strlen = str.length();
        int utflen = 0;
        for (int i2 = 0; i2 < strlen; ++i2) {
            c = str.charAt(i2);
            if (c >= '\u0001' && c <= '\u007f') {
                ++utflen;
                continue;
            }
            if (c > '\u07ff') {
                utflen += 3;
                continue;
            }
            utflen += 2;
        }
        dataOutput.writeInt(utflen);
        byte[] bytearr = new byte[utflen];
        int count = 0;
        for (i = 0; i < strlen && (c = str.charAt(i)) >= '\u0001' && c <= '\u007f'; ++i) {
            bytearr[count++] = (byte)c;
        }
        while (i < strlen) {
            c = str.charAt(i);
            if (c >= '\u0001' && c <= '\u007f') {
                bytearr[count++] = (byte)c;
            } else if (c > '\u07ff') {
                bytearr[count++] = (byte)(0xE0 | c >> 12 & 0xF);
                bytearr[count++] = (byte)(0x80 | c >> 6 & 0x3F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
            } else {
                bytearr[count++] = (byte)(0xC0 | c >> 6 & 0x1F);
                bytearr[count++] = (byte)(0x80 | c & 0x3F);
            }
            ++i;
        }
        dataOutput.write(bytearr, 0, utflen);
    }
}

