/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.reader;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Properties;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.maven.index.reader.ResourceHandler;
import org.apache.maven.index.reader.WritableResourceHandler;

public final class Utils {
    static final String INDEX_FILE_PREFIX = "nexus-maven-repository-index";
    static final DateFormat INDEX_DATE_FORMAT = new SimpleDateFormat("yyyyMMddHHmmss.SSS Z");
    static final String FIELD_SEPARATOR = "|";
    static final String NOT_AVAILABLE = "NA";
    static final String UINFO = "u";
    static final String INFO = "i";
    static final Pattern FS_PATTERN;

    private Utils() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Properties loadProperties(InputStream inputStream) throws IOException {
        try {
            Properties properties = new Properties();
            properties.load(inputStream);
            Properties properties2 = properties;
            return properties2;
        }
        finally {
            inputStream.close();
        }
    }

    static Properties loadProperties(ResourceHandler.Resource resource) throws IOException {
        InputStream inputStream = resource.read();
        if (inputStream == null) {
            return null;
        }
        return Utils.loadProperties(resource.read());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void storeProperties(OutputStream outputStream, Properties properties) throws IOException {
        try {
            properties.store(outputStream, "Maven Indexer Writer");
        }
        finally {
            outputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void storeProperties(WritableResourceHandler.WritableResource writableResource, Properties properties) throws IOException {
        try {
            Utils.storeProperties(writableResource.write(), properties);
        }
        finally {
            writableResource.close();
        }
    }

    static String renvl(String v) {
        return NOT_AVAILABLE.equals(v) ? null : v;
    }

    static String nvl(String v) {
        return v == null ? NOT_AVAILABLE : v;
    }

    static String rootGroup(String groupId) {
        int n = groupId.indexOf(46);
        if (n > -1) {
            return groupId.substring(0, n);
        }
        return groupId;
    }

    static {
        INDEX_DATE_FORMAT.setTimeZone(TimeZone.getTimeZone("GMT"));
        FS_PATTERN = Pattern.compile(Pattern.quote(FIELD_SEPARATOR));
    }
}

