/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.reader;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.TreeSet;
import org.apache.maven.index.reader.Record;
import org.apache.maven.index.reader.RecordCompactor;
import org.apache.maven.index.reader.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Transform {
    private Transform() {
    }

    public static <I, O> Iterable<O> transform(final Iterable<I> iterable, final Function<I, O> function) {
        return new Iterable<O>(){

            @Override
            public Iterator<O> iterator() {
                return new TransformIterator(iterable.iterator(), function);
            }
        };
    }

    public static Iterable<Map<String, String>> decorateAndTransform(Iterable<Record> iterable, final String repoId) {
        final RecordCompactor recordCompactor = new RecordCompactor();
        final TreeSet<String> allGroups = new TreeSet<String>();
        final TreeSet<String> rootGroups = new TreeSet<String>();
        final ArrayList<Iterator<Record>> iterators = new ArrayList<Iterator<Record>>();
        iterators.add(Collections.singletonList(Transform.descriptor(repoId)).iterator());
        iterators.add(iterable.iterator());
        iterators.add(Collections.singletonList(Transform.allGroups(allGroups)).iterator());
        iterators.add(Collections.singletonList(Transform.rootGroups(rootGroups)).iterator());
        return Transform.transform(new Iterable<Record>(){

            @Override
            public Iterator<Record> iterator() {
                return new ConcatIterator<Record>(iterators.iterator());
            }
        }, new Function<Record, Map<String, String>>(){

            @Override
            public Map<String, String> apply(Record rec) {
                if (Record.Type.DESCRIPTOR == rec.getType()) {
                    return recordCompactor.apply(Transform.descriptor(repoId));
                }
                if (Record.Type.ALL_GROUPS == rec.getType()) {
                    return recordCompactor.apply(Transform.allGroups(allGroups));
                }
                if (Record.Type.ROOT_GROUPS == rec.getType()) {
                    return recordCompactor.apply(Transform.rootGroups(rootGroups));
                }
                String groupId = rec.get(Record.GROUP_ID);
                if (groupId != null) {
                    allGroups.add(groupId);
                    rootGroups.add(Utils.rootGroup(groupId));
                }
                return recordCompactor.apply(rec);
            }
        });
    }

    private static Record descriptor(String repoId) {
        HashMap<Record.EntryKey, Object> entries = new HashMap<Record.EntryKey, Object>();
        entries.put(Record.REPOSITORY_ID, repoId);
        return new Record(Record.Type.DESCRIPTOR, entries);
    }

    private static Record allGroups(Collection<String> allGroups) {
        HashMap<Record.EntryKey, Object> entries = new HashMap<Record.EntryKey, Object>();
        entries.put(Record.ALL_GROUPS, allGroups.toArray(new String[allGroups.size()]));
        return new Record(Record.Type.ALL_GROUPS, entries);
    }

    private static Record rootGroups(Collection<String> rootGroups) {
        HashMap<Record.EntryKey, Object> entries = new HashMap<Record.EntryKey, Object>();
        entries.put(Record.ROOT_GROUPS, rootGroups.toArray(new String[rootGroups.size()]));
        return new Record(Record.Type.ROOT_GROUPS, entries);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class ConcatIterator<T>
    implements Iterator<T> {
        private final Iterator<Iterator<T>> iterators;
        private Iterator<T> current;
        private T nextElement;

        private ConcatIterator(Iterator<Iterator<T>> iterators) {
            this.iterators = iterators;
            this.nextElement = this.getNextElement();
        }

        @Override
        public boolean hasNext() {
            return this.nextElement != null;
        }

        @Override
        public T next() {
            if (this.nextElement == null) {
                throw new NoSuchElementException();
            }
            T result = this.nextElement;
            this.nextElement = this.getNextElement();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }

        protected T getNextElement() {
            if ((this.current == null || !this.current.hasNext()) && this.iterators.hasNext()) {
                this.current = this.iterators.next();
            }
            while (this.current != null && !this.current.hasNext()) {
                if (!this.iterators.hasNext()) {
                    this.current = null;
                    break;
                }
                this.current = this.iterators.next();
            }
            if (this.current != null) {
                return this.current.next();
            }
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TransformIterator<I, O>
    implements Iterator<O> {
        private final Iterator<I> iterator;
        private final Function<I, O> function;

        private TransformIterator(Iterator<I> iterator, Function<I, O> function) {
            this.iterator = iterator;
            this.function = function;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public O next() {
            return this.function.apply(this.iterator.next());
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("remove");
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface Function<I, O> {
        public O apply(I var1);
    }
}

