/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.reader;

import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Record {
    public static final EntryKey<String> REPOSITORY_ID = new EntryKey<String>("repositoryId", String.class);
    public static final EntryKey<String[]> ALL_GROUPS = new EntryKey<String[]>("allGroups", String[].class);
    public static final EntryKey<String[]> ROOT_GROUPS = new EntryKey<String[]>("rootGroups", String[].class);
    public static final EntryKey<Long> REC_MODIFIED = new EntryKey<Long>("recordModified", Long.class);
    public static final EntryKey<String> GROUP_ID = new EntryKey<String>("groupId", String.class);
    public static final EntryKey<String> ARTIFACT_ID = new EntryKey<String>("artifactId", String.class);
    public static final EntryKey<String> VERSION = new EntryKey<String>("version", String.class);
    public static final EntryKey<String> CLASSIFIER = new EntryKey<String>("classifier", String.class);
    public static final EntryKey<String> PACKAGING = new EntryKey<String>("packaging", String.class);
    public static final EntryKey<String> FILE_EXTENSION = new EntryKey<String>("fileExtension", String.class);
    public static final EntryKey<Long> FILE_MODIFIED = new EntryKey<Long>("fileModified", Long.class);
    public static final EntryKey<Long> FILE_SIZE = new EntryKey<Long>("fileSize", Long.class);
    public static final EntryKey<Boolean> HAS_SOURCES = new EntryKey<Boolean>("hasSources", Boolean.class);
    public static final EntryKey<Boolean> HAS_JAVADOC = new EntryKey<Boolean>("hasJavadoc", Boolean.class);
    public static final EntryKey<Boolean> HAS_SIGNATURE = new EntryKey<Boolean>("hasSignature", Boolean.class);
    public static final EntryKey<String> NAME = new EntryKey<String>("name", String.class);
    public static final EntryKey<String> DESCRIPTION = new EntryKey<String>("description", String.class);
    public static final EntryKey<String> SHA1 = new EntryKey<String>("sha1", String.class);
    public static final EntryKey<String[]> CLASSNAMES = new EntryKey<String[]>("classNames", String[].class);
    public static final EntryKey<String> PLUGIN_PREFIX = new EntryKey<String>("pluginPrefix", String.class);
    public static final EntryKey<String[]> PLUGIN_GOALS = new EntryKey<String[]>("pluginGoals", String[].class);
    public static final EntryKey<String> OSGI_BUNDLE_SYMBOLIC_NAME = new EntryKey<String>("Bundle-SymbolicName", String.class);
    public static final EntryKey<String> OSGI_BUNDLE_VERSION = new EntryKey<String>("Bundle-Version", String.class);
    public static final EntryKey<String> OSGI_EXPORT_PACKAGE = new EntryKey<String>("Export-Package", String.class);
    public static final EntryKey<String> OSGI_EXPORT_SERVICE = new EntryKey<String>("Export-Service", String.class);
    public static final EntryKey<String> OSGI_BUNDLE_DESCRIPTION = new EntryKey<String>("Bundle-Description", String.class);
    public static final EntryKey<String> OSGI_BUNDLE_NAME = new EntryKey<String>("Bundle-Name", String.class);
    public static final EntryKey<String> OSGI_BUNDLE_LICENSE = new EntryKey<String>("Bundle-License", String.class);
    public static final EntryKey<String> OSGI_EXPORT_DOCURL = new EntryKey<String>("Bundle-DocURL", String.class);
    public static final EntryKey<String> OSGI_IMPORT_PACKAGE = new EntryKey<String>("Import-Package", String.class);
    public static final EntryKey<String> OSGI_REQUIRE_BUNDLE = new EntryKey<String>("Require-Bundle", String.class);
    private final Type type;
    private final Map<EntryKey, Object> expanded;

    public Record(Type type, Map<EntryKey, Object> expanded) {
        this.type = type;
        this.expanded = expanded;
    }

    public Type getType() {
        return this.type;
    }

    public Map<EntryKey, Object> getExpanded() {
        return this.expanded;
    }

    boolean containsKey(EntryKey<?> entryKey) {
        return this.expanded.containsKey(entryKey);
    }

    public <T> T get(EntryKey<T> entryKey) {
        return entryKey.coerce(this.expanded.get(entryKey));
    }

    public <T> T put(EntryKey<T> entryKey, T value) {
        if (value == null) {
            return entryKey.coerce(this.expanded.remove(entryKey));
        }
        if (!((EntryKey)entryKey).proto.isAssignableFrom(value.getClass())) {
            throw new IllegalArgumentException("Key " + entryKey + " does not accepts value " + value);
        }
        return entryKey.coerce(this.expanded.put(entryKey, value));
    }

    public String toString() {
        return "Record{type=" + (Object)((Object)this.type) + ", expanded=" + this.expanded + '}';
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Type {
        DESCRIPTOR,
        ARTIFACT_ADD,
        ARTIFACT_REMOVE,
        ALL_GROUPS,
        ROOT_GROUPS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class EntryKey<T> {
        private final String name;
        private final Class<T> proto;

        public EntryKey(String name, Class<T> proto) {
            if (name == null) {
                throw new NullPointerException("name is null");
            }
            if (proto == null) {
                throw new NullPointerException("proto is null");
            }
            this.name = name;
            this.proto = proto;
        }

        public T coerce(Object object) {
            return this.proto.cast(object);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof EntryKey)) {
                return false;
            }
            EntryKey entryKey = (EntryKey)o;
            return this.name.equals(entryKey.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "Key{name='" + this.name + '\'' + ", type=" + this.proto.getSimpleName() + '}';
        }
    }
}

