/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.indexer.examples.indexing;

import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.PreDestroy;
import javax.inject.Singleton;
import org.apache.maven.indexer.examples.indexing.RepositoryIndexer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Singleton
@Component
public class RepositoryIndexManager {
    private static final Logger logger = LoggerFactory.getLogger(RepositoryIndexManager.class);
    private Map<String, RepositoryIndexer> indexes = new LinkedHashMap<String, RepositoryIndexer>();

    @PreDestroy
    private void close() {
        for (String repositoryId : this.indexes.keySet()) {
            try {
                RepositoryIndexer repositoryIndexer = this.indexes.get(repositoryId);
                logger.debug("Closing indexer for " + repositoryIndexer.getRepositoryId() + "...");
                repositoryIndexer.close();
                logger.debug("Closed indexer for " + repositoryIndexer.getRepositoryId() + ".");
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    public Map<String, RepositoryIndexer> getIndexes() {
        return this.indexes;
    }

    public void setIndexes(Map<String, RepositoryIndexer> indexes) {
        this.indexes = indexes;
    }

    public RepositoryIndexer getRepositoryIndex(String repositoryId) {
        return this.indexes.get(repositoryId);
    }

    public RepositoryIndexer addRepositoryIndex(String repositoryId, RepositoryIndexer value) {
        return this.indexes.put(repositoryId, value);
    }

    public RepositoryIndexer removeRepositoryIndex(String repositoryId) {
        return this.indexes.remove(repositoryId);
    }
}

