/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ckb;

import org.apache.lucene.analysis.util.StemmerUtil;

public class SoraniNormalizer {
    static final char YEH = '\u064a';
    static final char DOTLESS_YEH = '\u0649';
    static final char FARSI_YEH = '\u06cc';
    static final char KAF = '\u0643';
    static final char KEHEH = '\u06a9';
    static final char HEH = '\u0647';
    static final char AE = '\u06d5';
    static final char ZWNJ = '\u200c';
    static final char HEH_DOACHASHMEE = '\u06be';
    static final char TEH_MARBUTA = '\u0629';
    static final char REH = '\u0631';
    static final char RREH = '\u0695';
    static final char RREH_ABOVE = '\u0692';
    static final char TATWEEL = '\u0640';
    static final char FATHATAN = '\u064b';
    static final char DAMMATAN = '\u064c';
    static final char KASRATAN = '\u064d';
    static final char FATHA = '\u064e';
    static final char DAMMA = '\u064f';
    static final char KASRA = '\u0650';
    static final char SHADDA = '\u0651';
    static final char SUKUN = '\u0652';

    public int normalize(char[] s2, int len) {
        block11: for (int i = 0; i < len; ++i) {
            switch (s2[i]) {
                case '\u0649': 
                case '\u064a': {
                    s2[i] = 1740;
                    continue block11;
                }
                case '\u0643': {
                    s2[i] = 1705;
                    continue block11;
                }
                case '\u200c': {
                    if (i > 0 && s2[i - 1] == '\u0647') {
                        s2[i - 1] = 1749;
                    }
                    len = StemmerUtil.delete(s2, i, len);
                    --i;
                    continue block11;
                }
                case '\u0647': {
                    if (i != len - 1) continue block11;
                    s2[i] = 1749;
                    continue block11;
                }
                case '\u0629': {
                    s2[i] = 1749;
                    continue block11;
                }
                case '\u06be': {
                    s2[i] = 1607;
                    continue block11;
                }
                case '\u0631': {
                    if (i != 0) continue block11;
                    s2[i] = 1685;
                    continue block11;
                }
                case '\u0692': {
                    s2[i] = 1685;
                    continue block11;
                }
                case '\u0640': 
                case '\u064b': 
                case '\u064c': 
                case '\u064d': 
                case '\u064e': 
                case '\u064f': 
                case '\u0650': 
                case '\u0651': 
                case '\u0652': {
                    len = StemmerUtil.delete(s2, i, len);
                    --i;
                    continue block11;
                }
                default: {
                    if (Character.getType(s2[i]) != 16) continue block11;
                    len = StemmerUtil.delete(s2, i, len);
                    --i;
                }
            }
        }
        return len;
    }
}

