/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.similarities;

import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.similarities.BasicModel;
import org.apache.lucene.search.similarities.BasicStats;
import org.apache.lucene.search.similarities.SimilarityBase;

public class BasicModelG
extends BasicModel {
    @Override
    public final double score(BasicStats stats, double tfn, double aeTimes1pTfn) {
        double F = stats.getTotalTermFreq() + 1L;
        double N = stats.getNumberOfDocuments();
        double lambda = F / (N + F);
        double A2 = SimilarityBase.log2(lambda + 1.0);
        double B = SimilarityBase.log2((1.0 + lambda) / lambda);
        return (B - (B - A2) / (1.0 + tfn)) * aeTimes1pTfn;
    }

    @Override
    public Explanation explain(BasicStats stats, double tfn, double aeTimes1pTfn) {
        double F = stats.getTotalTermFreq() + 1L;
        double N = stats.getNumberOfDocuments();
        double lambda = F / (N + F);
        Explanation explLambda = Explanation.match((Number)Float.valueOf((float)lambda), "lambda, computed as F / (N + F) from:", Explanation.match((Number)Float.valueOf((float)F), "F, total number of occurrences of term across all docs + 1", new Explanation[0]), Explanation.match((Number)Float.valueOf((float)N), "N, total number of documents with field", new Explanation[0]));
        return Explanation.match((Number)Float.valueOf((float)(this.score(stats, tfn, aeTimes1pTfn) * (1.0 + tfn) / aeTimes1pTfn)), this.getClass().getSimpleName() + ", computed as log2(lambda + 1) + tfn * log2((1 + lambda) / lambda) from:", Explanation.match((Number)Float.valueOf((float)tfn), "tfn, normalized term frequency", new Explanation[0]), explLambda);
    }

    @Override
    public String toString() {
        return "G";
    }
}

