/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene86;

import java.util.Objects;
import org.apache.lucene.codecs.Codec;
import org.apache.lucene.codecs.CompoundFormat;
import org.apache.lucene.codecs.DocValuesFormat;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.LiveDocsFormat;
import org.apache.lucene.codecs.NormsFormat;
import org.apache.lucene.codecs.PointsFormat;
import org.apache.lucene.codecs.PostingsFormat;
import org.apache.lucene.codecs.SegmentInfoFormat;
import org.apache.lucene.codecs.StoredFieldsFormat;
import org.apache.lucene.codecs.TermVectorsFormat;
import org.apache.lucene.codecs.lucene50.Lucene50CompoundFormat;
import org.apache.lucene.codecs.lucene50.Lucene50LiveDocsFormat;
import org.apache.lucene.codecs.lucene50.Lucene50StoredFieldsFormat;
import org.apache.lucene.codecs.lucene50.Lucene50TermVectorsFormat;
import org.apache.lucene.codecs.lucene60.Lucene60FieldInfosFormat;
import org.apache.lucene.codecs.lucene80.Lucene80NormsFormat;
import org.apache.lucene.codecs.lucene84.Lucene84PostingsFormat;
import org.apache.lucene.codecs.lucene86.Lucene86PointsFormat;
import org.apache.lucene.codecs.lucene86.Lucene86SegmentInfoFormat;
import org.apache.lucene.codecs.perfield.PerFieldDocValuesFormat;
import org.apache.lucene.codecs.perfield.PerFieldPostingsFormat;

public class Lucene86Codec
extends Codec {
    private final TermVectorsFormat vectorsFormat = new Lucene50TermVectorsFormat();
    private final FieldInfosFormat fieldInfosFormat = new Lucene60FieldInfosFormat();
    private final SegmentInfoFormat segmentInfosFormat = new Lucene86SegmentInfoFormat();
    private final LiveDocsFormat liveDocsFormat = new Lucene50LiveDocsFormat();
    private final CompoundFormat compoundFormat = new Lucene50CompoundFormat();
    private final PointsFormat pointsFormat = new Lucene86PointsFormat();
    private final PostingsFormat defaultFormat;
    private final PostingsFormat postingsFormat = new PerFieldPostingsFormat(){

        @Override
        public PostingsFormat getPostingsFormatForField(String field) {
            return Lucene86Codec.this.getPostingsFormatForField(field);
        }
    };
    private final DocValuesFormat docValuesFormat = new PerFieldDocValuesFormat(){

        @Override
        public DocValuesFormat getDocValuesFormatForField(String field) {
            return Lucene86Codec.this.getDocValuesFormatForField(field);
        }
    };
    private final StoredFieldsFormat storedFieldsFormat;
    private final DocValuesFormat defaultDVFormat = DocValuesFormat.forName("Lucene80");
    private final NormsFormat normsFormat = new Lucene80NormsFormat();

    public Lucene86Codec() {
        this(Lucene50StoredFieldsFormat.Mode.BEST_SPEED);
    }

    public Lucene86Codec(Lucene50StoredFieldsFormat.Mode mode) {
        super("Lucene86");
        this.storedFieldsFormat = new Lucene50StoredFieldsFormat(Objects.requireNonNull(mode));
        this.defaultFormat = new Lucene84PostingsFormat();
    }

    @Override
    public StoredFieldsFormat storedFieldsFormat() {
        return this.storedFieldsFormat;
    }

    @Override
    public final TermVectorsFormat termVectorsFormat() {
        return this.vectorsFormat;
    }

    @Override
    public final PostingsFormat postingsFormat() {
        return this.postingsFormat;
    }

    @Override
    public final FieldInfosFormat fieldInfosFormat() {
        return this.fieldInfosFormat;
    }

    @Override
    public final SegmentInfoFormat segmentInfoFormat() {
        return this.segmentInfosFormat;
    }

    @Override
    public final LiveDocsFormat liveDocsFormat() {
        return this.liveDocsFormat;
    }

    @Override
    public final CompoundFormat compoundFormat() {
        return this.compoundFormat;
    }

    @Override
    public final PointsFormat pointsFormat() {
        return this.pointsFormat;
    }

    public PostingsFormat getPostingsFormatForField(String field) {
        return this.defaultFormat;
    }

    public DocValuesFormat getDocValuesFormatForField(String field) {
        return this.defaultDVFormat;
    }

    @Override
    public final DocValuesFormat docValuesFormat() {
        return this.docValuesFormat;
    }

    @Override
    public final NormsFormat normsFormat() {
        return this.normsFormat;
    }
}

