/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.AnalyzerWrapper;
import org.apache.lucene.analysis.util.CharTokenizer;
import org.apache.maven.index.creator.JarFileContentsIndexCreator;

public final class NexusAnalyzer
extends AnalyzerWrapper {
    private static final Analyzer CLASS_NAMES_ANALYZER = new Analyzer(){

        @Override
        protected Analyzer.TokenStreamComponents createComponents(String fieldName) {
            return new Analyzer.TokenStreamComponents(new DeprecatedClassnamesTokenizer());
        }
    };
    private static final Analyzer LETTER_OR_DIGIT_ANALYZER = new Analyzer(){

        @Override
        protected Analyzer.TokenStreamComponents createComponents(String filedName) {
            return new Analyzer.TokenStreamComponents(new LetterOrDigitTokenizer());
        }
    };

    public NexusAnalyzer() {
        super(PER_FIELD_REUSE_STRATEGY);
    }

    @Override
    protected Analyzer getWrappedAnalyzer(String fieldName) {
        if (JarFileContentsIndexCreator.FLD_CLASSNAMES_KW.getKey().equals(fieldName)) {
            return CLASS_NAMES_ANALYZER;
        }
        return LETTER_OR_DIGIT_ANALYZER;
    }

    public static class LetterOrDigitTokenizer
    extends CharTokenizer {
        @Override
        protected boolean isTokenChar(int c) {
            return Character.isLetterOrDigit(c);
        }

        @Override
        protected int normalize(int c) {
            return Character.toLowerCase(c);
        }
    }

    @Deprecated
    public static class DeprecatedClassnamesTokenizer
    extends CharTokenizer {
        @Override
        protected boolean isTokenChar(int i) {
            return i != 10;
        }

        @Override
        protected int normalize(int c) {
            return Character.toLowerCase(c);
        }
    }

    public static class NoopTokenizer
    extends CharTokenizer {
        @Override
        protected boolean isTokenChar(int i) {
            return true;
        }
    }
}

