/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.context;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.NoSuchFileException;
import java.util.Date;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.codehaus.plexus.util.FileUtils;

public class IndexUtils {
    public static final String TIMESTAMP_FILE = "timestamp";
    private static final int BUFFER_SIZE = 16384;

    public static void copyDirectory(Directory source, Directory target) throws IOException {
        for (String file : source.listAll()) {
            target.copyFrom(source, file, file, IOContext.DEFAULT);
        }
        IndexUtils.copyFile(source, target, "nexus-maven-repository-index-updater.properties");
        IndexUtils.copyFile(source, target, "nexus-maven-repository-index-packer.properties");
        Date ts = IndexUtils.getTimestamp(source);
        IndexUtils.updateTimestamp(target, ts);
    }

    public static boolean copyFile(Directory source, Directory target, String name) throws IOException {
        return IndexUtils.copyFile(source, target, name, name);
    }

    public static boolean copyFile(Directory source, Directory target, String srcName, String targetName) throws IOException {
        try {
            source.fileLength(srcName);
        }
        catch (FileNotFoundException | NoSuchFileException e) {
            return false;
        }
        target.copyFrom(source, srcName, targetName, IOContext.DEFAULT);
        return true;
    }

    public static ArtifactInfo constructArtifactInfo(Document doc, IndexingContext context) {
        if (doc.get(ArtifactInfo.UINFO) == null) {
            return null;
        }
        boolean res = false;
        ArtifactInfo artifactInfo = new ArtifactInfo();
        try {
            artifactInfo.setRepository(context.getRepositoryId());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
        try {
            artifactInfo.setContext(context.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        for (IndexCreator ic : context.getIndexCreators()) {
            res |= ic.updateArtifactInfo(doc, artifactInfo);
        }
        return res ? artifactInfo : null;
    }

    public static Document updateDocument(Document doc, IndexingContext context) {
        return IndexUtils.updateDocument(doc, context, true);
    }

    public static Document updateDocument(Document doc, IndexingContext context, boolean updateLastModified) {
        return IndexUtils.updateDocument(doc, context, updateLastModified, null);
    }

    public static Document updateDocument(Document doc, IndexingContext context, boolean updateLastModified, ArtifactInfo ai) {
        if (ai == null && (ai = IndexUtils.constructArtifactInfo(doc, context)) == null) {
            return doc;
        }
        Document document = new Document();
        document.add(new Field(ArtifactInfo.UINFO, ai.getUinfo(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        if (updateLastModified || doc.getField(ArtifactInfo.LAST_MODIFIED) == null) {
            document.add(new Field(ArtifactInfo.LAST_MODIFIED, Long.toString(System.currentTimeMillis()), Field.Store.YES, Field.Index.NO));
        } else {
            document.add(doc.getField(ArtifactInfo.LAST_MODIFIED));
        }
        for (IndexCreator ic : context.getIndexCreators()) {
            ic.updateDocument(ai, document);
        }
        return document;
    }

    public static void deleteTimestamp(Directory directory) throws IOException {
        try {
            directory.deleteFile(TIMESTAMP_FILE);
        }
        catch (FileNotFoundException | NoSuchFileException iOException) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void updateTimestamp(Directory directory, Date timestamp) throws IOException {
        Directory directory2 = directory;
        synchronized (directory2) {
            Date currentTimestamp = IndexUtils.getTimestamp(directory);
            if (!(timestamp == null || currentTimestamp != null && currentTimestamp.equals(timestamp))) {
                IndexUtils.deleteTimestamp(directory);
                IndexOutput io = directory.createOutput(TIMESTAMP_FILE, IOContext.DEFAULT);
                try {
                    io.writeLong(timestamp.getTime());
                }
                finally {
                    IndexUtils.close(io);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Date getTimestamp(Directory directory) {
        Directory directory2 = directory;
        synchronized (directory2) {
            Date result = null;
            try (IndexInput ii = directory.openInput(TIMESTAMP_FILE, IOContext.DEFAULT);){
                result = new Date(ii.readLong());
            }
            catch (FileNotFoundException | NoSuchFileException iOException) {
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return result;
        }
    }

    public static void close(OutputStream os) {
        if (os != null) {
            try {
                os.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(InputStream is) {
        if (is != null) {
            try {
                is.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(IndexOutput io) {
        if (io != null) {
            try {
                io.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(IndexInput in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(IndexReader r) {
        if (r != null) {
            try {
                r.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(IndexWriter w) {
        if (w != null) {
            try {
                w.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void close(Directory d) {
        if (d != null) {
            try {
                d.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static void delete(File indexDir) {
        try {
            FileUtils.deleteDirectory(indexDir);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

