/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.join;

import java.io.IOException;
import java.util.Locale;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.MultiDocValues;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MatchNoDocsQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.join.DocValuesTermsCollector;
import org.apache.lucene.search.join.GenericTermsCollector;
import org.apache.lucene.search.join.GenericTermsCollectorFactory;
import org.apache.lucene.search.join.GlobalOrdinalsCollector;
import org.apache.lucene.search.join.GlobalOrdinalsQuery;
import org.apache.lucene.search.join.GlobalOrdinalsWithScoreCollector;
import org.apache.lucene.search.join.GlobalOrdinalsWithScoreQuery;
import org.apache.lucene.search.join.ScoreMode;
import org.apache.lucene.search.join.TermsIncludingScoreQuery;
import org.apache.lucene.search.join.TermsQuery;

public final class JoinUtil {
    private JoinUtil() {
    }

    public static Query createJoinQuery(String fromField, boolean multipleValuesPerDocument, String toField, Query fromQuery, IndexSearcher fromSearcher, ScoreMode scoreMode) throws IOException {
        GenericTermsCollector termsWithScoreCollector;
        if (multipleValuesPerDocument) {
            DocValuesTermsCollector.Function<SortedSetDocValues> mvFunction = DocValuesTermsCollector.sortedSetDocValues(fromField);
            termsWithScoreCollector = GenericTermsCollectorFactory.createCollectorMV(mvFunction, scoreMode);
        } else {
            DocValuesTermsCollector.Function<BinaryDocValues> svFunction = DocValuesTermsCollector.binaryDocValues(fromField);
            termsWithScoreCollector = GenericTermsCollectorFactory.createCollectorSV(svFunction, scoreMode);
        }
        return JoinUtil.createJoinQuery(multipleValuesPerDocument, toField, fromQuery, fromSearcher, scoreMode, termsWithScoreCollector);
    }

    public static Query createJoinQuery(String fromField, boolean multipleValuesPerDocument, String toField, FieldType.NumericType numericType, Query fromQuery, IndexSearcher fromSearcher, ScoreMode scoreMode) throws IOException {
        GenericTermsCollector termsCollector;
        if (multipleValuesPerDocument) {
            DocValuesTermsCollector.Function<SortedSetDocValues> mvFunction = DocValuesTermsCollector.sortedNumericAsSortedSetDocValues(fromField, numericType);
            termsCollector = GenericTermsCollectorFactory.createCollectorMV(mvFunction, scoreMode);
        } else {
            DocValuesTermsCollector.Function<BinaryDocValues> svFunction = DocValuesTermsCollector.numericAsBinaryDocValues(fromField, numericType);
            termsCollector = GenericTermsCollectorFactory.createCollectorSV(svFunction, scoreMode);
        }
        return JoinUtil.createJoinQuery(multipleValuesPerDocument, toField, fromQuery, fromSearcher, scoreMode, termsCollector);
    }

    private static Query createJoinQuery(boolean multipleValuesPerDocument, String toField, Query fromQuery, IndexSearcher fromSearcher, ScoreMode scoreMode, GenericTermsCollector collector) throws IOException {
        fromSearcher.search(fromQuery, collector);
        switch (scoreMode) {
            case None: {
                return new TermsQuery(toField, fromQuery, collector.getCollectedTerms());
            }
            case Total: 
            case Max: 
            case Min: 
            case Avg: {
                return new TermsIncludingScoreQuery(toField, multipleValuesPerDocument, collector.getCollectedTerms(), collector.getScoresPerTerm(), fromQuery);
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Score mode %s isn't supported.", new Object[]{scoreMode}));
    }

    public static Query createJoinQuery(String joinField, Query fromQuery, Query toQuery, IndexSearcher searcher, ScoreMode scoreMode, MultiDocValues.OrdinalMap ordinalMap) throws IOException {
        return JoinUtil.createJoinQuery(joinField, fromQuery, toQuery, searcher, scoreMode, ordinalMap, 0, Integer.MAX_VALUE);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Query createJoinQuery(String joinField, Query fromQuery, Query toQuery, IndexSearcher searcher, ScoreMode scoreMode, MultiDocValues.OrdinalMap ordinalMap, int min, int max) throws IOException {
        void var14_18;
        long valueCount;
        IndexReader indexReader = searcher.getIndexReader();
        int numSegments = indexReader.leaves().size();
        if (numSegments == 0) {
            return new MatchNoDocsQuery();
        }
        if (numSegments == 1) {
            ordinalMap = null;
            LeafReader leafReader = searcher.getIndexReader().leaves().get(0).reader();
            SortedDocValues joinSortedDocValues = leafReader.getSortedDocValues(joinField);
            if (joinSortedDocValues == null) return new MatchNoDocsQuery();
            valueCount = joinSortedDocValues.getValueCount();
        } else {
            if (ordinalMap == null) {
                throw new IllegalArgumentException("OrdinalMap is required, because there is more than 1 segment");
            }
            valueCount = ordinalMap.getValueCount();
        }
        Query rewrittenFromQuery = searcher.rewrite(fromQuery);
        Query rewrittenToQuery = searcher.rewrite(toQuery);
        switch (scoreMode) {
            case Total: {
                GlobalOrdinalsWithScoreCollector.Sum sum = new GlobalOrdinalsWithScoreCollector.Sum(joinField, ordinalMap, valueCount, min, max);
                break;
            }
            case Min: {
                GlobalOrdinalsWithScoreCollector.Min min2 = new GlobalOrdinalsWithScoreCollector.Min(joinField, ordinalMap, valueCount, min, max);
                break;
            }
            case Max: {
                GlobalOrdinalsWithScoreCollector.Max max2 = new GlobalOrdinalsWithScoreCollector.Max(joinField, ordinalMap, valueCount, min, max);
                break;
            }
            case Avg: {
                GlobalOrdinalsWithScoreCollector.Avg avg = new GlobalOrdinalsWithScoreCollector.Avg(joinField, ordinalMap, valueCount, min, max);
                break;
            }
            case None: {
                if (min <= 0 && max == Integer.MAX_VALUE) {
                    GlobalOrdinalsCollector globalOrdinalsCollector = new GlobalOrdinalsCollector(joinField, ordinalMap, valueCount);
                    searcher.search(rewrittenFromQuery, globalOrdinalsCollector);
                    return new GlobalOrdinalsQuery(globalOrdinalsCollector.getCollectorOrdinals(), joinField, ordinalMap, rewrittenToQuery, rewrittenFromQuery, indexReader);
                }
                GlobalOrdinalsWithScoreCollector.NoScore noScore = new GlobalOrdinalsWithScoreCollector.NoScore(joinField, ordinalMap, valueCount, min, max);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "Score mode %s isn't supported.", new Object[]{scoreMode}));
            }
        }
        searcher.search(rewrittenFromQuery, (Collector)var14_18);
        return new GlobalOrdinalsWithScoreQuery((GlobalOrdinalsWithScoreCollector)var14_18, joinField, ordinalMap, rewrittenToQuery, rewrittenFromQuery, min, max, indexReader);
    }
}

