/*
 * Decompiled with CFR 0.152.
 */
package org.sonatype.guice.bean.locators;

import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class RankedList<T>
extends AbstractCollection<T>
implements List<T>,
RandomAccess,
Cloneable {
    private static final int INITIAL_CAPACITY = 10;
    Object[] objs;
    long[] uids;
    volatile int size;
    volatile int uniq;
    boolean isCached;

    RankedList() {
    }

    public void insert(T element, int rank) {
        if (null == this.objs) {
            this.objs = new Object[10];
            this.uids = new long[10];
        } else if (this.size >= this.objs.length) {
            int capacity = this.size * 3 / 2 + 1;
            Object[] newObjs = new Object[capacity];
            System.arraycopy(this.objs, 0, newObjs, 0, this.size);
            long[] newUIDs = new long[capacity];
            System.arraycopy(this.uids, 0, newUIDs, 0, this.size);
            this.objs = newObjs;
            this.uids = newUIDs;
            this.isCached = false;
        } else if (this.isCached) {
            this.objs = (Object[])this.objs.clone();
            this.uids = (long[])this.uids.clone();
            this.isCached = false;
        }
        long uid = RankedList.rank2uid(rank, this.uniq++);
        int index = this.safeBinarySearch(uid);
        int to = index + 1;
        int len = this.size - index;
        if (len > 0) {
            System.arraycopy(this.objs, index, this.objs, to, len);
            System.arraycopy(this.uids, index, this.uids, to, len);
        }
        ++this.size;
        this.objs[index] = element;
        this.uids[index] = uid;
    }

    @Override
    public T remove(int index) {
        int from;
        int len;
        T element = this.get(index);
        if (this.isCached) {
            this.objs = (Object[])this.objs.clone();
            this.uids = (long[])this.uids.clone();
            this.isCached = false;
        }
        if ((len = this.size - (from = index + 1)) > 0) {
            System.arraycopy(this.objs, from, this.objs, index, len);
            System.arraycopy(this.uids, from, this.uids, index, len);
        }
        this.objs[--this.size] = null;
        return element;
    }

    @Override
    public int indexOf(Object o) {
        for (int i = 0; i < this.size; ++i) {
            if (!o.equals(this.objs[i])) continue;
            return i;
        }
        return -1;
    }

    public int indexOfThis(T element) {
        for (int i = 0; i < this.size; ++i) {
            if (element != this.objs[i]) continue;
            return i;
        }
        return -1;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean remove(Object o) {
        int index = this.indexOf(o);
        if (index >= 0) {
            this.remove(index);
            return true;
        }
        return false;
    }

    @Override
    public T get(int index) {
        if (index < this.size) {
            return (T)this.objs[index];
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
    }

    public int getRank(int index) {
        if (index < this.size) {
            return RankedList.uid2rank(this.uids[index]);
        }
        throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this.size);
    }

    public RankedList<T> clone() {
        try {
            RankedList clone = (RankedList)super.clone();
            if (null != this.objs) {
                clone.objs = (Object[])this.objs.clone();
                clone.uids = (long[])this.uids.clone();
            }
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new InternalError();
        }
    }

    @Override
    public void clear() {
        this.objs = null;
        this.uids = null;
        this.size = 0;
        this.uniq = 0;
        this.isCached = false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    public Itr iterator() {
        return new Itr();
    }

    private static long rank2uid(int rank, int uniq) {
        return (long)(~rank) << 32 | 0xFFFFFFFFL & (long)uniq;
    }

    static int uid2rank(long uid) {
        return (int)((uid ^ 0xFFFFFFFFFFFFFFFFL) >>> 32);
    }

    int safeBinarySearch(long uid) {
        int min = 0;
        int max = this.size - 1;
        while (min < max) {
            int m = min + max >>> 1;
            if (uid <= this.uids[m]) {
                max = m;
                continue;
            }
            min = m + 1;
        }
        if (min == this.size - 1 && this.uids[min] < uid) {
            return this.size;
        }
        return min;
    }

    @Override
    @Deprecated
    public void add(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public boolean addAll(int index, Collection<? extends T> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public T set(int index, T element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public int lastIndexOf(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ListIterator<T> listIterator() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ListIterator<T> listIterator(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public List<T> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class Itr
    implements Iterator<T> {
        private Object[] cachedObjs;
        private long[] cachedUIDs;
        private int expectedSize;
        private int expectedUniq;
        private long nextUID = Long.MIN_VALUE;
        private T nextObj;
        private int index;

        Itr() {
        }

        @Override
        public boolean hasNext() {
            if (null != this.nextObj) {
                return true;
            }
            if (this.safeHasNext()) {
                this.nextObj = this.cachedObjs[this.index];
                this.nextUID = this.cachedUIDs[this.index];
                return true;
            }
            return false;
        }

        public int peekNextRank() {
            if (null != this.nextObj) {
                return RankedList.uid2rank(this.nextUID);
            }
            if (this.safeHasNext()) {
                return RankedList.uid2rank(this.cachedUIDs[this.index]);
            }
            return Integer.MIN_VALUE;
        }

        @Override
        public T next() {
            if (this.hasNext()) {
                ++this.nextUID;
                ++this.index;
                Object element = this.nextObj;
                this.nextObj = null;
                return element;
            }
            throw new NoSuchElementException();
        }

        public int rank() {
            return RankedList.uid2rank(this.nextUID);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean safeHasNext() {
            if (this.expectedSize != RankedList.this.size || this.expectedUniq != RankedList.this.uniq) {
                RankedList rankedList = RankedList.this;
                synchronized (rankedList) {
                    this.index = RankedList.this.safeBinarySearch(this.nextUID);
                    if (this.index < RankedList.this.size) {
                        this.cachedObjs = RankedList.this.objs;
                        this.cachedUIDs = RankedList.this.uids;
                        RankedList.this.isCached = true;
                    }
                    this.expectedSize = RankedList.this.size;
                    this.expectedUniq = RankedList.this.uniq;
                }
            }
            return this.index < this.expectedSize;
        }
    }
}

