/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index.cli;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.lucene.store.FSDirectory;
import org.apache.maven.index.ArtifactContext;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.ArtifactScanningListener;
import org.apache.maven.index.NexusIndexer;
import org.apache.maven.index.ScanningResult;
import org.apache.maven.index.cli.PartialImplementation;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.context.UnsupportedExistingLuceneIndexException;
import org.apache.maven.index.packer.IndexPacker;
import org.apache.maven.index.packer.IndexPackingRequest;
import org.apache.maven.index.updater.DefaultIndexUpdater;
import org.codehaus.plexus.PlexusContainer;
import org.codehaus.plexus.classworlds.ClassWorld;
import org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.codehaus.plexus.logging.LoggerManager;
import org.codehaus.plexus.tools.cli.AbstractCli;
import org.codehaus.plexus.util.IOUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NexusIndexerCli
extends AbstractCli {
    public static final char REPO = 'r';
    public static final char INDEX = 'i';
    public static final char NAME = 'n';
    public static final char TYPE = 't';
    public static final char TARGET_DIR = 'd';
    public static final char CREATE_INCREMENTAL_CHUNKS = 'c';
    public static final char CREATE_FILE_CHECKSUMS = 's';
    public static final char INCREMENTAL_CHUNK_KEEP_COUNT = 'k';
    public static final char LEGACY = 'l';
    public static final char UNPACK = 'u';
    private static final long MB = 0x100000L;
    private Options options;
    private int status = 0;

    public static void main(String[] args) throws Exception {
        NexusIndexerCli cli = new NexusIndexerCli();
        cli.execute(args);
        System.exit(cli.status);
    }

    @Override
    public int execute(String[] arg0, ClassWorld arg1) {
        int value = super.execute(arg0, arg1);
        if (this.status == 0) {
            this.status = value;
        }
        return this.status;
    }

    @Override
    public int execute(String[] args) {
        int value = super.execute(args);
        if (this.status == 0) {
            this.status = value;
        }
        return this.status;
    }

    @Override
    protected void showError(String message, Exception e, boolean show) {
        this.status = 1;
        super.showError(message, e, show);
    }

    @Override
    protected int showFatalError(String message, Exception e, boolean show) {
        this.status = 1;
        return super.showFatalError(message, e, show);
    }

    @Override
    public CommandLine parse(String[] args) throws ParseException {
        try {
            return super.parse(args);
        }
        catch (ParseException e) {
            this.status = 1;
            throw e;
        }
    }

    @Override
    public String getPomPropertiesPath() {
        return "META-INF/maven/org.sonatype.nexus/nexus-indexer/pom.properties";
    }

    @Override
    public Options buildCliOptions(Options options) {
        this.options = options;
        OptionBuilder.withLongOpt("index");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Path to the index folder.");
        options.addOption(OptionBuilder.create('i'));
        OptionBuilder.withLongOpt("destination");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Target folder.");
        options.addOption(OptionBuilder.create('d'));
        OptionBuilder.withLongOpt("repository");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Path to the Maven repository.");
        options.addOption(OptionBuilder.create('r'));
        OptionBuilder.withLongOpt("name");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Repository name.");
        options.addOption(OptionBuilder.create('n'));
        OptionBuilder.withLongOpt("chunks");
        OptionBuilder.withDescription("Create incremental chunks.");
        options.addOption(OptionBuilder.create('c'));
        OptionBuilder.withLongOpt("keep");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Number of incremental chunks to keep.");
        options.addOption(OptionBuilder.create('k'));
        OptionBuilder.withLongOpt("checksums");
        OptionBuilder.withDescription("Create checksums for all files (sha1, md5).");
        options.addOption(OptionBuilder.create('s'));
        OptionBuilder.withLongOpt("type");
        OptionBuilder.hasArg();
        OptionBuilder.withDescription("Indexer type (default, min, full or coma separated list of custom types).");
        options.addOption(OptionBuilder.create('t'));
        OptionBuilder.withLongOpt("legacy");
        OptionBuilder.withDescription("Build legacy .zip index file");
        options.addOption(OptionBuilder.create('l'));
        OptionBuilder.withLongOpt("unpack");
        OptionBuilder.withDescription("Unpack an index file");
        options.addOption(OptionBuilder.create('u'));
        return options;
    }

    @Override
    public void displayHelp() {
        System.out.println();
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("nexus-indexer [options]", "\nOptions:", this.options, "\n");
    }

    public void displayHelp(String message) {
        System.out.println();
        System.out.println(message);
        System.out.println();
        this.displayHelp();
    }

    @Override
    public void invokePlexusComponent(CommandLine cli, PlexusContainer plexus) throws Exception {
        if (cli.hasOption('q')) {
            this.setLogLevel(plexus, 5);
        } else if (cli.hasOption('X')) {
            this.setLogLevel(plexus, 0);
        } else if (cli.hasOption('e')) {
            this.setLogLevel(plexus, 3);
        }
        if (cli.hasOption('u')) {
            this.unpack(cli, plexus);
        } else if (cli.hasOption('i') && cli.hasOption('r')) {
            this.index(cli, plexus);
        } else {
            this.status = 1;
            this.displayHelp("Use either unpack (\"u\") or index (\"i\" and \"r\") options, but none has been found!");
        }
    }

    private void setLogLevel(PlexusContainer plexus, int logLevel) throws ComponentLookupException {
        plexus.lookup(LoggerManager.class).setThresholds(logLevel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void index(CommandLine cli, PlexusContainer plexus) throws ComponentLookupException, IOException, UnsupportedExistingLuceneIndexException {
        Integer chunkCount;
        String indexDirectoryName = cli.getOptionValue('i');
        File indexFolder = new File(indexDirectoryName);
        String outputDirectoryName = cli.getOptionValue('d', ".");
        File outputFolder = new File(outputDirectoryName);
        File repositoryFolder = new File(cli.getOptionValue('r'));
        String repositoryName = cli.getOptionValue('n', indexFolder.getName());
        List<IndexCreator> indexers = this.getIndexers(cli, plexus);
        boolean createChecksums = cli.hasOption('s');
        boolean createIncrementalChunks = cli.hasOption('c');
        boolean createLegacyIndex = cli.hasOption('l');
        boolean debug = cli.hasOption('X');
        boolean quiet = cli.hasOption('q');
        Integer n = chunkCount = cli.hasOption('k') ? Integer.valueOf(Integer.parseInt(cli.getOptionValue('k'))) : null;
        if (!quiet) {
            System.err.printf("Repository Folder: %s\n", repositoryFolder.getAbsolutePath());
            System.err.printf("Index Folder:      %s\n", indexFolder.getAbsolutePath());
            System.err.printf("Output Folder:     %s\n", outputFolder.getAbsolutePath());
            System.err.printf("Repository name:   %s\n", repositoryName);
            System.err.printf("Indexers: %s\n", indexers.toString());
            if (createChecksums) {
                System.err.printf("Will create checksum files for all published files (sha1, md5).\n", new Object[0]);
            } else {
                System.err.printf("Will not create checksum files.\n", new Object[0]);
            }
            if (createIncrementalChunks) {
                System.err.printf("Will create incremental chunks for changes, along with baseline file.\n", new Object[0]);
            } else {
                System.err.printf("Will create baseline file.\n", new Object[0]);
            }
            if (createLegacyIndex) {
                System.err.printf("Will also create legacy .zip index file.\n", new Object[0]);
            }
        }
        NexusIndexer indexer = plexus.lookup(NexusIndexer.class);
        long tstart = System.currentTimeMillis();
        IndexingContext context = indexer.addIndexingContext(repositoryName, repositoryName, repositoryFolder, indexFolder, null, null, indexers);
        try {
            IndexPacker packer = plexus.lookup(IndexPacker.class);
            IndexerListener listener = new IndexerListener(context, debug, quiet);
            indexer.scan(context, listener, true);
            IndexPackingRequest request = new IndexPackingRequest(context, outputFolder);
            request.setCreateChecksumFiles(createChecksums);
            request.setCreateIncrementalChunks(createIncrementalChunks);
            if (createLegacyIndex) {
                request.setFormats(Arrays.asList(IndexPackingRequest.IndexFormat.FORMAT_LEGACY, IndexPackingRequest.IndexFormat.FORMAT_V1));
            } else {
                request.setFormats(Arrays.asList(IndexPackingRequest.IndexFormat.FORMAT_V1));
            }
            if (chunkCount != null) {
                request.setMaxIndexChunks(chunkCount);
            }
            this.packIndex(packer, request, debug, quiet);
            if (!quiet) {
                this.printStats(tstart);
            }
        }
        finally {
            indexer.removeIndexingContext(context, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unpack(CommandLine cli, PlexusContainer plexus) throws ComponentLookupException, IOException {
        String indexDirectoryName = cli.getOptionValue('i', ".");
        File indexFolder = new File(indexDirectoryName).getCanonicalFile();
        File indexArchive = new File(indexFolder, "nexus-maven-repository-index.gz");
        String outputDirectoryName = cli.getOptionValue('d', ".");
        File outputFolder = new File(outputDirectoryName).getCanonicalFile();
        boolean quiet = cli.hasOption('q');
        if (!quiet) {
            System.err.printf("Index Folder:      %s\n", indexFolder.getAbsolutePath());
            System.err.printf("Output Folder:     %s\n", outputFolder.getAbsolutePath());
        }
        long tstart = System.currentTimeMillis();
        FSDirectory directory = FSDirectory.open(outputFolder);
        final List<IndexCreator> indexers = this.getIndexers(cli, plexus);
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(indexArchive));
            DefaultIndexUpdater.unpackIndexData(is, directory, (IndexingContext)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{IndexingContext.class}, (InvocationHandler)new PartialImplementation(){

                public List<IndexCreator> getIndexCreators() {
                    return indexers;
                }
            }));
        }
        catch (Throwable throwable) {
            IOUtil.close(is);
            if (directory != null) {
                directory.close();
            }
            throw throwable;
        }
        IOUtil.close(is);
        if (directory != null) {
            directory.close();
        }
        if (!quiet) {
            this.printStats(tstart);
        }
    }

    private List<IndexCreator> getIndexers(CommandLine cli, PlexusContainer plexus) throws ComponentLookupException {
        String type = "default";
        if (cli.hasOption('t')) {
            type = cli.getOptionValue('t');
        }
        ArrayList<IndexCreator> indexers = new ArrayList<IndexCreator>();
        if ("default".equals(type)) {
            indexers.add(plexus.lookup(IndexCreator.class, "min"));
            indexers.add(plexus.lookup(IndexCreator.class, "jarContent"));
        } else if ("full".equals(type)) {
            for (IndexCreator component : plexus.lookupList(IndexCreator.class)) {
                indexers.add(component);
            }
        } else {
            for (String hint : type.split(",")) {
                indexers.add(plexus.lookup(IndexCreator.class, hint));
            }
        }
        return indexers;
    }

    private void packIndex(IndexPacker packer, IndexPackingRequest request, boolean debug, boolean quiet) {
        block2: {
            try {
                packer.packIndex(request);
            }
            catch (IOException e) {
                if (quiet) break block2;
                System.err.printf("Cannot zip index; \n", e.getMessage());
                if (!debug) break block2;
                e.printStackTrace();
            }
        }
    }

    private void printStats(long startTimeInMillis) {
        long t = System.currentTimeMillis() - startTimeInMillis;
        long s = t / 1000L;
        if (t > 60000L) {
            long m = t / 1000L / 60L;
            System.err.printf("Total time:   %d min %d sec\n", m, s - m * 60L);
        } else {
            System.err.printf("Total time:   %d sec\n", s);
        }
        Runtime r = Runtime.getRuntime();
        System.err.printf("Final memory: %dM/%dM\n", (r.totalMemory() - r.freeMemory()) / 0x100000L, r.totalMemory() / 0x100000L);
    }

    private static final class IndexerListener
    implements ArtifactScanningListener {
        private final IndexingContext context;
        private final boolean debug;
        private boolean quiet;
        private long ts = System.currentTimeMillis();
        private int count;

        IndexerListener(IndexingContext context, boolean debug, boolean quiet) {
            this.context = context;
            this.debug = debug;
            this.quiet = quiet;
        }

        public void scanningStarted(IndexingContext context) {
            if (!this.quiet) {
                System.err.println("Scanning started");
            }
        }

        public void artifactDiscovered(ArtifactContext ac) {
            ++this.count;
            long t = System.currentTimeMillis();
            ArtifactInfo ai = ac.getArtifactInfo();
            if (!this.quiet && this.debug && "maven-plugin".equals(ai.packaging)) {
                System.err.printf("Plugin: %s:%s:%s - %s %s\n", ai.groupId, ai.artifactId, ai.version, ai.prefix, "" + ai.goals);
            }
            if (!this.quiet && (this.debug || t - this.ts > 2000L)) {
                System.err.printf("  %6d %s\n", this.count, this.formatFile(ac.getPom()));
                this.ts = t;
            }
        }

        public void artifactError(ArtifactContext ac, Exception e) {
            if (!this.quiet) {
                System.err.printf("! %6d %s - %s\n", this.count, this.formatFile(ac.getPom()), e.getMessage());
                System.err.printf("         %s\n", this.formatFile(ac.getArtifact()));
                if (this.debug) {
                    e.printStackTrace();
                }
            }
            this.ts = System.currentTimeMillis();
        }

        private String formatFile(File file) {
            return file.getAbsolutePath().substring(this.context.getRepository().getAbsolutePath().length() + 1);
        }

        public void scanningFinished(IndexingContext context, ScanningResult result) {
            if (!this.quiet) {
                if (result.hasExceptions()) {
                    System.err.printf("Scanning errors:   %s\n", result.getExceptions().size());
                }
                System.err.printf("Artifacts added:   %s\n", result.getTotalFiles());
                System.err.printf("Artifacts deleted: %s\n", result.getDeletedFiles());
            }
        }
    }
}

