/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.index;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.maven.index.ArtifactInfo;
import org.apache.maven.index.artifact.Gav;
import org.apache.maven.index.context.IndexCreator;
import org.apache.maven.index.context.IndexingContext;
import org.apache.maven.index.util.zip.ZipFacade;
import org.apache.maven.index.util.zip.ZipHandle;
import org.apache.maven.model.Model;
import org.codehaus.plexus.util.xml.Xpp3Dom;
import org.codehaus.plexus.util.xml.Xpp3DomBuilder;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ArtifactContext {
    private final File pom;
    private final File artifact;
    private final File metadata;
    private final ArtifactInfo artifactInfo;
    private final Gav gav;
    private final List<Exception> errors = new ArrayList<Exception>();

    public ArtifactContext(File pom, File artifact, File metadata, ArtifactInfo artifactInfo, Gav gav) throws IllegalArgumentException {
        if (artifactInfo == null) {
            throw new IllegalArgumentException("Parameter artifactInfo must not be null.");
        }
        this.pom = pom;
        this.artifact = artifact;
        this.metadata = metadata;
        this.artifactInfo = artifactInfo;
        this.gav = gav == null ? artifactInfo.calculateGav() : gav;
    }

    public File getPom() {
        return this.pom;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Model getPomModel() {
        block18: {
            if (this.getPom() != null && this.getPom().exists()) {
                try {
                    return new ModelReader().readModel(new FileInputStream(this.getPom()));
                }
                catch (FileNotFoundException e) {
                    break block18;
                }
            }
            if (this.getArtifact() != null) {
                ZipHandle handle = null;
                try {
                    handle = ZipFacade.getZipHandle(this.getArtifact());
                    String embeddedPomPath = "META-INF/maven/" + this.getGav().getGroupId() + "/" + this.getGav().getArtifactId() + "/pom.xml";
                    if (handle.hasEntry(embeddedPomPath)) {
                        Model model = new ModelReader().readModel(handle.getEntryContent(embeddedPomPath));
                        return model;
                    }
                }
                catch (IOException e) {
                }
                finally {
                    try {
                        ZipFacade.close(handle);
                    }
                    catch (Exception e) {}
                }
            }
        }
        return null;
    }

    public File getArtifact() {
        return this.artifact;
    }

    public File getMetadata() {
        return this.metadata;
    }

    public ArtifactInfo getArtifactInfo() {
        return this.artifactInfo;
    }

    public Gav getGav() {
        return this.gav;
    }

    public List<Exception> getErrors() {
        return this.errors;
    }

    public void addError(Exception e) {
        this.errors.add(e);
    }

    public Document createDocument(IndexingContext context) {
        Document doc = new Document();
        doc.add(new Field(ArtifactInfo.UINFO, this.getArtifactInfo().getUinfo(), Field.Store.YES, Field.Index.NOT_ANALYZED));
        doc.add(new Field(ArtifactInfo.LAST_MODIFIED, Long.toString(System.currentTimeMillis()), Field.Store.YES, Field.Index.NO));
        for (IndexCreator indexCreator : context.getIndexCreators()) {
            try {
                indexCreator.populateArtifactInfo(this);
            }
            catch (IOException ex) {
                this.addError(ex);
            }
        }
        for (IndexCreator indexCreator : context.getIndexCreators()) {
            indexCreator.updateDocument(this.getArtifactInfo(), doc);
        }
        return doc;
    }

    public static class ModelReader {
        public Model readModel(InputStream pom) {
            if (pom == null) {
                return null;
            }
            Model model = new Model();
            Xpp3Dom dom = this.readPomInputStream(pom);
            if (dom == null) {
                return null;
            }
            if (dom.getChild("packaging") != null) {
                model.setPackaging(dom.getChild("packaging").getValue());
            } else {
                model.setPackaging(null);
            }
            if (dom.getChild("name") != null) {
                model.setName(dom.getChild("name").getValue());
            }
            if (dom.getChild("description") != null) {
                model.setDescription(dom.getChild("description").getValue());
            }
            return model;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private Xpp3Dom readPomInputStream(InputStream is) {
            InputStreamReader r = new InputStreamReader(is);
            try {
                Xpp3Dom xpp3Dom = Xpp3DomBuilder.build(r);
                return xpp3Dom;
            }
            catch (XmlPullParserException e) {
            }
            catch (IOException e) {
            }
            finally {
                try {
                    ((Reader)r).close();
                }
                catch (IOException e) {}
            }
            return null;
        }
    }
}

