/*
 * Decompiled with CFR 0.152.
 */
package de.schlichtherle.truezip.fs;

import de.schlichtherle.truezip.fs.FsDecoratingModel;
import de.schlichtherle.truezip.fs.FsModel;
import de.schlichtherle.truezip.fs.FsNeedsWriteLockException;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
final class FsLockModel
extends FsDecoratingModel<FsModel> {
    private final ReentrantReadWriteLock lock = new ReentrantReadWriteLock();

    FsLockModel(FsModel model) {
        super(model);
    }

    public ReentrantReadWriteLock.ReadLock readLock() {
        return this.lock.readLock();
    }

    boolean isReadLockedByCurrentThread() {
        return 0 != this.lock.getReadHoldCount();
    }

    public ReentrantReadWriteLock.WriteLock writeLock() {
        return this.lock.writeLock();
    }

    public boolean isWriteLockedByCurrentThread() {
        return this.lock.isWriteLockedByCurrentThread();
    }

    public void checkWriteLockedByCurrentThread() throws FsNeedsWriteLockException {
        if (!this.isWriteLockedByCurrentThread()) {
            throw FsNeedsWriteLockException.get();
        }
    }
}

