/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.buildcache.checksum.exclude;

import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.buildcache.xml.config.Exclude;

public class Exclusion {
    private static final String GLOB_PX = "glob:";
    private static final String GLOB_ALL_PATHS = "**";
    private static final String GLOB_ALL_NAMES = "*";
    private static final String DEFAULT_GLOB = "**";
    private final Path absolutePath;
    private final PathMatcher matcher;
    private final MatcherType matcherType;
    private final EntryType entryType;
    private boolean matchesAllNames;
    private boolean matchesAllPaths;
    private final boolean configuredAsAbsolute;

    public Exclusion(Path basedir, Exclude exclude) {
        if (StringUtils.isNotBlank((CharSequence)exclude.getValue())) {
            Path candidate = Paths.get(FilenameUtils.separatorsToSystem((String)exclude.getValue()), new String[0]);
            this.configuredAsAbsolute = candidate.isAbsolute();
            Path resolvedPath = this.configuredAsAbsolute ? candidate : basedir.resolve(candidate);
            this.absolutePath = resolvedPath.toAbsolutePath().normalize();
        } else {
            this.configuredAsAbsolute = false;
            this.absolutePath = basedir;
        }
        String unixStyleGlob = this.convertGlobToUnixStyle(exclude.getGlob());
        this.matcher = FileSystems.getDefault().getPathMatcher(GLOB_PX + unixStyleGlob);
        this.matcherType = MatcherType.valueOf(exclude.getMatcherType().toUpperCase());
        this.entryType = EntryType.valueOf(exclude.getEntryType().toUpperCase());
        this.computeMatcherDenormalization(unixStyleGlob);
    }

    public Exclusion(Path absolutePath, MatcherType resolutionType, EntryType entryType) {
        this.configuredAsAbsolute = false;
        this.absolutePath = absolutePath;
        this.matcher = absolutePath.getFileSystem().getPathMatcher("glob:**");
        this.matcherType = resolutionType;
        this.entryType = entryType;
        this.computeMatcherDenormalization("**");
    }

    private String convertGlobToUnixStyle(String glob) {
        return glob.replace("\\\\", "/");
    }

    private void computeMatcherDenormalization(String glob) {
        if ("**".equals(glob)) {
            this.matchesAllPaths = true;
        } else if (GLOB_ALL_NAMES.equals(glob)) {
            this.matchesAllNames = true;
        }
    }

    public Path getAbsolutePath() {
        return this.absolutePath;
    }

    public EntryType getEntryType() {
        return this.entryType;
    }

    private boolean applies(Path path) {
        return path.startsWith(this.absolutePath);
    }

    public boolean excludesPath(Path parentPath, Path path) {
        if (this.applies(path)) {
            switch (this.matcherType) {
                case FILENAME: {
                    if (!this.matchesAllPaths && !this.matchesAllNames && !this.matcher.matches(path.getFileName())) break;
                    return true;
                }
                case PATH: {
                    if (!this.matchesAllPaths && !this.matcher.matches(this.configuredAsAbsolute ? path : parentPath.relativize(path))) break;
                    return true;
                }
                default: {
                    throw new RuntimeException("Exclusion resolution type not handled.");
                }
            }
        }
        return false;
    }

    public static enum EntryType {
        FILE,
        DIRECTORY,
        ALL;

    }

    public static enum MatcherType {
        FILENAME,
        PATH;

    }
}

