/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.xhtml;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import javax.swing.text.AttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.macro.MacroExecutionException;
import org.apache.maven.doxia.macro.MacroRequest;
import org.apache.maven.doxia.macro.manager.MacroNotFoundException;
import org.apache.maven.doxia.module.xhtml.XhtmlMarkup;
import org.apache.maven.doxia.parser.AbstractParser;
import org.apache.maven.doxia.parser.ParseException;
import org.apache.maven.doxia.parser.Parser;
import org.apache.maven.doxia.parser.XhtmlBaseParser;
import org.apache.maven.doxia.sink.Sink;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.util.IOUtil;
import org.codehaus.plexus.util.StringUtils;
import org.codehaus.plexus.util.xml.pull.XmlPullParser;
import org.codehaus.plexus.util.xml.pull.XmlPullParserException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Component(role=Parser.class, hint="xhtml")
public class XhtmlParser
extends XhtmlBaseParser
implements XhtmlMarkup {
    private static final Logger LOGGER = LoggerFactory.getLogger(XhtmlParser.class);
    protected boolean boxed;
    private boolean isEmptyElement;
    private String sourceContent;

    protected void handleStartTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        this.isEmptyElement = parser.isEmptyElementTag();
        SinkEventAttributeSet attribs = this.getAttributesFromParser(parser);
        if (parser.getName().equals(HTML.toString())) {
            return;
        }
        if (parser.getName().equals(HEAD.toString())) {
            sink.head((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(TITLE.toString())) {
            sink.title((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(META.toString())) {
            String name = parser.getAttributeValue(null, HTML.Attribute.NAME.toString());
            String content = parser.getAttributeValue(null, HTML.Attribute.CONTENT.toString());
            if ("author".equals(name)) {
                sink.author(null);
                sink.text(content);
                sink.author_();
            } else if ("date".equals(name)) {
                sink.date(null);
                sink.text(content);
                sink.date_();
            } else {
                sink.unknown("meta", new Object[]{1}, (SinkEventAttributes)attribs);
            }
        } else if (parser.getName().equals(ADDRESS.toString())) {
            sink.address((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(BODY.toString())) {
            sink.body((SinkEventAttributes)attribs);
        } else if (parser.getName().equals(DIV.toString())) {
            String divclass = parser.getAttributeValue(null, HTML.Attribute.CLASS.toString());
            if ("source".equals(divclass)) {
                this.boxed = true;
            }
            this.baseStartTag(parser, sink);
        } else if (parser.getName().equals(PRE.toString())) {
            if (this.boxed) {
                attribs.addAttributes((AttributeSet)SinkEventAttributeSet.BOXED);
            }
            this.verbatim();
            sink.verbatim((SinkEventAttributes)attribs);
        } else if (!this.baseStartTag(parser, sink)) {
            if (this.isEmptyElement) {
                this.handleUnknown(parser, sink, 1);
            } else {
                this.handleUnknown(parser, sink, 2);
            }
            LOGGER.warn("Unrecognized xhtml tag <{}> at [{}:{}]", new Object[]{parser.getName(), parser.getLineNumber(), parser.getColumnNumber()});
        }
    }

    protected void handleEndTag(XmlPullParser parser, Sink sink) throws XmlPullParserException, MacroExecutionException {
        if (parser.getName().equals(HTML.toString())) {
            return;
        }
        if (parser.getName().equals(HEAD.toString())) {
            sink.head_();
        } else if (parser.getName().equals(TITLE.toString())) {
            sink.title_();
        } else if (parser.getName().equals(BODY.toString())) {
            this.consecutiveSections(0, sink);
            sink.body_();
        } else if (parser.getName().equals(ADDRESS.toString())) {
            sink.address_();
        } else if (parser.getName().equals(DIV.toString())) {
            this.boxed = false;
            this.baseEndTag(parser, sink);
        } else if (!this.baseEndTag(parser, sink) && !this.isEmptyElement) {
            this.handleUnknown(parser, sink, 3);
        }
        this.isEmptyElement = false;
    }

    protected void handleComment(XmlPullParser parser, Sink sink) throws XmlPullParserException {
        String text = this.getText(parser).trim();
        if (text.startsWith("MACRO") && !this.isSecondParsing()) {
            this.processMacro(parser, text, sink);
        } else {
            super.handleComment(parser, sink);
        }
    }

    private void processMacro(XmlPullParser parser, String text, Sink sink) throws XmlPullParserException {
        String s = text.substring(text.indexOf(123) + 1, text.indexOf(125));
        s = this.escapeForMacro(s);
        String[] params = StringUtils.split((String)s, (String)"|");
        String macroName = params[0];
        HashMap<String, String> parameters = new HashMap<String, String>();
        for (int i = 1; i < params.length; ++i) {
            String[] param = StringUtils.split((String)params[i], (String)"=");
            if (param.length == 1) {
                throw new XmlPullParserException("Invalid 'key=value' pair for macro " + macroName + " parameter: " + params[i], parser, null);
            }
            String key = this.unescapeForMacro(param[0]);
            String value = this.unescapeForMacro(param[1]);
            parameters.put(key, value);
        }
        MacroRequest request = new MacroRequest(this.sourceContent, (AbstractParser)new XhtmlParser(), parameters, this.getBasedir());
        try {
            this.executeMacro(macroName, request, sink);
        }
        catch (MacroExecutionException e) {
            throw new XmlPullParserException("Unable to execute macro in the document: " + macroName, parser, (Throwable)e);
        }
        catch (MacroNotFoundException me) {
            throw new XmlPullParserException("Macro not found: " + macroName, parser, null);
        }
    }

    private String escapeForMacro(String s) {
        if (s == null || s.length() < 1) {
            return s;
        }
        String result = s;
        result = StringUtils.replace((String)result, (String)"\\=", (String)"\u0011");
        result = StringUtils.replace((String)result, (String)"\\|", (String)"\u0012");
        return result;
    }

    private String unescapeForMacro(String s) {
        if (s == null || s.length() < 1) {
            return s;
        }
        String result = s;
        result = StringUtils.replace((String)result, (String)"\u0011", (String)"=");
        result = StringUtils.replace((String)result, (String)"\u0012", (String)"|");
        return result;
    }

    protected void init() {
        super.init();
        this.boxed = false;
        this.isEmptyElement = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void parse(Reader source, Sink sink, String reference) throws ParseException {
        this.sourceContent = null;
        try {
            StringWriter contentWriter = new StringWriter();
            IOUtil.copy((Reader)source, (Writer)contentWriter);
            this.sourceContent = contentWriter.toString();
        }
        catch (IOException ex) {
            throw new ParseException("Error reading the input source: " + ex.getMessage(), (Exception)ex);
        }
        finally {
            IOUtil.close((Reader)source);
        }
        try {
            super.parse((Reader)new StringReader(this.sourceContent), sink, reference);
        }
        finally {
            this.sourceContent = null;
        }
    }
}

