/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.markdown;

import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.stream.Collectors;
import javax.swing.text.AttributeSet;
import org.apache.commons.lang3.StringUtils;
import org.apache.maven.doxia.module.markdown.MarkdownMarkup;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.sink.impl.AbstractTextSink;
import org.apache.maven.doxia.sink.impl.SinkEventAttributeSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MarkdownSink
extends AbstractTextSink
implements MarkdownMarkup {
    private static final Logger LOGGER = LoggerFactory.getLogger(MarkdownSink.class);
    private StringBuffer buffer;
    private Collection<String> authors;
    private String title;
    private String date;
    private String linkName;
    private boolean startFlag;
    private boolean tableCaptionFlag;
    private boolean tableCellFlag;
    private boolean tableHeaderCellFlag;
    private boolean headerFlag;
    private boolean bufferFlag;
    private boolean verbatimFlag;
    private boolean figureFlag;
    private int cellCount;
    private final PrintWriter writer;
    private boolean isWriterAtStartOfNewLine;
    private List<Integer> cellJustif;
    private boolean isFirstTableRow;
    private int listNestingLevel;
    private final Stack<String> listStyles;
    protected Stack<List<String>> inlineStack = new Stack();
    private String figureSrc;

    protected MarkdownSink(Writer writer) {
        this.writer = new PrintWriter(writer);
        this.isWriterAtStartOfNewLine = true;
        this.listStyles = new Stack();
        this.init();
    }

    protected StringBuffer getBuffer() {
        return this.buffer;
    }

    protected void setHeadFlag(boolean headFlag) {
        this.headerFlag = headFlag;
    }

    protected void init() {
        super.init();
        this.resetBuffer();
        this.listNestingLevel = 0;
        this.authors = new LinkedList<String>();
        this.title = null;
        this.date = null;
        this.linkName = null;
        this.startFlag = true;
        this.tableCaptionFlag = false;
        this.tableCellFlag = false;
        this.tableHeaderCellFlag = false;
        this.headerFlag = false;
        this.bufferFlag = false;
        this.verbatimFlag = false;
        this.figureFlag = false;
        this.cellCount = 0;
        this.cellJustif = null;
        this.listStyles.clear();
        this.inlineStack.clear();
    }

    protected void resetBuffer() {
        this.buffer = new StringBuffer();
    }

    public void head(SinkEventAttributes attributes) {
        boolean startFlag = this.startFlag;
        this.init();
        this.headerFlag = true;
        this.startFlag = startFlag;
    }

    public void head_() {
        this.headerFlag = false;
        if (this.title == null && this.authors.isEmpty() && this.date == null) {
            return;
        }
        this.write(METADATA_MARKUP + EOL);
        if (this.title != null) {
            this.write("title: " + this.title + EOL);
        }
        if (!this.authors.isEmpty()) {
            this.write("author: " + EOL);
            for (String author : this.authors) {
                this.write("  - " + author + EOL);
            }
        }
        if (this.date != null) {
            this.write("date: " + this.date + EOL);
        }
        this.write(METADATA_MARKUP + BLANK_LINE);
    }

    public void title_() {
        if (this.buffer.length() > 0) {
            this.title = this.buffer.toString();
            this.resetBuffer();
        }
    }

    public void author_() {
        if (this.buffer.length() > 0) {
            this.authors.add(this.buffer.toString());
            this.resetBuffer();
        }
    }

    public void date_() {
        if (this.buffer.length() > 0) {
            this.date = this.buffer.toString();
            this.resetBuffer();
        }
    }

    public void sectionTitle(int level, SinkEventAttributes attributes) {
        if (level > 0) {
            this.write(StringUtils.repeat((String)"#", (int)level) + ' ');
        }
    }

    public void sectionTitle_(int level) {
        if (level > 0) {
            this.write(BLANK_LINE);
        }
    }

    public void list(SinkEventAttributes attributes) {
        ++this.listNestingLevel;
        this.listStyles.push("-");
    }

    public void list_() {
        --this.listNestingLevel;
        if (this.listNestingLevel == 0) {
            this.write(EOL);
        }
        this.listStyles.pop();
    }

    public void listItem(SinkEventAttributes attributes) {
        this.orderedOrUnorderedListItem();
    }

    public void listItem_() {
        this.orderedOrUnorderedListItem_();
    }

    public void numberedList(int numbering, SinkEventAttributes attributes) {
        ++this.listNestingLevel;
        if (numbering != 0) {
            LOGGER.warn("Markdown only supports numbered item with decimal style ({}) but requested was style {}, falling back to decimal style", (Object)0, (Object)numbering);
        }
        String style = "1.";
        this.listStyles.push(style);
    }

    public void numberedList_() {
        --this.listNestingLevel;
        if (this.listNestingLevel == 0) {
            this.write(EOL);
        }
        this.listStyles.pop();
    }

    public void numberedListItem(SinkEventAttributes attributes) {
        this.orderedOrUnorderedListItem();
    }

    public void numberedListItem_() {
        this.orderedOrUnorderedListItem_();
    }

    private void orderedOrUnorderedListItem() {
        this.write(this.getListPrefix());
    }

    private void orderedOrUnorderedListItem_() {
        this.ensureBeginningOfLine();
    }

    private String getListPrefix() {
        StringBuilder prefix = new StringBuilder();
        for (int indent = 1; indent < this.listNestingLevel; ++indent) {
            prefix.append("    ");
        }
        prefix.append(this.listStyles.peek());
        prefix.append(' ');
        return prefix.toString();
    }

    public void definitionList(SinkEventAttributes attributes) {
        LOGGER.warn("Definition list not natively supported in Markdown, rendering HTML instead");
        this.write("<dl>" + EOL);
    }

    public void definitionList_() {
        this.verbatimFlag = true;
        this.write("</dl>" + BLANK_LINE);
    }

    public void definedTerm(SinkEventAttributes attributes) {
        this.write("<dt>");
        this.verbatimFlag = false;
    }

    public void definedTerm_() {
        this.write("</dt>" + EOL);
    }

    public void definition(SinkEventAttributes attributes) {
        this.write("<dd>");
    }

    public void definition_() {
        this.write("</dd>" + EOL);
    }

    public void pageBreak() {
        LOGGER.warn("Ignoring unsupported page break in Markdown");
    }

    public void paragraph(SinkEventAttributes attributes) {
        this.ensureBeginningOfLine();
    }

    public void paragraph_() {
        if (!this.tableCellFlag && this.listNestingLevel <= 0) {
            this.write(BLANK_LINE);
        }
    }

    public void verbatim(SinkEventAttributes attributes) {
        this.ensureBeginningOfLine();
        this.verbatimFlag = true;
        this.write("```" + EOL);
    }

    public void verbatim_() {
        this.ensureBeginningOfLine();
        this.write("```" + BLANK_LINE);
        this.verbatimFlag = false;
    }

    public void horizontalRule(SinkEventAttributes attributes) {
        this.ensureBeginningOfLine();
        this.write("***" + BLANK_LINE);
    }

    public void table(SinkEventAttributes attributes) {
        this.ensureBeginningOfLine();
    }

    public void tableRows(int[] justification, boolean grid) {
        this.cellJustif = justification != null ? (List<Object>)Arrays.stream(justification).boxed().collect(Collectors.toCollection(ArrayList::new)) : new ArrayList<Integer>();
        this.isFirstTableRow = true;
    }

    public void tableRows_() {
        this.cellJustif = null;
    }

    public void tableRow(SinkEventAttributes attributes) {
        this.cellCount = 0;
    }

    public void tableRow_() {
        if (this.isFirstTableRow && !this.tableHeaderCellFlag) {
            this.writeEmptyTableHeader();
            this.writeTableDelimiterRow();
            this.tableHeaderCellFlag = false;
            this.isFirstTableRow = false;
        }
        this.write(TABLE_ROW_PREFIX);
        this.write(this.buffer.toString());
        this.resetBuffer();
        this.write(EOL);
        if (this.isFirstTableRow) {
            this.writeTableDelimiterRow();
            this.isFirstTableRow = false;
        }
        this.cellCount = 0;
    }

    private void writeEmptyTableHeader() {
        this.write(TABLE_ROW_PREFIX);
        for (int i = 0; i < this.cellCount; ++i) {
            this.write(StringUtils.repeat((String)String.valueOf(' '), (int)3) + TABLE_CELL_SEPARATOR_MARKUP);
        }
        this.write(EOL);
    }

    private void writeTableDelimiterRow() {
        this.write(TABLE_ROW_PREFIX);
        int justification = 1;
        for (int i = 0; i < this.cellCount; ++i) {
            if (this.cellJustif != null && this.cellJustif.size() > i) {
                justification = this.cellJustif.get(i);
            }
            switch (justification) {
                case 2: {
                    this.write(TABLE_COL_RIGHT_ALIGNED_MARKUP);
                    break;
                }
                case 0: {
                    this.write(TABLE_COL_CENTER_ALIGNED_MARKUP);
                    break;
                }
                default: {
                    this.write(TABLE_COL_LEFT_ALIGNED_MARKUP);
                }
            }
            this.write(TABLE_CELL_SEPARATOR_MARKUP);
        }
        this.write(EOL);
    }

    public void tableCell(SinkEventAttributes attributes) {
        int cellJustification;
        if (attributes != null && (cellJustification = attributes.containsAttributes((AttributeSet)SinkEventAttributeSet.LEFT) ? 1 : (attributes.containsAttributes((AttributeSet)SinkEventAttributeSet.RIGHT) ? 2 : (attributes.containsAttributes((AttributeSet)SinkEventAttributeSet.CENTER) ? 0 : -1))) > -1) {
            if (this.cellJustif.size() > this.cellCount) {
                this.cellJustif.set(this.cellCount, cellJustification);
            } else if (this.cellJustif.size() == this.cellCount) {
                this.cellJustif.add(cellJustification);
            } else {
                for (int precedingCol = this.cellJustif.size(); precedingCol < this.cellCount; ++precedingCol) {
                    this.cellJustif.add(1);
                }
                this.cellJustif.add(cellJustification);
            }
        }
        this.tableCellFlag = true;
    }

    public void tableHeaderCell(SinkEventAttributes attributes) {
        this.tableCell(attributes);
        this.tableHeaderCellFlag = true;
    }

    public void tableCell_() {
        this.endTableCell();
    }

    public void tableHeaderCell_() {
        this.endTableCell();
    }

    private void endTableCell() {
        this.tableCellFlag = false;
        this.buffer.append(TABLE_CELL_SEPARATOR_MARKUP);
        ++this.cellCount;
    }

    public void tableCaption(SinkEventAttributes attributes) {
        this.tableCaptionFlag = true;
    }

    public void tableCaption_() {
        this.tableCaptionFlag = false;
    }

    public void figure(SinkEventAttributes attributes) {
        this.figureSrc = null;
        this.figureFlag = true;
    }

    public void figureCaption(SinkEventAttributes attributes) {
        this.bufferFlag = true;
    }

    public void figureCaption_() {
        this.bufferFlag = false;
    }

    public void figureGraphics(String name, SinkEventAttributes attributes) {
        this.figureSrc = MarkdownSink.escapeMarkdown(name);
        if (!this.figureFlag) {
            Object alt = attributes.getAttribute((Object)"alt");
            if (alt == null) {
                alt = "";
            }
            this.writeImage(MarkdownSink.escapeMarkdown(alt.toString()), name);
        }
    }

    public void figure_() {
        this.writeImage(this.buffer.toString(), this.figureSrc);
        this.figureFlag = false;
    }

    private void writeImage(String alt, String src) {
        this.write("![");
        this.write(alt);
        this.write("](" + src + ")");
    }

    public void anchor(String name, SinkEventAttributes attributes) {
    }

    public void anchor_() {
    }

    public void link(String name, SinkEventAttributes attributes) {
        if (!this.headerFlag) {
            this.write("[");
            this.linkName = name;
        }
    }

    public void link_() {
        if (!this.headerFlag) {
            this.write("](");
            this.text(this.linkName.startsWith("#") ? this.linkName.substring(1) : this.linkName);
            this.write(")");
            this.linkName = null;
        }
    }

    void link(String name, String target) {
        if (!this.headerFlag) {
            this.write("[");
        }
    }

    public void inline(SinkEventAttributes attributes) {
        if (!this.headerFlag && !this.verbatimFlag) {
            ArrayList<String> tags = new ArrayList<String>();
            if (attributes != null) {
                if (attributes.containsAttribute((Object)"semantics", (Object)"em") || attributes.containsAttribute((Object)"semantics", (Object)"italic")) {
                    this.write("_");
                    tags.add(0, "_");
                }
                if (attributes.containsAttribute((Object)"semantics", (Object)"strong") || attributes.containsAttribute((Object)"semantics", (Object)"bold")) {
                    this.write("**");
                    tags.add(0, "**");
                }
                if (attributes.containsAttribute((Object)"semantics", (Object)"code")) {
                    this.write("`");
                    tags.add(0, "`");
                }
            }
            this.inlineStack.push(tags);
        }
    }

    public void inline_() {
        if (!this.headerFlag && !this.verbatimFlag) {
            for (String tag : this.inlineStack.pop()) {
                this.write(tag);
            }
        }
    }

    public void italic() {
        this.inline(SinkEventAttributeSet.Semantics.ITALIC);
    }

    public void italic_() {
        this.inline_();
    }

    public void bold() {
        this.inline(SinkEventAttributeSet.Semantics.BOLD);
    }

    public void bold_() {
        this.inline_();
    }

    public void monospaced() {
        this.inline(SinkEventAttributeSet.Semantics.CODE);
    }

    public void monospaced_() {
        this.inline_();
    }

    public void lineBreak(SinkEventAttributes attributes) {
        if (this.headerFlag || this.bufferFlag) {
            this.buffer.append(EOL);
        } else if (this.verbatimFlag) {
            this.write(EOL);
        } else {
            this.write("  " + EOL);
        }
    }

    public void nonBreakingSpace() {
        if (this.headerFlag || this.bufferFlag) {
            this.buffer.append("&nbsp;");
        } else {
            this.write("&nbsp;");
        }
    }

    public void text(String text, SinkEventAttributes attributes) {
        if (attributes != null) {
            this.inline(attributes);
        }
        if (this.tableCaptionFlag) {
            LOGGER.warn("Ignoring unsupported table caption in Markdown");
        } else if (this.headerFlag || this.bufferFlag) {
            this.buffer.append(MarkdownSink.escapeMarkdown(text));
        } else if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
        if (attributes != null) {
            this.inline_();
        }
    }

    public void rawText(String text) {
        this.write(text);
    }

    public void comment(String comment) {
        this.rawText((this.startFlag ? "" : EOL) + "<!-- " + comment + " -->");
    }

    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        LOGGER.warn("Unknown Sink event '" + name + "', ignoring!");
    }

    protected void write(String text) {
        this.startFlag = false;
        String unifiedText = MarkdownSink.unifyEOLs((String)text);
        if (this.tableCellFlag) {
            this.buffer.append(MarkdownSink.escapeForTableCell(unifiedText));
        } else {
            this.isWriterAtStartOfNewLine = unifiedText.endsWith(EOL);
            this.writer.write(unifiedText);
        }
    }

    protected void content(String text) {
        this.write(MarkdownSink.escapeMarkdown(text));
    }

    protected void verbatimContent(String text) {
        this.write(text);
    }

    public void flush() {
        this.writer.flush();
    }

    public void close() {
        this.writer.close();
        this.init();
    }

    private static String escapeMarkdown(String text) {
        if (text == null) {
            return "";
        }
        int length = text.length();
        StringBuilder buffer = new StringBuilder(length);
        block3: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '!': 
                case '#': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case '-': 
                case '.': 
                case '[': 
                case '\\': 
                case ']': 
                case '_': 
                case '`': 
                case '{': 
                case '}': {
                    buffer.append('\\');
                    buffer.append(c);
                    continue block3;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    private static String escapeForTableCell(String text) {
        return text.replace("|", "\\|");
    }

    private void ensureBeginningOfLine() {
        if (!this.isWriterAtStartOfNewLine) {
            this.write(EOL);
        }
    }
}

