/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.itext;

import com.lowagie.text.DocumentException;
import com.lowagie.text.PageSize;
import com.lowagie.text.Rectangle;
import com.lowagie.text.xml.XmlToHtml;
import com.lowagie.text.xml.XmlToPdf;
import com.lowagie.text.xml.XmlToRtf;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.util.Locale;

public class ITextUtil {
    static /* synthetic */ Class class$com$lowagie$text$Rectangle;

    public static Rectangle getDefaultPageSize() {
        String defaultCountry = Locale.getDefault().getCountry();
        if (defaultCountry != null && (defaultCountry.equals(Locale.US.getCountry()) || defaultCountry.equals(Locale.CANADA.getCountry()))) {
            return PageSize.LETTER;
        }
        return PageSize.A4;
    }

    public static String getPageSize(Rectangle rect) {
        Field[] fields = PageSize.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field currentField = fields[i];
            try {
                if (!currentField.getType().equals(class$com$lowagie$text$Rectangle == null ? ITextUtil.class$("com.lowagie.text.Rectangle") : class$com$lowagie$text$Rectangle)) continue;
                Rectangle fPageSize = (Rectangle)currentField.get(null);
                if (rect.width() != fPageSize.width() || rect.height() != fPageSize.height()) continue;
                return currentField.getName();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        return "A4";
    }

    public static boolean isPageSizeSupported(String aPageSize) {
        Field[] fields = PageSize.class.getFields();
        for (int i = 0; i < fields.length; ++i) {
            Field currentField = fields[i];
            if (!currentField.getName().equalsIgnoreCase(aPageSize) || !currentField.getType().equals(class$com$lowagie$text$Rectangle == null ? ITextUtil.class$("com.lowagie.text.Rectangle") : class$com$lowagie$text$Rectangle)) continue;
            return true;
        }
        return false;
    }

    public static void writePdf(InputStream is, OutputStream os) {
        try {
            XmlToPdf x = new XmlToPdf();
            x.parse(is, os);
        }
        catch (DocumentException e) {
            throw new RuntimeException("DocumentException : " + e.getMessage(), e);
        }
    }

    public static void writeRtf(InputStream is, OutputStream os) {
        try {
            XmlToRtf x = new XmlToRtf();
            x.parse(is, os);
        }
        catch (DocumentException e) {
            throw new RuntimeException("DocumentException : " + e.getMessage(), e);
        }
    }

    public static void writeHtml(InputStream is, OutputStream os) {
        try {
            XmlToHtml x = new XmlToHtml();
            x.parse(is, os);
        }
        catch (DocumentException e) {
            throw new RuntimeException("DocumentException : " + e.getMessage(), e);
        }
    }
}

