/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.itext;

import com.lowagie.text.pdf.DefaultFontMapper;
import com.lowagie.text.pdf.FontMapper;
import java.awt.Color;
import java.awt.Font;

public class ITextFont {
    public static final String NORMAL = "normal";
    public static final String BOLD = "bold";
    public static final String ITALIC = "italic";
    public static final String UNDERLINE = "underline";
    public static final String DEFAULT_FONT_NAME = "Helvetica";
    public static final float DEFAULT_FONT_SIZE = 12.0f;
    public static final String DEFAULT_FONT_STYLE = "normal";
    public static final int DEFAULT_FONT_COLOR_RED = Color.BLACK.getRed();
    public static final int DEFAULT_FONT_COLOR_GREEN = Color.BLACK.getGreen();
    public static final int DEFAULT_FONT_COLOR_BLUE = Color.BLACK.getBlue();
    private static final FontMapper FONT_MAPPER = new DefaultFontMapper();
    private boolean monoSpaced = false;
    private float currentSize = 12.0f;
    private int currentStyle = 0;
    private Color currentColor = Color.BLACK;

    public void addBold() {
        ++this.currentStyle;
    }

    public void removeBold() {
        --this.currentStyle;
        if (this.currentStyle < 0) {
            this.currentStyle = 0;
        }
    }

    public void addItalic() {
        this.currentStyle += 2;
    }

    public void removeItalic() {
        this.currentStyle -= 2;
        if (this.currentStyle < 0) {
            this.currentStyle = 0;
        }
    }

    public void addUnderlined() {
        this.currentStyle += 4;
    }

    public void removeUnderlined() {
        this.currentStyle -= 4;
        if (this.currentStyle < 0) {
            this.currentStyle = 0;
        }
    }

    public void setMonoSpaced(boolean monoSpaced) {
        this.monoSpaced = monoSpaced;
    }

    public void setColor(Color color) {
        this.currentColor = color;
    }

    public void setSize(float size) {
        this.currentSize = size;
    }

    public String getFontName() {
        com.lowagie.text.Font font = this.getCurrentFont();
        return font.getFamilyname();
    }

    public String getFontStyle() {
        com.lowagie.text.Font font = this.getCurrentFont();
        StringBuffer sb = new StringBuffer();
        if (font.isBold()) {
            sb.append(BOLD);
        }
        if (font.isItalic()) {
            if (sb.length() == 0) {
                sb.append(ITALIC);
            } else {
                sb.append(",");
                sb.append(ITALIC);
            }
        }
        if (font.isUnderlined()) {
            if (sb.length() == 0) {
                sb.append(UNDERLINE);
            } else {
                sb.append(",");
                sb.append(UNDERLINE);
            }
        }
        if (sb.length() == 0) {
            return "normal";
        }
        return sb.toString();
    }

    public String getFontSize() {
        com.lowagie.text.Font font = this.getCurrentFont();
        return String.valueOf(font.getCalculatedSize());
    }

    public String getFontColorBlue() {
        com.lowagie.text.Font font = this.getCurrentFont();
        return String.valueOf(font.color().getBlue());
    }

    public String getFontColorGreen() {
        com.lowagie.text.Font font = this.getCurrentFont();
        return String.valueOf(font.color().getGreen());
    }

    public String getFontColorRed() {
        com.lowagie.text.Font font = this.getCurrentFont();
        return String.valueOf(font.color().getRed());
    }

    public static int getSectionFontSize(int sectionNumber) {
        switch (sectionNumber) {
            case 0: {
                return 24;
            }
            case 1: {
                return 22;
            }
            case 2: {
                return 20;
            }
            case 3: {
                return 18;
            }
            case 4: {
                return 16;
            }
        }
        return 14;
    }

    public static com.lowagie.text.Font getMonoSpacedFont(int style, float size, Color color) {
        return new com.lowagie.text.Font(FONT_MAPPER.awtToPdf(new Font("Monospaced", 0, 0)), size, style, color);
    }

    public static com.lowagie.text.Font getFont(int style, float size, Color color) {
        com.lowagie.text.Font font = new com.lowagie.text.Font();
        font.setFamily(DEFAULT_FONT_NAME);
        font.setStyle(style);
        font.setSize(size);
        font.setColor(color);
        return font;
    }

    private com.lowagie.text.Font getCurrentFont() {
        if (this.monoSpaced) {
            return ITextFont.getMonoSpacedFont(this.currentStyle, this.currentSize, this.currentColor);
        }
        return ITextFont.getFont(this.currentStyle, this.currentSize, this.currentColor);
    }
}

