/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.fo;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import javax.swing.text.MutableAttributeSet;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.module.fo.FoConfiguration;
import org.apache.maven.doxia.module.fo.FoMarkup;
import org.apache.maven.doxia.module.fo.NumberedListItem;
import org.apache.maven.doxia.sink.AbstractXmlSink;
import org.apache.maven.doxia.sink.SinkEventAttributeSet;
import org.apache.maven.doxia.sink.SinkEventAttributes;
import org.apache.maven.doxia.util.DoxiaUtils;
import org.apache.maven.doxia.util.HtmlTools;
import org.codehaus.plexus.util.StringUtils;

public class FoSink
extends AbstractXmlSink
implements FoMarkup {
    private final Writer out;
    private StringWriter tempWriter;
    private final Stack listStack = new Stack();
    private final FoConfiguration config;
    private int section = 0;
    private int subsection = 0;
    private int subsubsection = 0;
    private boolean tableGrid;
    private int[] cellJustif;
    private boolean isCellJustif;
    private int cellCount;
    private boolean verbatim;
    private boolean figure;
    private String encoding;
    private String languageId;

    protected FoSink(Writer writer) {
        this(writer, "UTF-8");
    }

    protected FoSink(Writer writer, String encoding) {
        this.out = writer;
        this.tempWriter = new StringWriter();
        this.encoding = encoding;
        this.config = new FoConfiguration();
        this.setNameSpace("fo");
    }

    protected FoSink(Writer writer, String encoding, String languageId) {
        this(writer, encoding);
        this.languageId = languageId;
    }

    public void head() {
        this.beginDocument();
        this.startPageSequence("0", null, null);
    }

    public void head_() {
        this.writeEOL();
    }

    public void title() {
        this.writeStartTag(BLOCK_TAG, "doc.header.title");
    }

    public void title_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void author() {
        this.writeStartTag(BLOCK_TAG, "doc.header.author");
    }

    public void author_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void date() {
        this.writeStartTag(BLOCK_TAG, "doc.header.date");
    }

    public void date_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void body() {
    }

    public void body_() {
        this.writeEOL();
        this.writeEndTag(FLOW_TAG);
        this.writeEOL();
        this.writeEndTag(PAGE_SEQUENCE_TAG);
        this.writeEOL();
        this.endDocument();
    }

    public void sectionTitle() {
    }

    public void sectionTitle_() {
    }

    public void section1() {
        ++this.section;
        this.subsection = 0;
        this.subsubsection = 0;
        this.onSection();
    }

    public void sectionTitle1() {
        this.onSectionTitle(1);
    }

    public void sectionTitle1_() {
        this.onSectionTitle_();
    }

    public void section1_() {
        this.onSection_();
    }

    public void section2() {
        ++this.subsection;
        this.subsubsection = 0;
        this.onSection();
    }

    public void sectionTitle2() {
        this.onSectionTitle(2);
    }

    public void sectionTitle2_() {
        this.onSectionTitle_();
    }

    public void section2_() {
        this.onSection_();
    }

    public void section3() {
        ++this.subsubsection;
        this.onSection();
    }

    public void sectionTitle3() {
        this.onSectionTitle(3);
    }

    public void sectionTitle3_() {
        this.onSectionTitle_();
    }

    public void section3_() {
        this.onSection_();
    }

    public void section4() {
        this.onSection();
    }

    public void sectionTitle4() {
        this.onSectionTitle(4);
    }

    public void sectionTitle4_() {
        this.onSectionTitle_();
    }

    public void section4_() {
        this.onSection_();
    }

    public void section5() {
        this.onSection();
    }

    public void sectionTitle5() {
        this.onSectionTitle(5);
    }

    public void sectionTitle5_() {
        this.onSectionTitle_();
    }

    public void section5_() {
        this.onSection_();
    }

    private void onSection() {
        this.writeEOL();
        this.writeStartTag(BLOCK_TAG, "body.text");
    }

    private void onSectionTitle(int depth) {
        StringBuffer title = new StringBuffer(16);
        title.append(this.getChapterString());
        this.writeEOL();
        if (depth == 1) {
            this.writeStartTag(BLOCK_TAG, "body.h1");
            title.append(this.section).append("   ");
        } else if (depth == 2) {
            this.writeStartTag(BLOCK_TAG, "body.h2");
            title.append(this.section).append(".");
            title.append(this.subsection).append("   ");
        } else if (depth == 3) {
            this.writeStartTag(BLOCK_TAG, "body.h3");
            title.append(this.section).append(".");
            title.append(this.subsection).append(".");
            title.append(this.subsubsection).append("   ");
        } else if (depth == 4) {
            this.writeStartTag(BLOCK_TAG, "body.h4");
        } else {
            this.writeStartTag(BLOCK_TAG, "body.h5");
        }
        this.write(title.toString());
    }

    private void onSectionTitle_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    private void onSection_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    protected void resetSectionCounter() {
        this.section = 0;
    }

    protected String getChapterString() {
        return "";
    }

    public void list() {
        this.writeEOL();
        this.writeStartTag(LIST_BLOCK_TAG, "list");
    }

    public void list_() {
        this.writeEndTag(LIST_BLOCK_TAG);
        this.writeEOL();
    }

    public void listItem() {
        this.writeStartTag(LIST_ITEM_TAG, "list.item");
        this.writeln("<fo:list-item-label><fo:block>&#8226;</fo:block></fo:list-item-label>");
        this.writeStartTag(LIST_ITEM_BODY_TAG, "list.item");
        this.writeStartTag(BLOCK_TAG, "");
    }

    public void listItem_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
        this.writeEndTag(LIST_ITEM_BODY_TAG);
        this.writeEOL();
        this.writeEndTag(LIST_ITEM_TAG);
        this.writeEOL();
    }

    public void numberedList(int numbering) {
        this.listStack.push(new NumberedListItem(numbering));
        this.writeEOL();
        this.writeStartTag(LIST_BLOCK_TAG, "list");
    }

    public void numberedList_() {
        this.listStack.pop();
        this.writeEndTag(LIST_BLOCK_TAG);
        this.writeEOL();
    }

    public void numberedListItem() {
        NumberedListItem current = (NumberedListItem)this.listStack.peek();
        current.next();
        this.writeStartTag(LIST_ITEM_TAG, "list.item");
        this.writeStartTag(LIST_ITEM_LABEL_TAG, "");
        this.writeStartTag(BLOCK_TAG, "");
        this.write(current.getListItemSymbol());
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
        this.writeEndTag(LIST_ITEM_LABEL_TAG);
        this.writeEOL();
        this.writeStartTag(LIST_ITEM_BODY_TAG, "list.item");
        this.writeStartTag(BLOCK_TAG, "");
    }

    public void numberedListItem_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
        this.writeEndTag(LIST_ITEM_BODY_TAG);
        this.writeEOL();
        this.writeEndTag(LIST_ITEM_TAG);
        this.writeEOL();
    }

    public void definitionList() {
        this.writeEOL();
        this.writeStartTag(BLOCK_TAG, "dl");
    }

    public void definitionList_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void definitionListItem() {
    }

    public void definitionListItem_() {
    }

    public void definedTerm() {
        this.writeStartTag(BLOCK_TAG, "dt");
    }

    public void definedTerm_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void definition() {
        this.writeEOL();
        this.writeStartTag(BLOCK_TAG, "dd");
    }

    public void definition_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void figure() {
        this.figure = true;
        this.writeEOL();
        this.writeStartTag(BLOCK_TAG, "figure.display");
        this.write("<fo:external-graphic" + this.config.getAttributeString("figure.graphics"));
    }

    public void figure_() {
        this.figure = false;
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void figureGraphics(String name) {
        if (!this.isFigure()) {
            this.write("<fo:external-graphic" + this.config.getAttributeString("figure.graphics"));
        }
        this.writeln(" src=\"" + name + "\"/>");
    }

    protected boolean isFigure() {
        return this.figure;
    }

    public void figureCaption() {
        this.writeStartTag(BLOCK_TAG, "figure.caption");
    }

    public void figureCaption_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void paragraph() {
        this.writeStartTag(BLOCK_TAG, "normal.paragraph");
    }

    public void paragraph_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void verbatim(boolean boxed) {
        this.verbatim = true;
        if (boxed) {
            this.writeStartTag(BLOCK_TAG, "body.source");
        } else {
            this.writeStartTag(BLOCK_TAG, "body.pre");
        }
    }

    public void verbatim_() {
        this.verbatim = false;
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void horizontalRule() {
        this.writeEOL();
        this.writeStartTag(BLOCK_TAG, "");
        this.writeEmptyTag(LEADER_TAG, "body.rule");
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void pageBreak() {
        this.writeEmptyTag(BLOCK_TAG, "break-before", "page");
        this.writeEOL();
    }

    public void table() {
        this.writeEOL();
        this.writeStartTag(BLOCK_TAG, "table.padding");
        this.writeStartTag(TABLE_TAG, "table.layout");
    }

    public void table_() {
        String content = this.tempWriter.toString();
        if (content.lastIndexOf("<fo:table ") != -1 || content.lastIndexOf("<fo:table>") != -1) {
            StringBuffer sb = new StringBuffer();
            sb.append("<fo:table-column column-width=\"proportional-column-width(1)\"/>");
            sb.append(EOL);
            int percent = 100 / this.cellCount;
            for (int i = 0; i < this.cellCount; ++i) {
                sb.append("<fo:table-column column-width=\"" + percent + "%\"/>");
                sb.append(EOL);
            }
            sb.append("<fo:table-column column-width=\"proportional-column-width(1)\"/>");
            sb.append(EOL);
            String subContent = content.lastIndexOf("<fo:table ") != -1 ? content.substring(content.lastIndexOf("<fo:table ")) : content.substring(content.lastIndexOf("<fo:table>"));
            String table = subContent.substring(0, subContent.indexOf(">") + 1);
            String subContentUpdated = StringUtils.replace((String)subContent, (String)table, (String)(table + EOL + sb.toString()));
            this.tempWriter = new StringWriter();
            this.tempWriter.write(StringUtils.replace((String)content, (String)subContent, (String)subContentUpdated));
        }
        this.writeEndTag(TABLE_TAG);
        this.writeEOL();
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
    }

    public void tableRows(int[] justification, boolean grid) {
        this.tableGrid = grid;
        this.cellJustif = justification;
        this.isCellJustif = true;
        this.writeStartTag(TABLE_BODY_TAG, "");
    }

    public void tableRows_() {
        this.cellJustif = null;
        this.isCellJustif = false;
        this.writeEndTag(TABLE_BODY_TAG);
        this.writeEOL();
    }

    public void tableRow() {
        this.writeStartTag(TABLE_ROW_TAG, "table.body.row");
        this.cellCount = 0;
    }

    public void tableRow_() {
        this.writeEndTag(TABLE_ROW_TAG);
        this.writeEOL();
    }

    public void tableCell() {
        this.tableCell(false);
    }

    public void tableCell(String width) {
        this.tableCell(false);
    }

    public void tableHeaderCell() {
        this.tableCell(true);
    }

    public void tableHeaderCell(String width) {
        this.tableCell(true);
    }

    private void tableCell(boolean headerRow) {
        String justif = null;
        if (this.cellJustif != null && this.isCellJustif) {
            switch (this.cellJustif[Math.min(this.cellCount, this.cellJustif.length - 1)]) {
                case 1: {
                    justif = "left";
                    break;
                }
                case 2: {
                    justif = "right";
                    break;
                }
                default: {
                    justif = "center";
                }
            }
        }
        if (justif != null) {
            this.write("<fo:table-cell column-number=\"" + String.valueOf(this.cellCount + 2) + "\"");
            if (this.tableGrid) {
                this.write(" border-style=\"solid\" border-width=\"0.2mm\" keep-together.within-column=\"always\"");
            }
            this.writeln(this.config.getAttributeString("table.body.cell") + ">");
        } else {
            this.writeStartTag(TABLE_CELL_TAG, "table.body.cell");
        }
        this.writeln("<fo:block text-align=\"" + justif + "\">");
    }

    public void tableCell_() {
        this.writeEndTag(BLOCK_TAG);
        this.writeEOL();
        this.writeEndTag(TABLE_CELL_TAG);
        this.writeEOL();
        if (this.isCellJustif) {
            ++this.cellCount;
        }
    }

    public void tableHeaderCell_() {
        this.tableCell_();
    }

    public void tableCaption() {
    }

    public void tableCaption_() {
    }

    public void anchor(String name) {
        if (name == null) {
            throw new NullPointerException("Anchor name cannot be null!");
        }
        String anchor = name;
        if (!DoxiaUtils.isValidId((String)anchor)) {
            anchor = DoxiaUtils.encodeId((String)name);
            this.getLog().warn((CharSequence)("[FO Sink] Modified invalid anchor name: " + name));
        }
        anchor = "#" + name;
        this.writeStartTag(INLINE_TAG, "id", anchor);
    }

    public void anchor_() {
        this.writeEndTag(INLINE_TAG);
    }

    public void link(String name) {
        if (name == null) {
            throw new NullPointerException("Link name cannot be null!");
        }
        if (DoxiaUtils.isExternalLink((String)name)) {
            this.writeStartTag(BASIC_LINK_TAG, "external-destination", HtmlTools.escapeHTML((String)name));
            this.writeStartTag(INLINE_TAG, "href.external");
        } else if (DoxiaUtils.isInternalLink((String)name)) {
            String anchor = name.substring(1);
            if (!DoxiaUtils.isValidId((String)anchor)) {
                anchor = DoxiaUtils.encodeId((String)anchor);
                this.getLog().warn((CharSequence)("[FO Sink] Modified invalid link name: " + name));
            }
            anchor = "#" + anchor;
            this.writeStartTag(BASIC_LINK_TAG, "internal-destination", HtmlTools.escapeHTML((String)anchor));
            this.writeStartTag(INLINE_TAG, "href.internal");
        } else {
            String anchor = name;
            this.writeStartTag(BASIC_LINK_TAG, "internal-destination", HtmlTools.escapeHTML((String)anchor));
            this.writeStartTag(INLINE_TAG, "href.internal");
        }
    }

    public void link_() {
        this.writeEndTag(INLINE_TAG);
        this.writeEndTag(BASIC_LINK_TAG);
    }

    public void italic() {
        this.writeStartTag(INLINE_TAG, "italic");
    }

    public void italic_() {
        this.writeEndTag(INLINE_TAG);
    }

    public void bold() {
        this.writeStartTag(INLINE_TAG, "bold");
    }

    public void bold_() {
        this.writeEndTag(INLINE_TAG);
    }

    public void monospaced() {
        this.writeStartTag(INLINE_TAG, "monospace");
    }

    public void monospaced_() {
        this.writeEndTag(INLINE_TAG);
    }

    public void lineBreak() {
        this.writeEOL();
        this.writeEmptyTag(BLOCK_TAG, "");
    }

    public void nonBreakingSpace() {
        this.write("&#160;");
    }

    public void text(String text) {
        this.content(text);
    }

    public void rawText(String text) {
        this.write(text);
    }

    public void flush() {
        try {
            this.out.flush();
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
        }
    }

    public void close() {
        try {
            this.out.write(this.tempWriter.toString());
            this.tempWriter = new StringWriter();
            this.out.close();
        }
        catch (IOException e) {
            this.getLog().debug((Throwable)e);
        }
    }

    public void unknown(String name, Object[] requiredParams, SinkEventAttributes attributes) {
        this.getLog().warn((CharSequence)("Unknown Sink event in FoSink: " + name + ", ignoring!"));
    }

    public void beginDocument() {
        this.write("<?xml version=\"1.0\"");
        if (this.encoding != null) {
            this.write(" encoding=\"" + this.encoding + "\"");
        }
        this.write("?>");
        this.writeEOL();
        SinkEventAttributeSet atts = new SinkEventAttributeSet();
        atts.addAttribute("xmlns:" + this.getNameSpace(), "http://www.w3.org/1999/XSL/Format");
        if (this.languageId != null) {
            atts.addAttribute("language", this.languageId);
        }
        this.writeStartTag(ROOT_TAG, (MutableAttributeSet)atts);
        this.writeStartTag(LAYOUT_MASTER_SET_TAG, "");
        this.writeStartTag(SIMPLE_PAGE_MASTER_TAG, "layout.master.set.cover-page");
        this.writeEmptyTag(REGION_BODY_TAG, "layout.master.set.cover-page.region-body");
        this.writeEndTag(SIMPLE_PAGE_MASTER_TAG);
        this.writeEOL();
        this.writeStartTag(SIMPLE_PAGE_MASTER_TAG, "layout.master.set.toc");
        this.writeEmptyTag(REGION_BODY_TAG, "layout.master.set.toc.region-body");
        this.writeEmptyTag(REGION_BEFORE_TAG, "layout.master.set.toc.region-before");
        this.writeEmptyTag(REGION_AFTER_TAG, "layout.master.set.toc.region-after");
        this.writeEndTag(SIMPLE_PAGE_MASTER_TAG);
        this.writeEOL();
        this.writeStartTag(SIMPLE_PAGE_MASTER_TAG, "layout.master.set.body");
        this.writeEmptyTag(REGION_BODY_TAG, "layout.master.set.body.region-body");
        this.writeEmptyTag(REGION_BEFORE_TAG, "layout.master.set.body.region-before");
        this.writeEmptyTag(REGION_AFTER_TAG, "layout.master.set.body.region-after");
        this.writeEndTag(SIMPLE_PAGE_MASTER_TAG);
        this.writeEOL();
        this.writeEndTag(LAYOUT_MASTER_SET_TAG);
        this.writeEOL();
        this.pdfBookmarks();
    }

    public void endDocument() {
        this.writeEndTag(ROOT_TAG);
        this.writeEOL();
        this.flush();
        this.close();
    }

    protected FoConfiguration getFoConfiguration() {
        return this.config;
    }

    protected void writeStartTag(HTML.Tag tag, String attributeId) {
        this.writeEOL();
        this.writeStartTag(tag, this.config.getAttributeSet(attributeId));
    }

    protected void writeStartTag(HTML.Tag tag, String id, String name) {
        this.writeEOL();
        SimpleAttributeSet att = new SimpleAttributeSet();
        att.addAttribute(id, name);
        this.writeStartTag(tag, att);
    }

    protected void writeStartTag(HTML.Tag tag, String id, String name, String attributeId) {
        MutableAttributeSet att = this.config.getAttributeSet(attributeId);
        if (att.isDefined(id)) {
            att.removeAttribute(id);
        }
        att.addAttribute(id, name);
        this.writeEOL();
        this.writeStartTag(tag, att);
    }

    protected void writeEmptyTag(HTML.Tag tag, String id, String name) {
        SimpleAttributeSet att = new SimpleAttributeSet();
        att.addAttribute(id, name);
        this.writeEOL();
        this.writeSimpleTag(tag, att);
    }

    protected void writeEmptyTag(HTML.Tag tag, String attributeId) {
        this.writeEOL();
        this.writeSimpleTag(tag, this.config.getAttributeSet(attributeId));
    }

    protected void write(String text) {
        this.tempWriter.write(FoSink.unifyEOLs((String)text));
    }

    protected void writeln(String text) {
        this.write(text);
        this.writeEOL();
    }

    protected void content(String text) {
        this.write(FoSink.escaped(text, this.verbatim));
    }

    public static String escaped(String text, boolean verb) {
        int length = text.length();
        StringBuffer buffer = new StringBuffer(length);
        block8: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case ' ': {
                    if (verb) {
                        buffer.append("&#160;");
                        continue block8;
                    }
                    buffer.append(c);
                    continue block8;
                }
                case '<': {
                    buffer.append("&lt;");
                    continue block8;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block8;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block8;
                }
                case '\u00a9': {
                    buffer.append("&#169;");
                    continue block8;
                }
                case '\n': {
                    buffer.append(EOL);
                    if (!verb) continue block8;
                    buffer.append("<fo:block/>" + EOL);
                    continue block8;
                }
                default: {
                    buffer.append(c);
                }
            }
        }
        return buffer.toString();
    }

    protected void startPageSequence(String initPageNumber, String headerText, String footerText) {
        this.writeln("<fo:page-sequence initial-page-number=\"" + initPageNumber + "\" master-reference=\"body\">");
        this.regionBefore(headerText);
        this.regionAfter(footerText);
        this.writeln("<fo:flow flow-name=\"xsl-region-body\">");
        this.chapterHeading(null, true);
    }

    protected void regionBefore(String headerText) {
    }

    protected void regionAfter(String footerText) {
    }

    protected void chapterHeading(String headerText, boolean chapterNumber) {
    }

    protected void pdfBookmarks() {
    }
}

