/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.docbook;

import java.io.StringWriter;
import java.io.Writer;
import java.util.StringTokenizer;
import javax.swing.text.SimpleAttributeSet;
import javax.swing.text.html.HTML;
import org.apache.maven.doxia.module.docbook.DocbookMarkup;
import org.apache.maven.doxia.sink.AbstractXmlSink;
import org.apache.maven.doxia.sink.StructureSink;
import org.apache.maven.doxia.util.LineBreaker;
import org.codehaus.plexus.util.FileUtils;

public class DocBookSink
extends AbstractXmlSink
implements DocbookMarkup {
    public static final String DEFAULT_SGML_PUBLIC_ID = "-//OASIS//DTD DocBook V4.1//EN";
    public static final String DEFAULT_XML_PUBLIC_ID = "-//OASIS//DTD DocBook XML V4.1.2//EN";
    public static final String DEFAULT_XML_SYSTEM_ID = "http://www.oasis-open.org/docbook/xml/4.0/docbookx.dtd";
    private LineBreaker out;
    private boolean xmlMode = false;
    private String encoding = null;
    private String styleSheet = null;
    private String lang = null;
    private String publicId = null;
    private String systemId = null;
    private String italicBeginTag;
    private String italicEndTag;
    private String boldBeginTag;
    private String boldEndTag;
    private String monospacedBeginTag;
    private String monospacedEndTag;
    private String horizontalRuleElement;
    private String pageBreakElement;
    private String lineBreakElement;
    private String graphicsFileName;
    private boolean hasTitle;
    private boolean authorDateFlag;
    private boolean verbatimFlag;
    private boolean externalLinkFlag;
    private boolean tableHasCaption;
    private LineBreaker savedOut;
    private String tableRows;
    private boolean tableHasGrid;
    private boolean isBook;
    private boolean skip;
    private boolean outputBookHead;

    public DocBookSink(Writer out, boolean isBook) {
        this(out);
        this.isBook = isBook;
        this.outputBookHead = true;
    }

    public DocBookSink(Writer writer) {
        this.out = new LineBreaker(writer);
        this.setItalicElement("<emphasis>");
        this.setBoldElement("<emphasis role=\"bold\">");
        this.setMonospacedElement("<literal>");
        this.setHorizontalRuleElement("<!-- HR -->");
        this.setPageBreakElement("<!-- PB -->");
        this.setLineBreakElement("<!-- LB -->");
    }

    public static final String escapeSGML(String text, boolean xmlMode) {
        int length = text.length();
        StringBuffer buffer = new StringBuffer(length);
        block6: for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            switch (c) {
                case '<': {
                    buffer.append("&lt;");
                    continue block6;
                }
                case '>': {
                    buffer.append("&gt;");
                    continue block6;
                }
                case '&': {
                    buffer.append("&amp;");
                    continue block6;
                }
                case '\"': {
                    buffer.append("&quot;");
                    continue block6;
                }
                default: {
                    if (xmlMode) {
                        buffer.append(c);
                        continue block6;
                    }
                    if (c <= '~') {
                        buffer.append(c);
                        continue block6;
                    }
                    buffer.append("&#");
                    buffer.append((int)c);
                    buffer.append(';');
                }
            }
        }
        return buffer.toString();
    }

    public void setXMLMode(boolean mode) {
        this.xmlMode = mode;
    }

    public boolean isXMLMode() {
        return this.xmlMode;
    }

    public void setEncoding(String enc) {
        this.encoding = enc;
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setStyleSheet(String sheet) {
        this.styleSheet = sheet;
    }

    public String getStyleSheet() {
        return this.styleSheet;
    }

    public void setPublicId(String id) {
        this.publicId = id;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setSystemId(String id) {
        this.systemId = id;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setLanguage(String language) {
        this.lang = language;
    }

    public String getLanguage() {
        return this.lang;
    }

    public void setItalicElement(String tag) {
        if (tag == null) {
            tag = "";
        }
        this.italicBeginTag = tag;
        this.italicEndTag = this.makeEndTag(this.italicBeginTag);
    }

    private String makeEndTag(String beginTag) {
        int length = beginTag.length();
        if (length == 0) {
            return "";
        }
        if (beginTag.charAt(0) != '<' || beginTag.charAt(length - 1) != '>') {
            throw new IllegalArgumentException("'" + beginTag + "', not a tag");
        }
        StringTokenizer tokens = new StringTokenizer(beginTag, "<> \t\n\r\f");
        if (!tokens.hasMoreTokens()) {
            throw new IllegalArgumentException("'" + beginTag + "', invalid tag");
        }
        return "</" + tokens.nextToken() + ">";
    }

    public String getItalicElement() {
        return this.italicBeginTag;
    }

    public void setBoldElement(String tag) {
        if (tag == null) {
            tag = "";
        }
        this.boldBeginTag = tag;
        this.boldEndTag = this.makeEndTag(this.boldBeginTag);
    }

    public String getBoldElement() {
        return this.boldBeginTag;
    }

    public void setMonospacedElement(String tag) {
        if (tag == null) {
            tag = "";
        }
        this.monospacedBeginTag = tag;
        this.monospacedEndTag = this.makeEndTag(this.monospacedBeginTag);
    }

    public String getMonospacedElement() {
        return this.monospacedBeginTag;
    }

    public void setHorizontalRuleElement(String element) {
        this.horizontalRuleElement = element;
    }

    public String getHorizontalRuleElement() {
        return this.horizontalRuleElement;
    }

    public void setPageBreakElement(String element) {
        this.pageBreakElement = element;
    }

    public String getPageBreakElement() {
        return this.pageBreakElement;
    }

    public void setLineBreakElement(String element) {
        this.lineBreakElement = element;
    }

    public String getLineBreakElement() {
        return this.lineBreakElement;
    }

    private void resetState() {
        this.hasTitle = false;
        this.authorDateFlag = false;
        this.verbatimFlag = false;
        this.externalLinkFlag = false;
        this.graphicsFileName = null;
        this.tableHasCaption = false;
        this.savedOut = null;
        this.tableRows = null;
        this.tableHasGrid = false;
    }

    public void head() {
        this.resetState();
        boolean bl = this.skip = this.isBook && !this.outputBookHead;
        if (this.xmlMode) {
            this.markup("<?xml version=\"1.0\"");
            if (this.encoding != null) {
                this.markup(" encoding=\"" + this.encoding + "\"");
            }
            this.markup(" ?>\n");
            if (this.styleSheet != null) {
                this.markup("<?xml-stylesheet type=\"text/css\"" + EOL + "href=\"" + this.styleSheet + "\" ?>" + EOL);
            }
        }
        if (this.isBook) {
            this.markup("<!DOCTYPE book PUBLIC");
        } else {
            this.markup("<!DOCTYPE article PUBLIC");
        }
        String pubId = this.publicId == null ? (this.xmlMode ? DEFAULT_XML_PUBLIC_ID : DEFAULT_SGML_PUBLIC_ID) : this.publicId;
        this.markup(" \"" + pubId + "\"");
        String sysId = this.systemId;
        if (sysId == null && this.xmlMode) {
            sysId = DEFAULT_XML_SYSTEM_ID;
        }
        if (sysId == null) {
            this.markup(">" + EOL);
        } else {
            this.markup(EOL + "\"" + sysId + "\">" + EOL);
        }
        SimpleAttributeSet att = new SimpleAttributeSet();
        if (this.lang != null) {
            att.addAttribute(HTML.Attribute.LANG, this.lang);
        }
        if (this.isBook) {
            this.skip = false;
            this.writeStartTag(CHAPTER_TAG, att);
        } else {
            this.writeStartTag(ARTICLE_TAG, att);
        }
    }

    public void head_() {
        if (this.hasTitle) {
            if (this.isBook) {
                this.writeEndTag(BOOKINFO_TAG);
            } else {
                this.writeEndTag(ARTICLEINFO_TAG);
            }
            this.hasTitle = false;
            this.skip = false;
            this.outputBookHead = false;
        }
    }

    public void title() {
        if (this.isBook) {
            this.writeStartTag(BOOKINFO_TAG);
        } else {
            this.writeStartTag(ARTICLEINFO_TAG);
        }
        this.hasTitle = true;
        this.writeStartTag(HTML.Tag.TITLE);
    }

    public void title_() {
        this.writeEndTag(HTML.Tag.TITLE);
    }

    public void author() {
        this.authorDateFlag = true;
        this.writeStartTag(CORPAUTHOR_TAG);
    }

    public void author_() {
        this.writeEndTag(CORPAUTHOR_TAG);
        this.authorDateFlag = false;
    }

    public void date() {
        this.authorDateFlag = true;
        this.writeStartTag(DATE_TAG);
    }

    public void date_() {
        this.writeEndTag(DATE_TAG);
        this.authorDateFlag = false;
    }

    public void body_() {
        if (this.isBook) {
            this.writeEndTag(CHAPTER_TAG);
        } else {
            this.writeEndTag(ARTICLE_TAG);
        }
        this.out.flush();
        this.resetState();
    }

    public void book() {
        this.writeStartTag(BOOK_TAG);
    }

    public void book_() {
        this.writeEndTag(BOOK_TAG);
        this.out.flush();
    }

    public void section1() {
        this.writeStartTag(SECTION_TAG);
    }

    public void section1_() {
        this.writeEndTag(SECTION_TAG);
    }

    public void section2() {
        this.writeStartTag(SECTION_TAG);
    }

    public void section2_() {
        this.writeEndTag(SECTION_TAG);
    }

    public void section3() {
        this.writeStartTag(SECTION_TAG);
    }

    public void section3_() {
        this.writeEndTag(SECTION_TAG);
    }

    public void section4() {
        this.writeStartTag(SECTION_TAG);
    }

    public void section4_() {
        this.writeEndTag(SECTION_TAG);
    }

    public void section5() {
        this.writeStartTag(SECTION_TAG);
    }

    public void section5_() {
        this.writeEndTag(SECTION_TAG);
    }

    public void sectionTitle() {
        this.writeStartTag(HTML.Tag.TITLE);
    }

    public void sectionTitle_() {
        this.writeEndTag(HTML.Tag.TITLE);
    }

    public void list() {
        this.writeStartTag(ITEMIZEDLIST_TAG);
    }

    public void list_() {
        this.writeEndTag(ITEMIZEDLIST_TAG);
    }

    public void listItem() {
        this.writeStartTag(LISTITEM_TAG);
    }

    public void listItem_() {
        this.writeEndTag(LISTITEM_TAG);
    }

    public void numberedList(int numbering) {
        String numeration;
        switch (numbering) {
            case 2: {
                numeration = "upperalpha";
                break;
            }
            case 1: {
                numeration = "loweralpha";
                break;
            }
            case 4: {
                numeration = "upperroman";
                break;
            }
            case 3: {
                numeration = "lowerroman";
                break;
            }
            default: {
                numeration = "arabic";
            }
        }
        SimpleAttributeSet att = new SimpleAttributeSet();
        att.addAttribute("numeration", numeration);
        this.writeStartTag(ORDEREDLIST_TAG, att);
    }

    public void numberedList_() {
        this.writeEndTag(ORDEREDLIST_TAG);
    }

    public void numberedListItem() {
        this.writeStartTag(LISTITEM_TAG);
    }

    public void numberedListItem_() {
        this.writeEndTag(LISTITEM_TAG);
    }

    public void definitionList() {
        this.writeStartTag(VARIABLELIST_TAG);
    }

    public void definitionList_() {
        this.writeEndTag(VARIABLELIST_TAG);
    }

    public void definitionListItem() {
        this.writeStartTag(VARLISTENTRY_TAG);
    }

    public void definitionListItem_() {
        this.writeEndTag(VARLISTENTRY_TAG);
    }

    public void definedTerm() {
        this.writeStartTag(TERM_TAG);
    }

    public void definedTerm_() {
        this.writeEndTag(TERM_TAG);
    }

    public void definition() {
        this.writeStartTag(LISTITEM_TAG);
    }

    public void definition_() {
        this.writeEndTag(LISTITEM_TAG);
    }

    public void paragraph() {
        this.writeStartTag(PARA_TAG);
    }

    public void paragraph_() {
        this.writeEndTag(PARA_TAG);
    }

    public void verbatim(boolean boxed) {
        this.verbatimFlag = true;
        this.writeStartTag(PROGRAMLISTING_TAG);
    }

    public void verbatim_() {
        this.writeEndTag(PROGRAMLISTING_TAG);
        this.verbatimFlag = false;
    }

    public void horizontalRule() {
        this.markup(this.horizontalRuleElement + EOL);
    }

    public void pageBreak() {
        this.markup(this.pageBreakElement + EOL);
    }

    public void figure_() {
        this.graphicElement();
    }

    protected void graphicElement() {
        if (this.graphicsFileName != null) {
            String format = FileUtils.extension((String)this.graphicsFileName).toUpperCase();
            if (format.length() == 0) {
                format = "JPEG";
            }
            this.writeStartTag(MEDIAOBJECT_TAG);
            this.writeStartTag(IMAGEOBJECT_TAG);
            SimpleAttributeSet att = new SimpleAttributeSet();
            att.addAttribute("format", format);
            att.addAttribute("fileref", DocBookSink.escapeSGML(this.graphicsFileName, this.xmlMode));
            if (this.xmlMode) {
                this.writeSimpleTag(IMAGEDATA_TAG, att);
            } else {
                this.writeStartTag(IMAGEDATA_TAG, att);
                this.writeEndTag(IMAGEDATA_TAG);
            }
            this.writeEndTag(IMAGEOBJECT_TAG);
            this.writeEndTag(MEDIAOBJECT_TAG);
            this.graphicsFileName = null;
        }
    }

    public void figureGraphics(String name) {
        this.graphicsFileName = name + ".jpeg";
    }

    public void figureCaption() {
        this.writeStartTag(FIGURE_TAG);
        this.writeStartTag(HTML.Tag.TITLE);
    }

    public void figureCaption_() {
        this.writeEndTag(HTML.Tag.TITLE);
        this.graphicElement();
        this.writeEndTag(FIGURE_TAG);
    }

    public void table() {
        this.tableHasCaption = false;
    }

    public void table_() {
        if (this.tableHasCaption) {
            this.tableHasCaption = false;
            this.out.write(this.tableRows, true);
            this.writeEndTag(HTML.Tag.TABLE);
        } else {
            int sep;
            String frame;
            if (this.tableHasGrid) {
                frame = "all";
                sep = 1;
            } else {
                frame = "none";
                sep = 0;
            }
            SimpleAttributeSet att = new SimpleAttributeSet();
            att.addAttribute("frame", frame);
            att.addAttribute("rowsep", String.valueOf(sep));
            att.addAttribute("colsep", String.valueOf(sep));
            this.writeStartTag(INFORMALTABLE_TAG, att);
            this.out.write(this.tableRows, true);
            this.writeEndTag(INFORMALTABLE_TAG);
        }
        this.tableRows = null;
        this.tableHasGrid = false;
    }

    public void tableRows(int[] justification, boolean grid) {
        this.tableHasGrid = grid;
        this.out.flush();
        this.savedOut = this.out;
        this.out = new LineBreaker((Writer)new StringWriter());
        SimpleAttributeSet att = new SimpleAttributeSet();
        att.addAttribute("cols", String.valueOf(justification.length));
        this.writeStartTag(TGROUP_TAG, att);
        for (int i = 0; i < justification.length; ++i) {
            String justif;
            switch (justification[i]) {
                case 1: {
                    justif = "left";
                    break;
                }
                case 2: {
                    justif = "right";
                    break;
                }
                default: {
                    justif = "center";
                }
            }
            att = new SimpleAttributeSet();
            att.addAttribute(HTML.Attribute.ALIGN.toString(), justif);
            if (this.xmlMode) {
                this.writeSimpleTag(COLSPEC_TAG, att);
                continue;
            }
            this.writeStartTag(COLSPEC_TAG, att);
            this.writeEndTag(COLSPEC_TAG);
        }
        this.writeStartTag(TBODY_TAG);
    }

    public void tableRows_() {
        this.writeEndTag(TBODY_TAG);
        this.writeEndTag(TGROUP_TAG);
        this.out.flush();
        this.tableRows = ((StringWriter)this.out.getDestination()).toString();
        this.out = this.savedOut;
    }

    public void tableRow() {
        this.writeStartTag(ROW_TAG);
    }

    public void tableRow_() {
        this.writeEndTag(ROW_TAG);
    }

    public void tableCell() {
        this.writeStartTag(ENTRY_TAG);
        this.writeStartTag(PARA_TAG);
    }

    public void tableCell_() {
        this.writeEndTag(PARA_TAG);
        this.writeEndTag(ENTRY_TAG);
    }

    public void tableCaption() {
        int sep;
        String frame;
        this.tableHasCaption = true;
        if (this.tableHasGrid) {
            frame = "all";
            sep = 1;
        } else {
            frame = "none";
            sep = 0;
        }
        SimpleAttributeSet att = new SimpleAttributeSet();
        att.addAttribute("frame", frame);
        att.addAttribute("rowsep", String.valueOf(sep));
        att.addAttribute("colsep", String.valueOf(sep));
        this.writeStartTag(HTML.Tag.TABLE, att);
        this.writeStartTag(HTML.Tag.TITLE);
    }

    public void tableCaption_() {
        this.writeEndTag(HTML.Tag.TITLE);
    }

    public void anchor(String name) {
        if (!this.authorDateFlag) {
            SimpleAttributeSet att = new SimpleAttributeSet();
            att.addAttribute(HTML.Attribute.ID, "a." + StructureSink.linkToKey((String)name));
            if (this.xmlMode) {
                this.writeSimpleTag(ANCHOR_TAG, att);
            } else {
                this.writeStartTag(ANCHOR_TAG, att);
            }
        }
    }

    public void anchor_() {
        if (!this.authorDateFlag && !this.xmlMode) {
            this.writeEndTagWithoutEOL(ANCHOR_TAG);
        }
    }

    public void link(String name) {
        if (StructureSink.isExternalLink((String)name)) {
            this.externalLinkFlag = true;
            SimpleAttributeSet att = new SimpleAttributeSet();
            att.addAttribute("url", DocBookSink.escapeSGML(name, this.xmlMode));
            this.writeStartTag(ULINK_TAG, att);
        } else {
            SimpleAttributeSet att = new SimpleAttributeSet();
            att.addAttribute("linkend", "a." + StructureSink.linkToKey((String)name));
            this.writeStartTag(LINK_TAG, att);
        }
    }

    public void link_() {
        if (this.externalLinkFlag) {
            this.writeEndTagWithoutEOL(ULINK_TAG);
            this.externalLinkFlag = false;
        } else {
            this.writeEndTagWithoutEOL(LINK_TAG);
        }
    }

    public void italic() {
        this.markup(this.italicBeginTag);
    }

    public void italic_() {
        this.markup(this.italicEndTag);
    }

    public void bold() {
        this.markup(this.boldBeginTag);
    }

    public void bold_() {
        this.markup(this.boldEndTag);
    }

    public void monospaced() {
        if (!this.authorDateFlag) {
            this.markup(this.monospacedBeginTag);
        }
    }

    public void monospaced_() {
        if (!this.authorDateFlag) {
            this.markup(this.monospacedEndTag);
        }
    }

    public void lineBreak() {
        this.markup(this.lineBreakElement + EOL);
    }

    public void nonBreakingSpace() {
        this.markup("&#x00A0;");
    }

    public void text(String text) {
        if (this.verbatimFlag) {
            this.verbatimContent(text);
        } else {
            this.content(text);
        }
    }

    protected void markup(String text) {
        if (!this.skip) {
            this.out.write(text, true);
        }
    }

    protected void content(String text) {
        if (!this.skip) {
            this.out.write(DocBookSink.escapeSGML(text, this.xmlMode), false);
        }
    }

    protected void verbatimContent(String text) {
        if (!this.skip) {
            this.out.write(DocBookSink.escapeSGML(text, this.xmlMode), true);
        }
    }

    public void flush() {
        this.out.flush();
    }

    public void close() {
        this.out.close();
    }

    protected void write(String text) {
        this.markup(text);
    }
}

