/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.confluence.parser.list;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

class TreeComponent {
    private static final String EOL = System.getProperty("line.separator");
    private List children = new ArrayList();
    private String text;
    private TreeComponent father;
    private int type;

    TreeComponent(TreeComponent father, String text, int type) {
        this.text = text;
        this.father = father;
        this.type = type;
    }

    List getChildren() {
        return this.children;
    }

    TreeComponent addChildren(String t, int ttype) {
        if (t == null) {
            throw new IllegalArgumentException("argument is null");
        }
        TreeComponent ret = new TreeComponent(this, t, ttype);
        this.children.add(ret);
        return ret;
    }

    TreeComponent getFather() {
        return this.father;
    }

    int getDepth() {
        int ret = 0;
        TreeComponent c = this;
        while ((c = c.getFather()) != null) {
            ++ret;
        }
        return ret;
    }

    public String toString() {
        return this.toString("");
    }

    String toString(String indent) {
        StringBuffer sb = new StringBuffer();
        if (this.father != null) {
            sb.append(indent);
            sb.append("- ");
            sb.append(this.text);
            sb.append(EOL);
        }
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            TreeComponent lc = (TreeComponent)i.next();
            sb.append(lc.toString(indent + "   "));
        }
        return sb.toString();
    }

    String getText() {
        return this.text;
    }

    int getType() {
        return this.type;
    }
}

