/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.doxia.module.apt;

import org.apache.maven.doxia.util.DoxiaUtils;

public class AptUtils {
    public static String encodeFragment(String text) {
        if (text == null) {
            return null;
        }
        return AptUtils.linkToKey(text);
    }

    public static boolean isExternalLink(String link) {
        return DoxiaUtils.isExternalLink((String)link);
    }

    public static boolean isInternalLink(String link) {
        return !AptUtils.isExternalLink(link) && !AptUtils.isLocalLink(link);
    }

    public static boolean isLocalLink(String link) {
        return link.startsWith("/") || link.startsWith("./") || link.startsWith("../");
    }

    public static String linkToKey(String text) {
        int length = text.length();
        StringBuffer buffer = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = text.charAt(i);
            if (!Character.isLetterOrDigit(c)) continue;
            buffer.append(Character.toLowerCase(c));
        }
        return buffer.toString();
    }

    public static String encodeAnchor(String id) {
        if (id == null) {
            return null;
        }
        id = id.trim();
        int length = id.length();
        StringBuffer buffer = new StringBuffer(length);
        for (int i = 0; i < length; ++i) {
            char c = id.charAt(i);
            if (i == 0 && !Character.isLetter(c)) {
                buffer.append('a');
            }
            if (c == ' ') {
                buffer.append('_');
                continue;
            }
            if (!Character.isLetterOrDigit(c) && c != '-' && c != '_' && c != ':' && c != '.') continue;
            buffer.append(c);
        }
        return buffer.toString();
    }

    private AptUtils() {
    }
}

