/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.lang3.Validate;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.lifecycle.LifecycleExecutionException;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.CacheUtils;
import org.apache.maven.plugin.ProjectArtifactsCache;
import org.apache.maven.project.MavenProject;
import org.codehaus.plexus.component.annotations.Component;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.repository.LocalRepository;
import org.eclipse.aether.repository.RemoteRepository;
import org.eclipse.aether.repository.WorkspaceRepository;

@Component(role=ProjectArtifactsCache.class)
public class DefaultProjectArtifactsCache
implements ProjectArtifactsCache {
    protected final Map<ProjectArtifactsCache.Key, ProjectArtifactsCache.CacheRecord> cache = new ConcurrentHashMap<ProjectArtifactsCache.Key, ProjectArtifactsCache.CacheRecord>();

    @Override
    public ProjectArtifactsCache.Key createKey(MavenProject project, Collection<String> scopesToCollect, Collection<String> scopesToResolve, boolean aggregating, RepositorySystemSession session) {
        return new CacheKey(project, project.getRemoteProjectRepositories(), scopesToCollect, scopesToResolve, aggregating, session);
    }

    @Override
    public ProjectArtifactsCache.CacheRecord get(ProjectArtifactsCache.Key key) throws LifecycleExecutionException {
        ProjectArtifactsCache.CacheRecord cacheRecord = this.cache.get(key);
        if (cacheRecord != null && cacheRecord.exception != null) {
            throw cacheRecord.exception;
        }
        return cacheRecord;
    }

    @Override
    public ProjectArtifactsCache.CacheRecord put(ProjectArtifactsCache.Key key, Set<Artifact> projectArtifacts) {
        Validate.notNull(projectArtifacts, (String)"projectArtifacts cannot be null", (Object[])new Object[0]);
        this.assertUniqueKey(key);
        ProjectArtifactsCache.CacheRecord record = new ProjectArtifactsCache.CacheRecord(Collections.unmodifiableSet(new HashSet<Artifact>(projectArtifacts)));
        this.cache.put(key, record);
        return record;
    }

    protected void assertUniqueKey(ProjectArtifactsCache.Key key) {
        if (this.cache.containsKey(key)) {
            throw new IllegalStateException("Duplicate artifact resolution result for project " + key);
        }
    }

    @Override
    public ProjectArtifactsCache.CacheRecord put(ProjectArtifactsCache.Key key, LifecycleExecutionException exception) {
        Validate.notNull((Object)exception, (String)"exception cannot be null", (Object[])new Object[0]);
        this.assertUniqueKey(key);
        ProjectArtifactsCache.CacheRecord record = new ProjectArtifactsCache.CacheRecord(exception);
        this.cache.put(key, record);
        return record;
    }

    @Override
    public void flush() {
        this.cache.clear();
    }

    protected static int pluginHashCode(Plugin plugin) {
        return CacheUtils.pluginHashCode(plugin);
    }

    protected static boolean pluginEquals(Plugin a, Plugin b) {
        return CacheUtils.pluginEquals(a, b);
    }

    @Override
    public void register(MavenProject project, ProjectArtifactsCache.Key cacheKey, ProjectArtifactsCache.CacheRecord record) {
    }

    protected static class CacheKey
    implements ProjectArtifactsCache.Key {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final Set<String> dependencyArtifacts;
        private final WorkspaceRepository workspace;
        private final LocalRepository localRepo;
        private final List<RemoteRepository> repositories;
        private final Set<String> collect;
        private final Set<String> resolve;
        private boolean aggregating;
        private final int hashCode;

        public CacheKey(MavenProject project, List<RemoteRepository> repositories, Collection<String> scopesToCollect, Collection<String> scopesToResolve, boolean aggregating, RepositorySystemSession session) {
            this.groupId = project.getGroupId();
            this.artifactId = project.getArtifactId();
            this.version = project.getVersion();
            HashSet<String> deps = new HashSet<String>();
            if (project.getDependencyArtifacts() != null) {
                for (Artifact dep : project.getDependencyArtifacts()) {
                    deps.add(dep.toString());
                }
            }
            this.dependencyArtifacts = Collections.unmodifiableSet(deps);
            this.workspace = CacheUtils.getWorkspace(session);
            this.localRepo = session.getLocalRepository();
            this.repositories = new ArrayList<RemoteRepository>(repositories.size());
            for (RemoteRepository repository : repositories) {
                if (repository.isRepositoryManager()) {
                    this.repositories.addAll(repository.getMirroredRepositories());
                    continue;
                }
                this.repositories.add(repository);
            }
            this.collect = scopesToCollect == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(scopesToCollect));
            this.resolve = scopesToResolve == null ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet<String>(scopesToResolve));
            this.aggregating = aggregating;
            int hash = 17;
            hash = hash * 31 + CacheKey.hash(this.groupId);
            hash = hash * 31 + CacheKey.hash(this.artifactId);
            hash = hash * 31 + CacheKey.hash(this.version);
            hash = hash * 31 + CacheKey.hash(this.dependencyArtifacts);
            hash = hash * 31 + CacheKey.hash(this.workspace);
            hash = hash * 31 + CacheKey.hash(this.localRepo);
            hash = hash * 31 + CacheUtils.repositoriesHashCode(repositories);
            hash = hash * 31 + CacheKey.hash(this.collect);
            hash = hash * 31 + CacheKey.hash(this.resolve);
            this.hashCode = hash = hash * 31 + CacheKey.hash(aggregating);
        }

        public String toString() {
            return this.groupId + ":" + this.artifactId + ":" + this.version;
        }

        public int hashCode() {
            return this.hashCode;
        }

        private static int hash(Object obj) {
            return obj != null ? obj.hashCode() : 0;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CacheKey)) {
                return false;
            }
            CacheKey that = (CacheKey)o;
            return CacheKey.eq(this.groupId, that.groupId) && CacheKey.eq(this.artifactId, that.artifactId) && CacheKey.eq(this.version, that.version) && CacheKey.eq(this.dependencyArtifacts, that.dependencyArtifacts) && CacheKey.eq(this.workspace, that.workspace) && CacheKey.eq(this.localRepo, that.localRepo) && CacheUtils.repositoriesEquals(this.repositories, that.repositories) && CacheKey.eq(this.collect, that.collect) && CacheKey.eq(this.resolve, that.resolve) && this.aggregating == that.aggregating;
        }

        private static <T> boolean eq(T s1, T s2) {
            return s1 != null ? s1.equals(s2) : s2 == null;
        }
    }
}

